/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.ThreadMainFactoryBuilder;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExecutorsUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutorsUtils.class);
    @Inject
    private ThreadMainFactoryBuilder threadFactoryBuilder;
    @Inject
    private MeterRegistry meterRegistry;

    public ExecutorService cachedThreadPool(String name) {
        return this.wrap(name, Executors.newCachedThreadPool(this.threadFactoryBuilder.build(name + "_%d")));
    }

    public ExecutorService maxCachedThreadPool(int maxThread, String name) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(maxThread, maxThread, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), this.threadFactoryBuilder.build(name + "_%d"));
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return this.wrap(name, threadPoolExecutor);
    }

    public ExecutorService singleThreadExecutor(String name) {
        return this.wrap(name, Executors.newSingleThreadExecutor(this.threadFactoryBuilder.build(name + "_%d")));
    }

    public ExecutorService singleThreadScheduledExecutor(String name) {
        return this.wrap(name, Executors.newSingleThreadScheduledExecutor(this.threadFactoryBuilder.build(name + "_%d")));
    }

    public static void closeScheduledThreadPool(ScheduledExecutorService scheduledExecutorService, Duration gracePeriod, List<ScheduledFuture<?>> taskFutures) {
        scheduledExecutorService.shutdown();
        if (scheduledExecutorService.isTerminated()) {
            return;
        }
        try {
            if (!scheduledExecutorService.awaitTermination(gracePeriod.toMillis(), TimeUnit.MILLISECONDS)) {
                log.warn("Failed to shutdown the ScheduledThreadPoolExecutor during grace period, forcing it to shutdown now");
                ListUtils.emptyOnNull(taskFutures).forEach(taskFuture -> taskFuture.cancel(true));
                scheduledExecutorService.shutdownNow();
            }
            log.debug("Stopped scheduled ScheduledThreadPoolExecutor.");
        }
        catch (InterruptedException e) {
            scheduledExecutorService.shutdownNow();
            Thread.currentThread().interrupt();
            log.debug("Failed to shutdown the ScheduledThreadPoolExecutor.");
        }
    }

    private ExecutorService wrap(String name, ExecutorService executorService) {
        return ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ExecutorService)executorService, (String)name, (Tag[])new Tag[0]);
    }
}

