/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.hierarchies.AbstractGraph;
import io.kestra.core.models.hierarchies.AbstractGraphTask;
import io.kestra.core.models.hierarchies.FlowGraph;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.GraphClusterAfterExecution;
import io.kestra.core.models.hierarchies.GraphClusterEnd;
import io.kestra.core.models.hierarchies.GraphClusterFinally;
import io.kestra.core.models.hierarchies.GraphTask;
import io.kestra.core.models.hierarchies.GraphTrigger;
import io.kestra.core.models.hierarchies.Relation;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.hierarchies.SubflowGraphTask;
import io.kestra.core.models.tasks.ExecutableTask;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.utils.ListUtils;
import io.kestra.plugin.core.flow.Dag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class GraphUtils {
    public static FlowGraph flowGraph(Flow flow, Execution execution) throws IllegalVariableEvaluationException {
        return GraphUtils.flowGraph(flow, execution, null);
    }

    public static FlowGraph flowGraph(Flow flow, Execution execution, List<Trigger> triggers) throws IllegalVariableEvaluationException {
        return FlowGraph.of(GraphUtils.of(flow, execution, triggers));
    }

    public static GraphCluster of(GraphCluster graph, Flow flow, Execution execution, List<Trigger> triggers) throws IllegalVariableEvaluationException {
        if (graph == null) {
            graph = new GraphCluster();
        }
        if (flow.getTriggers() != null) {
            GraphCluster triggersClusters = GraphUtils.triggers(graph, flow.getTriggers(), triggers);
            graph.addEdge(triggersClusters.getEnd(), graph.getRoot(), new Relation());
        }
        GraphUtils.sequential(graph, flow.getTasks(), flow.getErrors(), flow.getFinally(), flow.getAfterExecution(), null, execution);
        return graph;
    }

    public static GraphCluster of(Flow flow, Execution execution) throws IllegalVariableEvaluationException {
        return GraphUtils.of(flow, execution, null);
    }

    public static GraphCluster of(Flow flow, Execution execution, List<Trigger> triggers) throws IllegalVariableEvaluationException {
        return GraphUtils.of(new GraphCluster(), flow, execution, triggers);
    }

    public static GraphCluster triggers(GraphCluster graph, List<AbstractTrigger> triggersDeclarations, List<Trigger> triggers) throws IllegalVariableEvaluationException {
        GraphCluster triggerCluster = new GraphCluster("Triggers");
        graph.addNode(triggerCluster);
        Map triggersById = Optional.ofNullable(triggers).map(Collection::stream).map(s -> s.collect(Collectors.toMap(TriggerContext::getTriggerId, Function.identity(), (a, b) -> a.getNamespace().length() <= b.getNamespace().length() ? a : b))).orElse(Collections.emptyMap());
        triggersDeclarations.stream().filter(trigger -> trigger != null).forEach(trigger -> {
            GraphTrigger triggerNode = new GraphTrigger((AbstractTrigger)trigger, (Trigger)triggersById.get(trigger.getId()));
            triggerCluster.addNode(triggerNode);
            triggerCluster.addEdge(triggerCluster.getRoot(), triggerNode, new Relation());
            triggerCluster.addEdge(triggerNode, triggerCluster.getEnd(), new Relation());
        });
        GraphUtils.removeFinally(triggerCluster);
        GraphUtils.removeAfterExecution(triggerCluster);
        return triggerCluster;
    }

    public static List<AbstractGraph> nodes(GraphCluster graphCluster) {
        return graphCluster.getGraph().nodes().stream().flatMap(t -> {
            Stream<AbstractGraph> stream;
            if (t instanceof GraphCluster) {
                GraphCluster cluster = (GraphCluster)t;
                stream = GraphUtils.nodes(cluster).stream();
            } else {
                stream = Stream.of(t);
            }
            return stream;
        }).distinct().toList();
    }

    private static List<Triple<AbstractGraph, AbstractGraph, Relation>> rawEdges(GraphCluster graphCluster) {
        return Stream.concat(graphCluster.getGraph().edges().stream().map(r -> Triple.of((Object)((AbstractGraph)r.getSource()), (Object)((AbstractGraph)r.getTarget()), (Object)((Relation)r.getValue()))), graphCluster.getGraph().nodes().stream().flatMap(t -> {
            Stream<Object> stream;
            if (t instanceof GraphCluster) {
                GraphCluster cluster = (GraphCluster)t;
                stream = GraphUtils.rawEdges(cluster).stream();
            } else {
                stream = Stream.of(new Triple[0]);
            }
            return stream;
        })).toList();
    }

    public static List<FlowGraph.Edge> edges(GraphCluster graphCluster) {
        return GraphUtils.rawEdges(graphCluster).stream().map(r -> new FlowGraph.Edge(((AbstractGraph)r.getLeft()).getUid(), ((AbstractGraph)r.getMiddle()).getUid(), (Relation)r.getRight())).toList();
    }

    public static List<Pair<GraphCluster, List<String>>> clusters(GraphCluster graphCluster, List<String> parents) {
        return graphCluster.getGraph().nodes().stream().flatMap(t -> {
            if (t instanceof GraphCluster) {
                GraphCluster cluster = (GraphCluster)t;
                ArrayList<String> currentParents = new ArrayList<String>(parents);
                currentParents.add(cluster.getUid());
                return Stream.concat(Stream.of(Pair.of((Object)cluster, (Object)parents)), GraphUtils.clusters(cluster, currentParents).stream());
            }
            return Stream.of(new Pair[0]);
        }).toList();
    }

    public static Set<AbstractGraph> successors(GraphCluster graphCluster, List<String> taskRunIds) {
        List<FlowGraph.Edge> edges = GraphUtils.edges(graphCluster);
        List<AbstractGraph> nodes = GraphUtils.nodes(graphCluster);
        List<AbstractGraph> selectedTaskRuns = nodes.stream().filter(AbstractGraphTask.class::isInstance).filter(task -> ((AbstractGraphTask)task).getTaskRun() != null && taskRunIds.contains(((AbstractGraphTask)task).getTaskRun().getId())).toList();
        Set edgeUuid = selectedTaskRuns.stream().flatMap(task -> GraphUtils.recursiveEdge(edges, task.getUid()).stream()).map(FlowGraph.Edge::getSource).collect(Collectors.toSet());
        return nodes.stream().filter(task -> edgeUuid.contains(task.getUid())).collect(Collectors.toSet());
    }

    private static List<FlowGraph.Edge> recursiveEdge(List<FlowGraph.Edge> edges, String selectedUuid) {
        return edges.stream().filter(edge -> edge.getSource().equals(selectedUuid)).flatMap(edge -> Stream.concat(Stream.of(edge), GraphUtils.recursiveEdge(edges, edge.getTarget()).stream())).toList();
    }

    public static void sequential(GraphCluster graph, List<Task> tasks, List<Task> errors, List<Task> _finally, TaskRun parent, Execution execution) throws IllegalVariableEvaluationException {
        GraphUtils.iterate(graph, tasks, errors, _finally, null, parent, execution, RelationType.SEQUENTIAL);
    }

    public static void sequential(GraphCluster graph, List<Task> tasks, List<Task> errors, List<Task> _finally, List<Task> afterExecution, TaskRun parent, Execution execution) throws IllegalVariableEvaluationException {
        GraphUtils.iterate(graph, tasks, errors, _finally, afterExecution, parent, execution, RelationType.SEQUENTIAL);
    }

    public static void parallel(GraphCluster graph, List<Task> tasks, List<Task> errors, List<Task> _finally, TaskRun parent, Execution execution) throws IllegalVariableEvaluationException {
        GraphUtils.iterate(graph, tasks, errors, _finally, parent, execution, RelationType.PARALLEL);
    }

    public static void switchCase(GraphCluster graph, Map<String, List<Task>> tasks, List<Task> errors, List<Task> _finally, TaskRun parent, Execution execution) throws IllegalVariableEvaluationException {
        for (Map.Entry<String, List<Task>> entry : tasks.entrySet()) {
            GraphUtils.fillGraph(graph, entry.getValue(), RelationType.SEQUENTIAL, parent, execution, entry.getKey());
        }
        GraphUtils.fillAlternativePaths(graph, errors, _finally, null, parent, execution, null);
    }

    public static void ifElse(GraphCluster graph, List<Task> then, List<Task> _else, List<Task> _finally, List<Task> errors, TaskRun parent, Execution execution) throws IllegalVariableEvaluationException {
        GraphUtils.fillGraph(graph, then, RelationType.SEQUENTIAL, parent, execution, "then");
        if (_else != null) {
            GraphUtils.fillGraph(graph, _else, RelationType.SEQUENTIAL, parent, execution, "else");
        }
        GraphUtils.fillAlternativePaths(graph, errors, _finally, null, parent, execution, null);
    }

    public static void dag(GraphCluster graph, List<Dag.DagTask> tasks, List<Task> errors, List<Task> _finally, TaskRun parent, Execution execution) throws IllegalVariableEvaluationException {
        GraphUtils.fillGraphDag(graph, tasks, parent, execution);
        GraphUtils.fillAlternativePaths(graph, errors, _finally, null, parent, execution, null);
    }

    private static void iterate(GraphCluster graph, List<Task> tasks, List<Task> errors, List<Task> _finally, TaskRun parent, Execution execution, RelationType relationType) throws IllegalVariableEvaluationException {
        GraphUtils.iterate(graph, tasks, errors, _finally, null, parent, execution, relationType);
    }

    private static void iterate(GraphCluster graph, List<Task> tasks, List<Task> errors, List<Task> _finally, List<Task> afterExecution, TaskRun parent, Execution execution, RelationType relationType) throws IllegalVariableEvaluationException {
        GraphUtils.fillGraph(graph, tasks, relationType, parent, execution, null);
        GraphUtils.fillAlternativePaths(graph, errors, _finally, afterExecution, parent, execution, null);
    }

    private static void fillAlternativePaths(GraphCluster graph, List<Task> errors, List<Task> _finally, List<Task> afterExecution, TaskRun parent, Execution execution, String value) throws IllegalVariableEvaluationException {
        if (!ListUtils.isEmpty(errors)) {
            GraphUtils.fillGraph(graph, errors, RelationType.ERROR, parent, execution, value);
        }
        if (!ListUtils.isEmpty(_finally)) {
            GraphUtils.fillGraph(graph, _finally, RelationType.FINALLY, parent, execution, value);
        } else {
            GraphUtils.removeFinally(graph);
        }
        if (!ListUtils.isEmpty(afterExecution)) {
            GraphUtils.fillGraph(graph, afterExecution, RelationType.AFTER_EXECUTION, parent, execution, value);
        } else {
            GraphUtils.removeAfterExecution(graph);
        }
    }

    private static void removeFinally(GraphCluster graph) {
        graph.getGraph().edges().forEach(edge -> {
            if (edge.getSource() instanceof GraphClusterFinally && edge.getTarget() instanceof GraphClusterAfterExecution) {
                graph.getGraph().edges().remove(edge);
            }
            if (edge.getTarget() instanceof GraphClusterFinally) {
                graph.getGraph().edges().remove(edge);
                graph.addEdge((AbstractGraph)edge.getSource(), graph.getAfterExecution(), (Relation)edge.getValue());
            }
        });
        graph.getGraph().removeNode(graph.getFinally());
    }

    private static void removeAfterExecution(GraphCluster graph) {
        graph.getGraph().edges().forEach(edge -> {
            if (edge.getSource() instanceof GraphClusterAfterExecution && edge.getTarget() instanceof GraphClusterEnd) {
                graph.getGraph().edges().remove(edge);
            }
            if (edge.getTarget() instanceof GraphClusterAfterExecution) {
                graph.getGraph().edges().remove(edge);
                graph.addEdge((AbstractGraph)edge.getSource(), graph.getEnd(), (Relation)edge.getValue());
            }
        });
        graph.getGraph().removeNode(graph.getAfterExecution());
    }

    private static void fillGraph(GraphCluster graph, List<Task> tasks, RelationType relationType, TaskRun parent, Execution execution, String value) throws IllegalVariableEvaluationException {
        Iterator<Task> iterator = tasks.iterator();
        AbstractGraph previous = Optional.ofNullable(graph.getTaskNode()).orElse((AbstractGraphTask)((Object)graph.getRoot()));
        if (relationType == RelationType.FINALLY) {
            previous = graph.getFinally();
            graph.getGraph().removeEdge(graph.getFinally(), graph.getAfterExecution());
        }
        if (relationType == RelationType.AFTER_EXECUTION) {
            previous = graph.getAfterExecution();
            graph.getGraph().removeEdge(graph.getAfterExecution(), graph.getEnd());
        }
        boolean isFirst = true;
        while (iterator.hasNext()) {
            Task currentTask = iterator.next();
            if (currentTask == null) continue;
            for (TaskRun currentTaskRun : GraphUtils.findTaskRuns(currentTask, execution, parent)) {
                GraphClusterEnd nextEdge;
                AbstractGraph currentGraph;
                List<String> parentValues = null;
                RelationType newRelation = graph.getRelationType();
                if (relationType == RelationType.ERROR) {
                    newRelation = relationType;
                } else if (!isFirst && relationType != RelationType.PARALLEL && graph.getRelationType() != RelationType.DYNAMIC) {
                    newRelation = relationType;
                }
                Relation relation = new Relation(newRelation, currentTaskRun == null ? value : currentTaskRun.getValue());
                if (execution != null && currentTaskRun != null) {
                    parentValues = execution.findParentsValues(currentTaskRun, true);
                }
                if (currentTask instanceof FlowableTask) {
                    FlowableTask flowableTask = (FlowableTask)((Object)currentTask);
                    currentGraph = flowableTask.tasksTree(execution, currentTaskRun, parentValues);
                } else if (currentTask instanceof ExecutableTask) {
                    ExecutableTask subflowTask = (ExecutableTask)((Object)currentTask);
                    currentGraph = new SubflowGraphTask(subflowTask, currentTaskRun, parentValues, relationType);
                } else {
                    currentGraph = new GraphTask(currentTask, currentTaskRun, parentValues, relationType);
                }
                graph.addNode(currentGraph);
                if (relationType == RelationType.ERROR || relationType == RelationType.FINALLY || relationType == RelationType.AFTER_EXECUTION) {
                    currentGraph.updateWithChildren(AbstractGraph.BranchType.valueOf(relationType.name()));
                }
                if (relationType == RelationType.ERROR && isFirst) {
                    previous = graph.getRoot();
                }
                if (previous != null) {
                    GraphCluster previousCluster;
                    if (previous instanceof GraphCluster && (previousCluster = (GraphCluster)previous).getEnd() != null) {
                        graph.addEdge(previousCluster.getEnd(), GraphUtils.toEdgeTarget(currentGraph), relation);
                    } else {
                        graph.addEdge(previous, GraphUtils.toEdgeTarget(currentGraph), relation);
                    }
                }
                if (relationType != RelationType.PARALLEL) {
                    previous = currentGraph;
                }
                AbstractGraph abstractGraph = relationType == RelationType.AFTER_EXECUTION ? graph.getEnd() : (nextEdge = relationType == RelationType.FINALLY ? graph.getAfterExecution() : graph.getFinally());
                if (GraphUtils.isAllLinkToEnd(relationType)) {
                    if (currentGraph instanceof GraphCluster && ((GraphCluster)currentGraph).getEnd() != null) {
                        graph.addEdge(((GraphCluster)currentGraph).getEnd(), nextEdge, new Relation());
                    } else {
                        graph.addEdge(currentGraph, nextEdge, new Relation());
                    }
                }
                isFirst = false;
                if (iterator.hasNext() || GraphUtils.isAllLinkToEnd(relationType)) continue;
                graph.addEdge(currentGraph instanceof GraphCluster ? ((GraphCluster)currentGraph).getEnd() : currentGraph, nextEdge, new Relation());
            }
        }
    }

    private static AbstractGraph toEdgeTarget(AbstractGraph currentGraph) {
        return currentGraph instanceof GraphCluster ? ((GraphCluster)currentGraph).getRoot() : currentGraph;
    }

    private static void fillGraphDag(GraphCluster graph, List<Dag.DagTask> tasks, TaskRun parent, Execution execution) throws IllegalVariableEvaluationException {
        ArrayList<GraphTask> nodeTaskCreated = new ArrayList<GraphTask>();
        ArrayList<String> nodeCreatedIds = new ArrayList<String>();
        Set dependencies = tasks.stream().map(Dag.DagTask::getDependsOn).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        AbstractGraph previous = Optional.ofNullable(graph.getTaskNode()).orElse((AbstractGraphTask)((Object)graph.getRoot()));
        while (nodeCreatedIds.size() < tasks.size()) {
            Iterator iterator = tasks.stream().filter(taskDepend -> (taskDepend.getDependsOn() == null || new HashSet(nodeCreatedIds).containsAll(taskDepend.getDependsOn())) && !nodeCreatedIds.contains(taskDepend.getTask().getId())).iterator();
            while (iterator.hasNext()) {
                Dag.DagTask currentTask = (Dag.DagTask)iterator.next();
                for (TaskRun currentTaskRun : GraphUtils.findTaskRuns(currentTask.getTask(), execution, parent)) {
                    AbstractGraph currentGraph;
                    Task task;
                    List<String> parentValues = null;
                    RelationType newRelation = RelationType.PARALLEL;
                    Relation relation = new Relation(newRelation, currentTaskRun == null ? null : currentTaskRun.getValue());
                    if (execution != null && currentTaskRun != null) {
                        parentValues = execution.findParentsValues(currentTaskRun, true);
                    }
                    if ((task = currentTask.getTask()) instanceof FlowableTask) {
                        FlowableTask flowableTask = (FlowableTask)((Object)task);
                        currentGraph = flowableTask.tasksTree(execution, currentTaskRun, parentValues);
                    } else {
                        currentGraph = new GraphTask(currentTask.getTask(), currentTaskRun, parentValues, RelationType.SEQUENTIAL);
                    }
                    graph.addNode(currentGraph);
                    if (currentTask.getDependsOn() == null) {
                        graph.addEdge(previous, GraphUtils.toEdgeTarget(currentGraph), relation);
                    } else {
                        for (String dependsOn : currentTask.getDependsOn()) {
                            GraphTask previousNode = nodeTaskCreated.stream().filter(node -> node.getTask().getId().equals(dependsOn)).findFirst().orElse(null);
                            if (previousNode != null && !((Task)previousNode.getTask()).isFlowable()) {
                                graph.addEdge(previousNode, GraphUtils.toEdgeTarget(currentGraph), relation);
                                continue;
                            }
                            graph.getGraph().nodes().stream().filter(node -> node instanceof GraphCluster).filter(node -> node.getUid().endsWith(dependsOn)).findFirst().ifPresent(previousClusterNodeEnd -> graph.addEdge(((GraphCluster)previousClusterNodeEnd).getEnd(), GraphUtils.toEdgeTarget(currentGraph), relation));
                        }
                    }
                    if (!dependencies.contains(currentTask.getTask().getId())) {
                        if (currentTask.getTask() instanceof FlowableTask) {
                            graph.addEdge(((GraphCluster)currentGraph).getEnd(), graph.getFinally(), new Relation());
                        } else {
                            graph.addEdge(currentGraph, graph.getFinally(), new Relation());
                        }
                    }
                    if (currentGraph instanceof GraphTask) {
                        nodeTaskCreated.add((GraphTask)currentGraph);
                    }
                    nodeCreatedIds.add(currentTask.getTask().getId());
                }
            }
        }
    }

    private static boolean isAllLinkToEnd(RelationType relationType) {
        return relationType == RelationType.PARALLEL || relationType == RelationType.CHOICE;
    }

    private static List<TaskRun> findTaskRuns(Task task, Execution execution, TaskRun parent) {
        List<Object> taskRuns;
        List<Object> list = taskRuns = execution != null ? execution.findTaskRunsByTaskId(task.getId()) : new ArrayList();
        if (taskRuns.isEmpty()) {
            return Collections.singletonList(null);
        }
        return taskRuns.stream().filter(taskRun -> parent == null || taskRun.getParentTaskRunId().equals(parent.getId())).toList();
    }
}

