/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;

public final class UnixModeToPosixFilePermissions {
    public static Set<PosixFilePermission> toPosixPermissions(int mode) {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        if ((mode & 0x100) != 0) {
            permissions.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) != 0) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) != 0) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) != 0) {
            permissions.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) != 0) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) != 0) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) != 0) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) != 0) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) != 0) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return permissions;
    }

    public static int fromPosixFilePermissions(Set<PosixFilePermission> perms) {
        int mode = 0;
        for (PosixFilePermission perm : perms) {
            switch (perm) {
                case OWNER_READ: {
                    mode |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    mode |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    mode |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    mode |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    mode |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    mode |= 8;
                    break;
                }
                case OTHERS_READ: {
                    mode |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    mode |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    mode |= 1;
                }
            }
        }
        return mode;
    }
}

