/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Singleton;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class UriProvider {
    @Nullable
    @Value(value="${kestra.url:}")
    String uri;

    protected URI build(String url) {
        if (this.uri == null || this.uri.isEmpty()) {
            return null;
        }
        return URI.create(StringUtils.stripEnd((String)this.uri, (String)"/") + url);
    }

    public URI rootUrl() {
        return this.build("/");
    }

    public URI executionUrl(Execution execution) {
        return this.build("/ui/" + (String)(execution.getTenantId() != null ? execution.getTenantId() + "/" : "") + "executions/" + execution.getNamespace() + "/" + execution.getFlowId() + "/" + execution.getId());
    }

    public URI flowUrl(Execution execution) {
        return this.build("/ui/" + (String)(execution.getTenantId() != null ? execution.getTenantId() + "/" : "") + "flows/" + execution.getNamespace() + "/" + execution.getFlowId());
    }

    public URI flowUrl(Flow flow) {
        return this.build("/ui/" + (String)(flow.getTenantId() != null ? flow.getTenantId() + "/" : "") + "flows/" + flow.getNamespace() + "/" + flow.getId());
    }
}

