/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Context
@Requires(property="kestra.server-type")
public class ServerCommandValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerCommandValidator.class);
    private static final Map<String, String> VALIDATED_PROPERTIES = Map.of("kestra.queue.type", "https://kestra.io/docs/configuration-guide/setup#queue-configuration", "kestra.repository.type", "https://kestra.io/docs/configuration-guide/setup#repository-configuration", "kestra.storage.type", "https://kestra.io/docs/configuration-guide/setup#internal-storage-configuration");
    private final Environment environment;

    @Inject
    public ServerCommandValidator(Environment environment) {
        this.environment = environment;
    }

    @PostConstruct
    void validate() {
        List<Map.Entry> missingProperties = VALIDATED_PROPERTIES.entrySet().stream().filter(property -> !this.environment.containsProperty((String)property.getKey())).toList();
        missingProperties.forEach(property -> log.error("Server configuration requires the '{}' property to be defined.\nFor more details, please follow the official setup guide at: {}", property.getKey(), property.getValue()));
        if (!missingProperties.isEmpty()) {
            throw new ServerCommandException("Incomplete server configuration - missing required properties");
        }
    }

    public static class ServerCommandException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ServerCommandException(String errorMessage) {
            super(errorMessage);
        }
    }
}

