/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations.factory;

import io.kestra.core.models.property.PropertyValueExtractor;
import io.micronaut.configuration.hibernate.validator.ValidatorFactoryProvider;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.TypeHint;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Configuration;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.valueextraction.ValueExtractor;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

@Factory
@Requires(classes={HibernateValidator.class})
@TypeHint(value={HibernateValidator.class})
@Replaces(value=ValidatorFactoryProvider.class)
public class CustomValidatorFactoryProvider {
    @Inject
    protected Optional<MessageInterpolator> messageInterpolator = Optional.empty();
    @Inject
    protected Optional<TraversableResolver> traversableResolver = Optional.empty();
    @Inject
    protected Optional<ConstraintValidatorFactory> constraintValidatorFactory = Optional.empty();
    @Inject
    protected Optional<ParameterNameProvider> parameterNameProvider = Optional.empty();
    @Inject
    protected PropertyValueExtractor propertyValueExtractor;
    @Value(value="${hibernate.validator.ignore-xml-configuration:true}")
    protected boolean ignoreXmlConfiguration = true;

    @Singleton
    @Requires(classes={HibernateValidator.class})
    @Replaces(value=ValidatorFactory.class)
    ValidatorFactory validatorFactory(Optional<Environment> environment) {
        Configuration validatorConfiguration = Validation.byDefaultProvider().configure();
        validatorConfiguration.messageInterpolator(this.messageInterpolator.orElseGet(ParameterMessageInterpolator::new));
        this.messageInterpolator.ifPresent(arg_0 -> ((Configuration)validatorConfiguration).messageInterpolator(arg_0));
        this.traversableResolver.ifPresent(arg_0 -> ((Configuration)validatorConfiguration).traversableResolver(arg_0));
        this.constraintValidatorFactory.ifPresent(arg_0 -> ((Configuration)validatorConfiguration).constraintValidatorFactory(arg_0));
        this.parameterNameProvider.ifPresent(arg_0 -> ((Configuration)validatorConfiguration).parameterNameProvider(arg_0));
        if (this.ignoreXmlConfiguration) {
            validatorConfiguration.ignoreXmlConfiguration();
        }
        environment.ifPresent(env -> {
            Optional config = env.getProperty("hibernate.validator", Properties.class);
            config.ifPresent(properties -> {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    Object value = entry.getValue();
                    if (value == null) continue;
                    validatorConfiguration.addProperty("hibernate.validator." + String.valueOf(entry.getKey()), value.toString());
                }
            });
        });
        this.configureValueExtractor(validatorConfiguration);
        return validatorConfiguration.buildValidatorFactory();
    }

    protected void configureValueExtractor(Configuration<?> validatorConfiguration) {
        validatorConfiguration.addValueExtractor((ValueExtractor)this.propertyValueExtractor);
    }
}

