/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations.validator;

import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.validations.TableChartValidation;
import io.kestra.plugin.core.dashboard.chart.Table;
import io.kestra.plugin.core.dashboard.chart.tables.TableColumnDescriptor;
import io.kestra.plugin.core.dashboard.chart.tables.TableOption;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

@Singleton
@Introspected
public class TableChartValidator
implements ConstraintValidator<TableChartValidation, Table<?, ?>> {
    public boolean isValid(@Nullable Table<?, ?> tableChart, @NonNull AnnotationValue<TableChartValidation> annotationMetadata, @NonNull ConstraintValidatorContext context) {
        if (tableChart == null) {
            return true;
        }
        ArrayList<String> violations = new ArrayList<String>();
        List<TableColumnDescriptor> aggregationsColumns = ((DataFilter)tableChart.getData()).getColumns().values().stream().filter(column -> column.getAgg() != null).toList();
        if (!aggregationsColumns.isEmpty() && ((TableOption)tableChart.getChartOptions()).getPagination().isEnabled()) {
            violations.add("Pagination can't be enabled when there is one or more aggregation(s). Please add `chartOptions.pagination.enabled: false` or remove your aggregation(s).");
        }
        if (!violations.isEmpty()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("Invalid data chart: " + String.join((CharSequence)", ", violations)).addConstraintViolation();
            return false;
        }
        return true;
    }
}

