/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import io.kestra.core.exceptions.IllegalConditionEvaluation;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;

@Schema(title="Condition that matches if any taskRun has retry attempts.")
@Plugin(examples={@Example(title="Trigger condition when any flow task on retry enters the state specified in the `in` states under the HasRetryAttempt condition.", full=true, code={"id: flow_condition_hasretryattempt\nnamespace: company.team\n\ntasks:\n  - id: log_message\n    type: io.kestra.plugin.core.log.Log\n    message: \"This flow will execute when any flow task on retry enters a specific state(s).\"\n\ntriggers:\n  - id: flow_condition\n    type: io.kestra.plugin.core.trigger.Flow\n    conditions:\n      - type: io.kestra.plugin.core.condition.HasRetryAttempt\n        in:\n          - FAILED\n"})}, aliases={"io.kestra.core.models.conditions.types.HasRetryAttemptCondition", "io.kestra.plugin.core.condition.HasRetryAttemptCondition"})
public class HasRetryAttempt
extends Condition {
    @Valid
    @Schema(title="List of states that are authorized.")
    private Property<List<State.Type>> in;
    @Valid
    @Schema(title="List of states that aren't authorized.")
    private Property<List<State.Type>> notIn;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        if (conditionContext.getExecution() == null) {
            throw new IllegalConditionEvaluation("Invalid condition with null execution");
        }
        RunContext runContext = conditionContext.getRunContext();
        List<State.Type> stateInRendered = runContext.render(this.in).asList(String.class, conditionContext.getVariables());
        List<State.Type> stateNotInRendered = runContext.render(this.notIn).asList(String.class, conditionContext.getVariables());
        return conditionContext.getExecution().getTaskRunList().stream().filter(taskRun -> taskRun.getAttempts().size() > 1).flatMap(taskRun -> taskRun.getAttempts().stream()).anyMatch(taskRunAttempt -> {
            boolean result = true;
            if (!stateInRendered.contains((Object)taskRunAttempt.getState().getCurrent())) {
                result = false;
            }
            if (stateNotInRendered.contains((Object)taskRunAttempt.getState().getCurrent())) {
                result = false;
            }
            return result;
        });
    }

    @Generated
    protected HasRetryAttempt(HasRetryAttemptBuilder<?, ?> b) {
        super(b);
        this.in = b.in;
        this.notIn = b.notIn;
    }

    @Generated
    public static HasRetryAttemptBuilder<?, ?> builder() {
        return new HasRetryAttemptBuilderImpl();
    }

    @Generated
    public String toString() {
        return "HasRetryAttempt(super=" + super.toString() + ", in=" + String.valueOf(this.getIn()) + ", notIn=" + String.valueOf(this.getNotIn()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasRetryAttempt)) {
            return false;
        }
        HasRetryAttempt other = (HasRetryAttempt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<List<State.Type>> this$in = this.getIn();
        Property<List<State.Type>> other$in = other.getIn();
        if (this$in == null ? other$in != null : !((Object)this$in).equals(other$in)) {
            return false;
        }
        Property<List<State.Type>> this$notIn = this.getNotIn();
        Property<List<State.Type>> other$notIn = other.getNotIn();
        return !(this$notIn == null ? other$notIn != null : !((Object)this$notIn).equals(other$notIn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HasRetryAttempt;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<List<State.Type>> $in = this.getIn();
        result = result * 59 + ($in == null ? 43 : ((Object)$in).hashCode());
        Property<List<State.Type>> $notIn = this.getNotIn();
        result = result * 59 + ($notIn == null ? 43 : ((Object)$notIn).hashCode());
        return result;
    }

    @Generated
    public Property<List<State.Type>> getIn() {
        return this.in;
    }

    @Generated
    public Property<List<State.Type>> getNotIn() {
        return this.notIn;
    }

    @Generated
    public HasRetryAttempt() {
    }

    @Generated
    public static abstract class HasRetryAttemptBuilder<C extends HasRetryAttempt, B extends HasRetryAttemptBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private Property<List<State.Type>> in;
        @Generated
        private Property<List<State.Type>> notIn;

        @Generated
        public B in(Property<List<State.Type>> in) {
            this.in = in;
            return (B)this.self();
        }

        @Generated
        public B notIn(Property<List<State.Type>> notIn) {
            this.notIn = notIn;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "HasRetryAttempt.HasRetryAttemptBuilder(super=" + super.toString() + ", in=" + String.valueOf(this.in) + ", notIn=" + String.valueOf(this.notIn) + ")";
        }
    }

    @Generated
    private static final class HasRetryAttemptBuilderImpl
    extends HasRetryAttemptBuilder<HasRetryAttempt, HasRetryAttemptBuilderImpl> {
        @Generated
        private HasRetryAttemptBuilderImpl() {
        }

        @Override
        @Generated
        protected HasRetryAttemptBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public HasRetryAttempt build() {
            return new HasRetryAttempt(this);
        }
    }
}

