/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;

@Schema(title="Condition to exclude other conditions.")
@Plugin(examples={@Example(title="Trigger condition to execute the flow when the condition is not satisfied.", full=true, code={"id: schedule_condition_not\nnamespace: company.team\n\ntasks:\n  - id: log_message\n    type: io.kestra.plugin.core.log.Log\n    message: \"This flow will execute on all days except Sunday at 11am.\"\n\ntriggers:\n  - id: schedule\n    type: io.kestra.plugin.core.trigger.Schedule\n    cron: \"0 11 * * *\"\n    conditions:\n      - type: io.kestra.plugin.core.condition.Not\n        conditions:\n          - type: io.kestra.plugin.core.condition.DayWeek\n            dayOfWeek: \"SUNDAY\"\n"})}, aliases={"io.kestra.core.models.conditions.types.NotCondition", "io.kestra.plugin.core.condition.NotCondition"})
public class Not
extends Condition
implements ScheduleCondition {
    @NotNull
    @NotEmpty
    @Schema(title="The list of conditions to exclude.", description="If any condition is true, it will prevent the event's execution.")
    @PluginProperty
    private List<Condition> conditions;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        return this.conditions.stream().noneMatch(Rethrow.throwPredicate(condition -> condition.test(conditionContext)));
    }

    @Generated
    protected Not(NotBuilder<?, ?> b) {
        super(b);
        this.conditions = b.conditions;
    }

    @Generated
    public static NotBuilder<?, ?> builder() {
        return new NotBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Not(super=" + super.toString() + ", conditions=" + String.valueOf(this.getConditions()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Not)) {
            return false;
        }
        Not other = (Not)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Condition> this$conditions = this.getConditions();
        List<Condition> other$conditions = other.getConditions();
        return !(this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Not;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Condition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        return result;
    }

    @Generated
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Generated
    public Not() {
    }

    @Generated
    public static abstract class NotBuilder<C extends Not, B extends NotBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private List<Condition> conditions;

        @Generated
        public B conditions(List<Condition> conditions) {
            this.conditions = conditions;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Not.NotBuilder(super=" + super.toString() + ", conditions=" + String.valueOf(this.conditions) + ")";
        }
    }

    @Generated
    private static final class NotBuilderImpl
    extends NotBuilder<Not, NotBuilderImpl> {
        @Generated
        private NotBuilderImpl() {
        }

        @Override
        @Generated
        protected NotBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Not build() {
            return new Not(this);
        }
    }
}

