/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.models.property.Property;
import io.kestra.core.utils.DateUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.DayOfWeek;
import java.time.LocalDate;
import lombok.Generated;

@Schema(title="Condition to allow events on weekend.")
@Plugin(examples={@Example(title="Trigger the flow only on weekend, i.e. on Saturdays and Sundays.", full=true, code={"id: schedule_condition_weekend\nnamespace: company.team\n\ntasks:\n  - id: log_message\n    type: io.kestra.plugin.core.log.Log\n    message: \"This flow will execute only on weekends at 11:00 am.\"\n\ntriggers:\n  - id: schedule\n    type: io.kestra.plugin.core.trigger.Schedule\n    cron: \"0 11 * * *\"\n    conditions:\n      - type: io.kestra.plugin.core.condition.Weekend\n"})}, aliases={"io.kestra.core.models.conditions.types.WeekendCondition", "io.kestra.plugin.core.condition.WeekendCondition"})
public class Weekend
extends Condition
implements ScheduleCondition {
    @NotNull
    @Schema(title="The date to test.", description="Can be any variable or any valid ISO 8601 datetime. By default, it will use the trigger date.")
    private final Property<String> date;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        String render = conditionContext.getRunContext().render(this.date).as(String.class, conditionContext.getVariables()).orElseThrow();
        LocalDate currentDate = DateUtils.parseLocalDate(render);
        return currentDate.getDayOfWeek().equals(DayOfWeek.SATURDAY) || currentDate.getDayOfWeek().equals(DayOfWeek.SUNDAY);
    }

    @Generated
    private static Property<String> $default$date() {
        return Property.ofExpression("{{ trigger.date }}");
    }

    @Generated
    protected Weekend(WeekendBuilder<?, ?> b) {
        super(b);
        this.date = b.date$set ? b.date$value : Weekend.$default$date();
    }

    @Generated
    public static WeekendBuilder<?, ?> builder() {
        return new WeekendBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Weekend(super=" + super.toString() + ", date=" + String.valueOf(this.getDate()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Weekend)) {
            return false;
        }
        Weekend other = (Weekend)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$date = this.getDate();
        Property<String> other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Weekend;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }

    @Generated
    public Property<String> getDate() {
        return this.date;
    }

    @Generated
    public Weekend() {
        this.date = Weekend.$default$date();
    }

    @Generated
    public static abstract class WeekendBuilder<C extends Weekend, B extends WeekendBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private boolean date$set;
        @Generated
        private Property<String> date$value;

        @Generated
        public B date(Property<String> date) {
            this.date$value = date;
            this.date$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Weekend.WeekendBuilder(super=" + super.toString() + ", date$value=" + String.valueOf(this.date$value) + ")";
        }
    }

    @Generated
    private static final class WeekendBuilderImpl
    extends WeekendBuilder<Weekend, WeekendBuilderImpl> {
        @Generated
        private WeekendBuilderImpl() {
        }

        @Override
        @Generated
        protected WeekendBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Weekend build() {
            return new Weekend(this);
        }
    }
}

