/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.debug;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Metric;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.executions.metrics.Timer;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Return a value for debugging purposes.", description="This task is mostly useful for troubleshooting.\n\nIt allows you to return some templated functions, inputs or outputs. In some cases you might want to trim all white spaces from the rendered values so downstream tasks can use them properly.")
@Plugin(examples={@Example(full=true, code={"id: debug_value\nnamespace: company.team\n\ntasks:\n  - id: return\n    type: io.kestra.plugin.core.debug.Return\n    format: \"{{ task.id }} > {{ taskrun.startDate }}\"\n"}), @Example(code={"id: compute_header\ntype: io.kestra.plugin.core.debug.Return\nformat: >-\n    {%- if inputs.token is not empty -%}\n    Bearer {{ inputs.token }}\n    {%- elseif inputs.username is not empty and inputs.password is not empty -%}\n    Basic {{ (inputs.username + ':' + inputs.password) | base64encode }}\n    {%- endif -%}\n"})}, metrics={@Metric(name="length", type="counter"), @Metric(name="duration", type="timer")}, aliases={"io.kestra.core.tasks.debugs.Return"})
public class Return
extends Task
implements RunnableTask<Output> {
    @Schema(title="The templated string to render.")
    private Property<String> format;

    @Override
    public Output run(RunContext runContext) throws Exception {
        long start = System.nanoTime();
        Logger logger = runContext.logger();
        String render = runContext.render(this.format).as(String.class).orElse(null);
        logger.debug(render);
        long end = System.nanoTime();
        runContext.metric(Counter.of("length", Optional.ofNullable(render).map(String::length).orElse(0), new String[0])).metric(Timer.of("duration", Duration.ofNanos(end - start), new String[0]));
        return Output.builder().value(render).build();
    }

    @Generated
    protected Return(ReturnBuilder<?, ?> b) {
        super(b);
        this.format = b.format;
    }

    @Generated
    public static ReturnBuilder<?, ?> builder() {
        return new ReturnBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Return(super=" + super.toString() + ", format=" + String.valueOf(this.getFormat()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Return)) {
            return false;
        }
        Return other = (Return)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$format = this.getFormat();
        Property<String> other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !((Object)this$format).equals(other$format));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Return;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)$format).hashCode());
        return result;
    }

    @Generated
    public Property<String> getFormat() {
        return this.format;
    }

    @Generated
    public Return() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The generated string.")
        private String value;

        @ConstructorProperties(value={"value"})
        @Generated
        Output(String value) {
            this.value = value;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private String value;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder value(String value) {
                this.value = value;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.value);
            }

            @Generated
            public String toString() {
                return "Return.Output.OutputBuilder(value=" + this.value + ")";
            }
        }
    }

    @Generated
    public static abstract class ReturnBuilder<C extends Return, B extends ReturnBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> format;

        @Generated
        public B format(Property<String> format) {
            this.format = format;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Return.ReturnBuilder(super=" + super.toString() + ", format=" + String.valueOf(this.format) + ")";
        }
    }

    @Generated
    private static final class ReturnBuilderImpl
    extends ReturnBuilder<Return, ReturnBuilderImpl> {
        @Generated
        private ReturnBuilderImpl() {
        }

        @Override
        @Generated
        protected ReturnBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Return build() {
            return new Return(this);
        }
    }
}

