/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.execution;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.Label;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.tasks.ExecutionUpdatableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

@Schema(title="Add or overwrite labels for the current execution at runtime.", description="Trying to pass a system label (a label starting with `system.`) will fail the task.")
@Plugin(examples={@Example(title="Add labels based on a webhook payload", full=true, code={"id: webhook_based_labels", "namespace: company.team", "tasks:", "  - id: update_labels_with_map", "    type: io.kestra.plugin.core.execution.Labels", "    labels:", "      customerId: \"{{ trigger.body.customerId }}\"", "  - id: by_list", "    type: io.kestra.plugin.core.execution.Labels", "    labels:", "      - key: order_id", "        value: \"{{ trigger.body.orderId }}\"", "      - key: order_type", "        value: \"{{ trigger.body.orderType }}\"", "triggers:", "  - id: webhook", "    key: order_webhook", "    type: io.kestra.plugin.core.trigger.Webhook", "    conditions:", "      - type: io.kestra.plugin.core.condition.Expression", "        expression: \"{{ trigger.body.customerId is defined and trigger.body.orderId is defined and trigger.body.orderType is defined }}\""})}, aliases={"io.kestra.core.tasks.executions.Labels"})
public class Labels
extends Task
implements ExecutionUpdatableTask {
    private static final TypeReference<Map<String, String>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, String>>(){};
    private static final ObjectMapper MAPPER = JacksonMapper.ofJson();
    @Schema(title="Labels to add to the current execution", description="The value should result in a list of labels or a labelKey:labelValue map", oneOf={String.class, Label[].class, Map.class})
    @PluginProperty(dynamic=true, additionalProperties=String.class)
    @NotNull
    private Object labels;

    @Override
    public Execution update(Execution execution, RunContext runContext) throws Exception {
        Map<String, String> labelsAsMap;
        Object object = this.labels;
        if (object instanceof String) {
            String labelStr = (String)object;
            try {
                labelsAsMap = (Map<String, String>)MAPPER.readValue(runContext.render(labelStr), MAP_TYPE_REFERENCE);
            }
            catch (JsonProcessingException e) {
                throw new IllegalVariableEvaluationException(e);
            }
        } else {
            Object e = this.labels;
            if (e instanceof List) {
                List labelsList = (List)e;
                labelsAsMap = labelsList.stream().map(Rethrow.throwFunction(label -> {
                    if (label instanceof Map) {
                        Map labelMap = (Map)label;
                        return Map.entry(runContext.render((String)labelMap.get("key")), runContext.render((String)labelMap.get("value")));
                    }
                    throw new IllegalVariableEvaluationException("Unknown value type: " + String.valueOf(label.getClass()));
                })).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (first, second) -> second));
            } else {
                e = this.labels;
                if (e instanceof Map) {
                    Map map = (Map)e;
                    labelsAsMap = map.entrySet().stream().map(Rethrow.throwFunction(entry -> Map.entry(runContext.render((String)entry.getKey()), runContext.render((String)entry.getValue())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                } else {
                    throw new IllegalVariableEvaluationException("Unknown value type: " + String.valueOf(this.labels.getClass()));
                }
            }
        }
        Optional<Map.Entry> systemLabel = labelsAsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("system.")).findFirst();
        if (systemLabel.isPresent()) {
            throw new IllegalArgumentException("System labels can only be set by Kestra itself, offending label: " + (String)systemLabel.get().getKey() + "=" + (String)systemLabel.get().getValue());
        }
        Optional<Map.Entry> emptyValue = labelsAsMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).isEmpty()).findFirst();
        if (emptyValue.isPresent()) {
            throw new IllegalArgumentException("Label values cannot be empty, offending label: " + (String)emptyValue.get().getKey());
        }
        Map<String, String> newLabels = ListUtils.emptyOnNull(execution.getLabels()).stream().collect(Collectors.toMap(Label::key, Label::value));
        newLabels.putAll(labelsAsMap);
        return execution.withLabels(newLabels.entrySet().stream().filter(Label.getEntryNotEmptyPredicate()).map(entry -> new Label((String)entry.getKey(), (String)entry.getValue())).toList());
    }

    @Generated
    protected Labels(LabelsBuilder<?, ?> b) {
        super(b);
        this.labels = b.labels;
    }

    @Generated
    public static LabelsBuilder<?, ?> builder() {
        return new LabelsBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Labels(super=" + super.toString() + ", labels=" + String.valueOf(this.getLabels()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Labels)) {
            return false;
        }
        Labels other = (Labels)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$labels = this.getLabels();
        Object other$labels = other.getLabels();
        return !(this$labels == null ? other$labels != null : !this$labels.equals(other$labels));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Labels;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : $labels.hashCode());
        return result;
    }

    @Generated
    public Object getLabels() {
        return this.labels;
    }

    @Generated
    public Labels() {
    }

    @Generated
    public static abstract class LabelsBuilder<C extends Labels, B extends LabelsBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Object labels;

        @Generated
        public B labels(Object labels) {
            this.labels = labels;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Labels.LabelsBuilder(super=" + super.toString() + ", labels=" + String.valueOf(this.labels) + ")";
        }
    }

    @Generated
    private static final class LabelsBuilderImpl
    extends LabelsBuilder<Labels, LabelsBuilderImpl> {
        @Generated
        private LabelsBuilderImpl() {
        }

        @Override
        @Generated
        protected LabelsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Labels build() {
            return new Labels(this);
        }
    }
}

