/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.execution;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.ExecutionUpdatableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@Schema(title="Unset execution variables.")
@Plugin(examples={@Example(full=true, title="Set and later unset variables", code={"id: variables\nnamespace: company.team\n\nvariables:\n  name: World\n\ntasks:\n  - id: set_vars\n    type: io.kestra.plugin.core.execution.SetVariables\n    variables:\n      message: Hello\n      name: Lo\u00efc\n  - id: hello\n    type: io.kestra.plugin.core.log.Log\n    message: \"{{ vars.message }} {{ vars.name }}\"\n  - id: unset_variables\n    type: io.kestra.plugin.core.execution.UnsetVariables\n    variables:\n      - message\n      - name"})})
public class UnsetVariables
extends Task
implements ExecutionUpdatableTask {
    @Schema(title="The variables")
    @NotNull
    private Property<List<String>> variables;
    @Schema(title="Flag specifying whether to ignore missing variables")
    @NotNull
    private Property<Boolean> ignoreMissing;

    @Override
    public Execution update(Execution execution, RunContext runContext) throws Exception {
        List<String> renderedVariables = runContext.render(this.variables).asList(String.class);
        boolean renderedIgnoreMissing = runContext.render(this.ignoreMissing).as(Boolean.class).orElseThrow();
        Map<String, Object> variables = execution.getVariables();
        for (String key : renderedVariables) {
            this.removeVar(variables, key, renderedIgnoreMissing);
        }
        return execution.withVariables(variables);
    }

    private void removeVar(Map<String, Object> vars, String key, boolean ignoreMissing) {
        if (key.indexOf(46) >= 0) {
            String prefix = key.substring(0, key.indexOf(46));
            String suffix = key.substring(key.indexOf(46) + 1);
            this.removeVar((Map)vars.get(prefix), suffix, ignoreMissing);
        } else {
            if (ignoreMissing && !vars.containsKey(key)) {
                return;
            }
            vars.remove(key);
        }
    }

    @Generated
    private static Property<Boolean> $default$ignoreMissing() {
        return Property.ofValue(false);
    }

    @Generated
    protected UnsetVariables(UnsetVariablesBuilder<?, ?> b) {
        super(b);
        this.variables = b.variables;
        this.ignoreMissing = b.ignoreMissing$set ? b.ignoreMissing$value : UnsetVariables.$default$ignoreMissing();
    }

    @Generated
    public static UnsetVariablesBuilder<?, ?> builder() {
        return new UnsetVariablesBuilderImpl();
    }

    @Generated
    public String toString() {
        return "UnsetVariables(super=" + super.toString() + ", variables=" + String.valueOf(this.getVariables()) + ", ignoreMissing=" + String.valueOf(this.getIgnoreMissing()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnsetVariables)) {
            return false;
        }
        UnsetVariables other = (UnsetVariables)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<List<String>> this$variables = this.getVariables();
        Property<List<String>> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        Property<Boolean> this$ignoreMissing = this.getIgnoreMissing();
        Property<Boolean> other$ignoreMissing = other.getIgnoreMissing();
        return !(this$ignoreMissing == null ? other$ignoreMissing != null : !((Object)this$ignoreMissing).equals(other$ignoreMissing));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UnsetVariables;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<List<String>> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        Property<Boolean> $ignoreMissing = this.getIgnoreMissing();
        result = result * 59 + ($ignoreMissing == null ? 43 : ((Object)$ignoreMissing).hashCode());
        return result;
    }

    @Generated
    public Property<List<String>> getVariables() {
        return this.variables;
    }

    @Generated
    public Property<Boolean> getIgnoreMissing() {
        return this.ignoreMissing;
    }

    @Generated
    public UnsetVariables() {
        this.ignoreMissing = UnsetVariables.$default$ignoreMissing();
    }

    @Generated
    public static abstract class UnsetVariablesBuilder<C extends UnsetVariables, B extends UnsetVariablesBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<List<String>> variables;
        @Generated
        private boolean ignoreMissing$set;
        @Generated
        private Property<Boolean> ignoreMissing$value;

        @Generated
        public B variables(Property<List<String>> variables) {
            this.variables = variables;
            return (B)this.self();
        }

        @Generated
        public B ignoreMissing(Property<Boolean> ignoreMissing) {
            this.ignoreMissing$value = ignoreMissing;
            this.ignoreMissing$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "UnsetVariables.UnsetVariablesBuilder(super=" + super.toString() + ", variables=" + String.valueOf(this.variables) + ", ignoreMissing$value=" + String.valueOf(this.ignoreMissing$value) + ")";
        }
    }

    @Generated
    private static final class UnsetVariablesBuilderImpl
    extends UnsetVariablesBuilder<UnsetVariables, UnsetVariablesBuilderImpl> {
        @Generated
        private UnsetVariablesBuilderImpl() {
        }

        @Override
        @Generated
        protected UnsetVariablesBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public UnsetVariables build() {
            return new UnsetVariables(this);
        }
    }
}

