/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.GraphUtils;
import io.kestra.core.utils.ListUtils;
import io.kestra.plugin.core.flow.Parallel;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@Schema(title="For each value in the list, execute one or more tasks in parallel (Deprecated).", description="This task is deprecated, please use the `io.kestra.plugin.core.flow.ForEach` task instead.\n\nThe list of `tasks` will be executed for each item in parallel. The value must be a valid JSON string representing an array, e.g. a list of strings `[\"value1\", \"value2\"]` or a list of dictionaries `[{\"key\": \"value1\"}, {\"key\": \"value2\"}]`.\nYou can access the current iteration value using the variable `{{ taskrun.value }}`.\n\nThe task list will be executed in parallel for each item. For example, if you have a list with 3 elements and 2 tasks defined in the list of `tasks`, all 6 tasks will be computed in parallel without any order guarantee.\n\nIf you want to execute a group of sequential tasks for each value in parallel, you can wrap the list of `tasks` with the [Sequential task](https://kestra.io/plugins/core/tasks/flow/io.kestra.plugin.core.flow.sequential).\nIf your list of values is large, you can limit the number of concurrent tasks using the `concurrent` property.\n\nWe highly recommend triggering a subflow for each value (e.g. using the [ForEachItem](https://kestra.io/plugins/core/tasks/flow/io.kestra.plugin.core.flow.foreachitem) task) instead of specifying many tasks wrapped in a `Sequential` task. This allows better scalability and modularity. Check the [flow best practices documentation](https://kestra.io/docs/best-practices/flows) for more details.")
@Plugin(examples={@Example(full=true, code={"id: each_parallel\nnamespace: company.team\n\ntasks:\n  - id: each_parallel\n    type: io.kestra.plugin.core.flow.EachParallel\n    value: '[\"value 1\", \"value 2\", \"value 3\"]'\n    tasks:\n      - id: each_value\n        type: io.kestra.plugin.core.debug.Return\n        format: \"{{ task.id }} with current value '{{ taskrun.value }}'\"\n"}), @Example(full=true, title="Create a file for each value in parallel, then process all files in the next task. Note how the `inputFiles` property uses a `jq` expression with a `map` function to extract the paths of all files processed in parallel and pass them into the next task's working directory.", code={"id: parallel_script\nnamespace: company.team\n\ntasks:\n  - id: each\n    type: io.kestra.plugin.core.flow.EachParallel\n    value: \"{{ range(1, 9) }}\"\n    tasks:\n      - id: script\n        type: io.kestra.plugin.scripts.shell.Script\n        outputFiles:\n          - \"out/*.txt\"\n        script: |\n          mkdir out\n          echo \"{{ taskrun.value }}\" > out/file_{{ taskrun.value }}.txt\n\n  - id: process_all_files\n    type: io.kestra.plugin.scripts.shell.Script\n    inputFiles: \"{{ outputs.script | jq('map(.outputFiles) | add') | first }}\"\n    script: |\n      ls -h out/\n"}), @Example(title="Run a group of tasks for each value in parallel.", full=true, code={"id: parallel_task_groups\nnamespace: company.team\n\ntasks:\n  - id: for_each\n    type: io.kestra.plugin.core.flow.EachParallel\n    value: [\"value 1\", \"value 2\", \"value 3\"]\n    tasks:\n      - id: group\n        type: io.kestra.plugin.core.flow.Sequential\n        tasks:\n          - id: task1\n            type: io.kestra.plugin.scripts.shell.Commands\n            commands:\n              - echo \"{{task.id}} > {{ parents[0].taskrun.value }}\"\n              - sleep 1\n\n          - id: task2\n            type: io.kestra.plugin.scripts.shell.Commands\n            commands:\n              - echo \"{{task.id}} > {{ parents[0].taskrun.value }}\"\n              - sleep 1\n"})}, aliases={"io.kestra.core.tasks.flows.EachParallel"})
@Deprecated(since="0.19", forRemoval=true)
public class EachParallel
extends Parallel
implements FlowableTask<VoidOutput> {
    @NotNull
    @Schema(title="Number of concurrent parallel tasks that can be running at any point in time", description="If the value is `0`, no limit exists and all the tasks will start at the same time.")
    private final Property<Integer> concurrent;
    @NotNull
    @PluginProperty(dynamic=true)
    @Schema(title="The list of values for this task", description="The value can be passed as a string, a list of strings, or a list of objects.", oneOf={String.class, Object[].class})
    private Object value;

    @Override
    public GraphCluster tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.DYNAMIC);
        GraphUtils.parallel(subGraph, this.getTasks(), this.errors, this._finally, taskRun, execution);
        return subGraph;
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveEachTasks(runContext, parentTaskRun, this.getTasks(), this.value);
    }

    @Override
    public Optional<State.Type> resolveState(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        List<ResolvedTask> childTasks = ListUtils.emptyOnNull(this.childTasks(runContext, parentTaskRun)).stream().filter(resolvedTask -> resolvedTask.getTask().getDisabled() == false).toList();
        if (childTasks.isEmpty()) {
            return Optional.of(State.Type.SUCCESS);
        }
        return FlowableUtils.resolveState(execution, childTasks, FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), FlowableUtils.resolveTasks(this.getFinally(), parentTaskRun), parentTaskRun, runContext, this.isAllowFailure(), this.isAllowWarning());
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveParallelNexts(execution, FlowableUtils.resolveEachTasks(runContext, parentTaskRun, this.getTasks(), this.value), FlowableUtils.resolveTasks(this.errors, parentTaskRun), FlowableUtils.resolveTasks(this._finally, parentTaskRun), parentTaskRun, runContext.render(this.concurrent).as(Integer.class).orElseThrow());
    }

    @Generated
    private static Property<Integer> $default$concurrent() {
        return Property.ofValue(0);
    }

    @Generated
    protected EachParallel(EachParallelBuilder<?, ?> b) {
        super((Parallel.ParallelBuilder<?, ?>)b);
        this.concurrent = b.concurrent$set ? b.concurrent$value : EachParallel.$default$concurrent();
        this.value = b.value;
    }

    @Generated
    public static EachParallelBuilder<?, ?> builder() {
        return new EachParallelBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "EachParallel(super=" + super.toString() + ", concurrent=" + String.valueOf(this.getConcurrent()) + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EachParallel)) {
            return false;
        }
        EachParallel other = (EachParallel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<Integer> this$concurrent = this.getConcurrent();
        Property<Integer> other$concurrent = other.getConcurrent();
        if (this$concurrent == null ? other$concurrent != null : !((Object)this$concurrent).equals(other$concurrent)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EachParallel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<Integer> $concurrent = this.getConcurrent();
        result = result * 59 + ($concurrent == null ? 43 : ((Object)$concurrent).hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Override
    @Generated
    public Property<Integer> getConcurrent() {
        return this.concurrent;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public EachParallel() {
        this.concurrent = EachParallel.$default$concurrent();
    }

    @Generated
    public static abstract class EachParallelBuilder<C extends EachParallel, B extends EachParallelBuilder<C, B>>
    extends Parallel.ParallelBuilder<C, B> {
        @Generated
        private boolean concurrent$set;
        @Generated
        private Property<Integer> concurrent$value;
        @Generated
        private Object value;

        @Override
        @Generated
        public B concurrent(Property<Integer> concurrent) {
            this.concurrent$value = concurrent;
            this.concurrent$set = true;
            return (B)this.self();
        }

        @Generated
        public B value(Object value) {
            this.value = value;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "EachParallel.EachParallelBuilder(super=" + super.toString() + ", concurrent$value=" + String.valueOf(this.concurrent$value) + ", value=" + String.valueOf(this.value) + ")";
        }
    }

    @Generated
    private static final class EachParallelBuilderImpl
    extends EachParallelBuilder<EachParallel, EachParallelBuilderImpl> {
        @Generated
        private EachParallelBuilderImpl() {
        }

        @Override
        @Generated
        protected EachParallelBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public EachParallel build() {
            return new EachParallel(this);
        }
    }
}

