/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.http;

import io.kestra.core.http.HttpRequest;
import io.kestra.core.http.HttpResponse;
import io.kestra.core.http.client.HttpClient;
import io.kestra.core.http.client.HttpClientResponseException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Metric;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.core.http.AbstractHttp;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

@Schema(title="Download a file from an HTTP server.", description="This task connects to a HTTP server and copies a file to Kestra's internal storage.")
@Plugin(examples={@Example(title="Download a CSV file.", full=true, code={"id: download\nnamespace: company.team\n\ntasks:\n  - id: extract\n    type: io.kestra.plugin.core.http.Download\n    uri: https://huggingface.co/datasets/kestra/datasets/raw/main/csv/orders.csv"})}, metrics={@Metric(name="response.length", type="counter", description="The content length")}, aliases={"io.kestra.plugin.fs.http.Download"})
public class Download
extends AbstractHttp
implements RunnableTask<Output> {
    @Schema(title="Should the task fail when downloading an empty file.")
    private Property<Boolean> failOnEmptyResponse;
    @Schema(title="Name of the file inside the output.", description="If not provided, the filename will be extracted from the `Content-Disposition` header.\nIf no `Content-Disposition` header, a name would be generated.")
    private Property<String> saveAs;

    @Override
    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        URI from = new URI(runContext.render(this.uri).as(String.class).orElseThrow());
        File tempFile = runContext.workingDir().createTempFile(this.filenameFromURI(from)).toFile();
        try (HttpClient client = this.client(runContext);){
            Output output;
            try (BufferedOutputStream output2 = new BufferedOutputStream(new FileOutputStream(tempFile));){
                String contentDisposition;
                String rFilename;
                HttpRequest request = this.request(runContext);
                AtomicReference size = new AtomicReference();
                HttpResponse<Void> response = client.request(request, Rethrow.throwConsumer(r -> {
                    if (r.getBody() != null) {
                        size.set(IOUtils.copyLarge((InputStream)((InputStream)r.getBody()), (OutputStream)output2));
                    }
                    if (size.get() == null) {
                        size.set(0L);
                    }
                    if (r.getBody() != null) {
                        r.getHeaders().firstValue("Content-Length").ifPresent(header -> {
                            long length = Long.parseLong(header);
                            if (length != (Long)size.get()) {
                                throw new IllegalStateException("Invalid size, got " + String.valueOf(size) + ", expected " + length);
                            }
                        });
                    }
                    output2.flush();
                }));
                if ((Long)size.get() == 0L) {
                    if (runContext.render(this.failOnEmptyResponse).as(Boolean.class).orElseThrow().booleanValue()) {
                        boolean allowFailed;
                        boolean bl = allowFailed = this.options != null && runContext.render(this.options.getAllowFailed()).as(Boolean.class).orElseThrow() != false;
                        if (!allowFailed) {
                            throw new HttpClientResponseException("No response from server", response);
                        }
                    } else {
                        logger.warn("File '{}' is empty", (Object)from);
                    }
                }
                if ((rFilename = (String)runContext.render(this.saveAs).as(String.class).orElse(null)) == null && response.getHeaders().firstValue("Content-Disposition").isPresent() && (rFilename = this.filenameFromHeader(runContext, contentDisposition = response.getHeaders().firstValue("Content-Disposition").orElseThrow())) != null) {
                    rFilename = rFilename.replace(' ', '+');
                }
                logger.debug("File '{}' downloaded with size '{}'", (Object)from, size);
                output = Output.builder().code(response.getStatus().getCode()).uri(runContext.storage().putFile(tempFile, rFilename)).headers(response.getHeaders().map()).length((Long)size.get()).build();
            }
            return output;
        }
    }

    private String filenameFromHeader(RunContext runContext, String contentDisposition) {
        try {
            String[] parts = contentDisposition.split(";");
            String filename = null;
            for (String part : parts) {
                String stripped = part.strip();
                if (stripped.startsWith("filename")) {
                    filename = stripped.substring(stripped.lastIndexOf(61) + 1);
                }
                if (!stripped.startsWith("filename*")) continue;
                filename = stripped.substring(stripped.lastIndexOf(39) + 2, stripped.length() - 1);
            }
            if (filename != null && filename.charAt(0) == '\"') {
                filename = filename.substring(1, filename.length() - 1);
            }
            if (filename != null && filename.contains(File.separator)) {
                filename = filename.substring(filename.lastIndexOf(File.separator) + 1);
            }
            return filename;
        }
        catch (Exception e) {
            runContext.logger().debug("Unable to parse the Content-Disposition header: {}", (Object)contentDisposition, (Object)e);
            return null;
        }
    }

    private String filenameFromURI(URI uri) {
        String path = uri.getPath();
        if (path == null) {
            return null;
        }
        if (path.indexOf(47) != -1) {
            path = path.substring(path.lastIndexOf(47));
        }
        if (path.lastIndexOf(46) != -1) {
            return path.substring(path.lastIndexOf(46));
        }
        return null;
    }

    @Generated
    private static Property<Boolean> $default$failOnEmptyResponse() {
        return Property.ofValue(true);
    }

    @Generated
    protected Download(DownloadBuilder<?, ?> b) {
        super((AbstractHttp.AbstractHttpBuilder<?, ?>)b);
        this.failOnEmptyResponse = b.failOnEmptyResponse$set ? b.failOnEmptyResponse$value : Download.$default$failOnEmptyResponse();
        this.saveAs = b.saveAs;
    }

    @Generated
    public static DownloadBuilder<?, ?> builder() {
        return new DownloadBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Download(super=" + super.toString() + ", failOnEmptyResponse=" + String.valueOf(this.getFailOnEmptyResponse()) + ", saveAs=" + String.valueOf(this.getSaveAs()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Download)) {
            return false;
        }
        Download other = (Download)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<Boolean> this$failOnEmptyResponse = this.getFailOnEmptyResponse();
        Property<Boolean> other$failOnEmptyResponse = other.getFailOnEmptyResponse();
        if (this$failOnEmptyResponse == null ? other$failOnEmptyResponse != null : !((Object)this$failOnEmptyResponse).equals(other$failOnEmptyResponse)) {
            return false;
        }
        Property<String> this$saveAs = this.getSaveAs();
        Property<String> other$saveAs = other.getSaveAs();
        return !(this$saveAs == null ? other$saveAs != null : !((Object)this$saveAs).equals(other$saveAs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Download;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<Boolean> $failOnEmptyResponse = this.getFailOnEmptyResponse();
        result = result * 59 + ($failOnEmptyResponse == null ? 43 : ((Object)$failOnEmptyResponse).hashCode());
        Property<String> $saveAs = this.getSaveAs();
        result = result * 59 + ($saveAs == null ? 43 : ((Object)$saveAs).hashCode());
        return result;
    }

    @Generated
    public Property<Boolean> getFailOnEmptyResponse() {
        return this.failOnEmptyResponse;
    }

    @Generated
    public Property<String> getSaveAs() {
        return this.saveAs;
    }

    @Generated
    public Download() {
        this.failOnEmptyResponse = Download.$default$failOnEmptyResponse();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The URL of the downloaded file in Kestra's internal storage")
        private final URI uri;
        @Schema(title="The status code of the response")
        private final Integer code;
        @Schema(title="The content-length of the response")
        private final Long length;
        @Schema(title="The headers of the response")
        private final Map<String, List<String>> headers;

        @ConstructorProperties(value={"uri", "code", "length", "headers"})
        @Generated
        Output(URI uri, Integer code, Long length, Map<String, List<String>> headers) {
            this.uri = uri;
            this.code = code;
            this.length = length;
            this.headers = headers;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public Integer getCode() {
            return this.code;
        }

        @Generated
        public Long getLength() {
            return this.length;
        }

        @Generated
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;
            @Generated
            private Integer code;
            @Generated
            private Long length;
            @Generated
            private Map<String, List<String>> headers;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public OutputBuilder code(Integer code) {
                this.code = code;
                return this;
            }

            @Generated
            public OutputBuilder length(Long length) {
                this.length = length;
                return this;
            }

            @Generated
            public OutputBuilder headers(Map<String, List<String>> headers) {
                this.headers = headers;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri, this.code, this.length, this.headers);
            }

            @Generated
            public String toString() {
                return "Download.Output.OutputBuilder(uri=" + String.valueOf(this.uri) + ", code=" + this.code + ", length=" + this.length + ", headers=" + String.valueOf(this.headers) + ")";
            }
        }
    }

    @Generated
    public static abstract class DownloadBuilder<C extends Download, B extends DownloadBuilder<C, B>>
    extends AbstractHttp.AbstractHttpBuilder<C, B> {
        @Generated
        private boolean failOnEmptyResponse$set;
        @Generated
        private Property<Boolean> failOnEmptyResponse$value;
        @Generated
        private Property<String> saveAs;

        @Generated
        public B failOnEmptyResponse(Property<Boolean> failOnEmptyResponse) {
            this.failOnEmptyResponse$value = failOnEmptyResponse;
            this.failOnEmptyResponse$set = true;
            return (B)this.self();
        }

        @Generated
        public B saveAs(Property<String> saveAs) {
            this.saveAs = saveAs;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Download.DownloadBuilder(super=" + super.toString() + ", failOnEmptyResponse$value=" + String.valueOf(this.failOnEmptyResponse$value) + ", saveAs=" + String.valueOf(this.saveAs) + ")";
        }
    }

    @Generated
    private static final class DownloadBuilderImpl
    extends DownloadBuilder<Download, DownloadBuilderImpl> {
        @Generated
        private DownloadBuilderImpl() {
        }

        @Override
        @Generated
        protected DownloadBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Download build() {
            return new Download(this);
        }
    }
}

