/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.http;

import io.kestra.core.http.client.configurations.HttpConfiguration;
import io.kestra.core.http.client.configurations.SslOptions;
import io.kestra.core.models.property.Property;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;

public interface HttpInterface {
    @Schema(title="The fully-qualified URI that points to the HTTP destination")
    public Property<String> getUri();

    @Schema(title="The HTTP method to use")
    public Property<String> getMethod();

    @Schema(title="The query string parameter to use", description="Adds parameter to URI query. The parameter name and value are expected to be unescaped and may contain non ASCII characters.\nThe value can be a string or a list of strings.\nThis method will not override parameters already existing on `uri` and will add them as array.")
    public Property<Map<String, Object>> getParams();

    @Schema(title="The full body as a string")
    public Property<String> getBody();

    @Schema(title="The form data to be send")
    public Property<Map<String, Object>> getFormData();

    @Schema(title="The request content type")
    public Property<String> getContentType();

    @Schema(title="The headers to pass to the request")
    public Property<Map<CharSequence, CharSequence>> getHeaders();

    @Schema(title="The HTTP request options")
    public HttpConfiguration getOptions();

    @Schema(title="The SSL request options", description="This property is deprecated. Instead use the `options.ssl` property.")
    public SslOptions getSslOptions();
}

