/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.kv;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.kv.KVType;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.storages.kv.KVMetadata;
import io.kestra.core.storages.kv.KVStore;
import io.kestra.core.storages.kv.KVValueAndMetadata;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.time.Instant;
import lombok.Generated;

@Schema(title="Create or modify a Key-Value pair.")
@Plugin(examples={@Example(title="Set the task's `uri` output as a value for `orders_file` key.", full=true, code={"id: kv_store_set\nnamespace: company.team\n\ntasks:\n  - id: http_download\n    type: io.kestra.plugin.core.http.Download\n    uri: https://huggingface.co/datasets/kestra/datasets/raw/main/csv/orders.csv\n\n  - id: kv_set\n    type: io.kestra.plugin.core.kv.Set\n    key: orders_file\n    value: \"{{ outputs.http_download.uri }}\"\n    kvType: STRING\n"})})
public class Set
extends Task
implements RunnableTask<VoidOutput> {
    @NotNull
    @Schema(title="The key to set the value for")
    private Property<String> key;
    @Schema(title="The description of the KV pair")
    private Property<String> kvDescription;
    @NotNull
    @Schema(title="The value to map to the key")
    private Property<String> value;
    @NotNull
    @Schema(title="The namespace in which the KV pair will be stored \u2013 by default, Kestra will use the namespace of the flow.")
    private Property<String> namespace;
    @NotNull
    @Schema(title="Flag specifying whether to overwrite or fail if a value for the given key already exists.")
    private Property<Boolean> overwrite;
    @Schema(title="Optional Time-To-Live (TTL) duration for the key-value pair. If not set, the KV pair will never be deleted from internal storage.")
    private Property<Duration> ttl;
    @Schema(title="Enum representing the data type of the KV pair. If not set, the value will be stored as a string.")
    private Property<KVType> kvType;

    @Override
    public VoidOutput run(RunContext runContext) throws Exception {
        String renderedNamespace = runContext.render(this.namespace).as(String.class).orElse(null);
        String renderedKey = runContext.render(this.key).as(String.class).orElse(null);
        Object renderedValue = runContext.renderTyped(this.value.toString());
        KVStore kvStore = runContext.namespaceKv(renderedNamespace);
        if (this.kvType != null) {
            KVType renderedKvType = runContext.render(this.kvType).as(KVType.class).orElseThrow();
            if (renderedValue instanceof String) {
                String renderedValueStr = (String)renderedValue;
                renderedValue = switch (renderedKvType) {
                    case KVType.NUMBER -> (Number)JacksonMapper.ofJson().readValue(renderedValueStr, Number.class);
                    case KVType.BOOLEAN -> Boolean.parseBoolean((String)renderedValue);
                    case KVType.DATETIME, KVType.DATE -> Instant.parse(renderedValueStr);
                    case KVType.DURATION -> {
                        Duration.parse(renderedValueStr);
                        yield renderedValueStr;
                    }
                    case KVType.JSON -> JacksonMapper.toObject(renderedValueStr);
                    default -> renderedValue;
                };
            } else if (renderedValue instanceof Number) {
                Number valueNumber = (Number)renderedValue;
                if (renderedKvType == KVType.STRING) {
                    renderedValue = valueNumber.toString();
                }
            }
        }
        kvStore.put(renderedKey, new KVValueAndMetadata(new KVMetadata((String)runContext.render(this.kvDescription).as(String.class).orElse(null), runContext.render(this.ttl).as(Duration.class).orElse(null)), renderedValue), runContext.render(this.overwrite).as(Boolean.class).orElseThrow());
        return null;
    }

    @Generated
    private static Property<String> $default$namespace() {
        return Property.ofExpression("{{ flow.namespace }}");
    }

    @Generated
    private static Property<Boolean> $default$overwrite() {
        return Property.ofValue(true);
    }

    @Generated
    protected Set(SetBuilder<?, ?> b) {
        super(b);
        this.key = b.key;
        this.kvDescription = b.kvDescription;
        this.value = b.value;
        this.namespace = b.namespace$set ? b.namespace$value : Set.$default$namespace();
        this.overwrite = b.overwrite$set ? b.overwrite$value : Set.$default$overwrite();
        this.ttl = b.ttl;
        this.kvType = b.kvType;
    }

    @Generated
    public static SetBuilder<?, ?> builder() {
        return new SetBuilderImpl();
    }

    @Generated
    public SetBuilder<?, ?> toBuilder() {
        return new SetBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Property<String> getKey() {
        return this.key;
    }

    @Generated
    public Property<String> getKvDescription() {
        return this.kvDescription;
    }

    @Generated
    public Property<String> getValue() {
        return this.value;
    }

    @Generated
    public Property<String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Property<Boolean> getOverwrite() {
        return this.overwrite;
    }

    @Generated
    public Property<Duration> getTtl() {
        return this.ttl;
    }

    @Generated
    public Property<KVType> getKvType() {
        return this.kvType;
    }

    @Generated
    public Set() {
        this.namespace = Set.$default$namespace();
        this.overwrite = Set.$default$overwrite();
    }

    @Generated
    public static abstract class SetBuilder<C extends Set, B extends SetBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> key;
        @Generated
        private Property<String> kvDescription;
        @Generated
        private Property<String> value;
        @Generated
        private boolean namespace$set;
        @Generated
        private Property<String> namespace$value;
        @Generated
        private boolean overwrite$set;
        @Generated
        private Property<Boolean> overwrite$value;
        @Generated
        private Property<Duration> ttl;
        @Generated
        private Property<KVType> kvType;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Set instance, SetBuilder<?, ?> b) {
            b.key(instance.key);
            b.kvDescription(instance.kvDescription);
            b.value(instance.value);
            b.namespace(instance.namespace);
            b.overwrite(instance.overwrite);
            b.ttl(instance.ttl);
            b.kvType(instance.kvType);
        }

        @Generated
        public B key(Property<String> key) {
            this.key = key;
            return (B)this.self();
        }

        @Generated
        public B kvDescription(Property<String> kvDescription) {
            this.kvDescription = kvDescription;
            return (B)this.self();
        }

        @Generated
        public B value(Property<String> value) {
            this.value = value;
            return (B)this.self();
        }

        @Generated
        public B namespace(Property<String> namespace) {
            this.namespace$value = namespace;
            this.namespace$set = true;
            return (B)this.self();
        }

        @Generated
        public B overwrite(Property<Boolean> overwrite) {
            this.overwrite$value = overwrite;
            this.overwrite$set = true;
            return (B)this.self();
        }

        @Generated
        public B ttl(Property<Duration> ttl) {
            this.ttl = ttl;
            return (B)this.self();
        }

        @Generated
        public B kvType(Property<KVType> kvType) {
            this.kvType = kvType;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Set.SetBuilder(super=" + super.toString() + ", key=" + String.valueOf(this.key) + ", kvDescription=" + String.valueOf(this.kvDescription) + ", value=" + String.valueOf(this.value) + ", namespace$value=" + String.valueOf(this.namespace$value) + ", overwrite$value=" + String.valueOf(this.overwrite$value) + ", ttl=" + String.valueOf(this.ttl) + ", kvType=" + String.valueOf(this.kvType) + ")";
        }
    }

    @Generated
    private static final class SetBuilderImpl
    extends SetBuilder<Set, SetBuilderImpl> {
        @Generated
        private SetBuilderImpl() {
        }

        @Override
        @Generated
        protected SetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Set build() {
            return new Set(this);
        }
    }
}

