/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.kv;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.models.FetchVersion;
import io.kestra.core.models.QueryFilter;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.storages.kv.KVEntry;
import io.kestra.core.storages.kv.KVStore;
import io.kestra.core.validations.KvVersionBehaviorValidation;
import io.kestra.plugin.core.kv.PurgeBehavior;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

@KvVersionBehaviorValidation
public class Version
extends PurgeBehavior {
    @NotNull
    @JsonInclude
    protected String type;
    @Schema(title="The date before which versions should be purged.", description="Using this filter will never delete the last version of a KV to avoid accidental full data loss.")
    private String before;
    @Schema(title="How much versions should be kept for each matching KV.", description="By default, every matching versions will be purged.")
    private Integer keepAmount;

    @Override
    protected List<KVEntry> entriesToPurge(KVStore kvStore) throws IOException {
        ArrayListTotal<KVEntry> entries = kvStore.list(Pageable.UNPAGED.withSort(Sort.of((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"version")})), this.before == null ? Collections.emptyList() : List.of(QueryFilter.builder().field(QueryFilter.Field.UPDATED).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).value(ZonedDateTime.parse(this.before)).build()), true, true, this.before == null ? FetchVersion.ALL : FetchVersion.OLD);
        if (this.keepAmount != null) {
            return entries.stream().collect(Collectors.groupingBy(KVEntry::key)).values().stream().flatMap(entriesForAKey -> entriesForAKey.stream().skip(this.keepAmount.intValue())).toList();
        }
        return entries;
    }

    @Generated
    private static String $default$type() {
        return "version";
    }

    @Generated
    protected Version(VersionBuilder<?, ?> b) {
        super(b);
        this.type = b.type$set ? b.type$value : Version.$default$type();
        this.before = b.before;
        this.keepAmount = b.keepAmount;
    }

    @Generated
    public static VersionBuilder<?, ?> builder() {
        return new VersionBuilderImpl();
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getBefore() {
        return this.before;
    }

    @Generated
    public Integer getKeepAmount() {
        return this.keepAmount;
    }

    @Generated
    public Version() {
        this.type = Version.$default$type();
    }

    @Generated
    public static abstract class VersionBuilder<C extends Version, B extends VersionBuilder<C, B>>
    extends PurgeBehavior.PurgeBehaviorBuilder<C, B> {
        @Generated
        private boolean type$set;
        @Generated
        private String type$value;
        @Generated
        private String before;
        @Generated
        private Integer keepAmount;

        @Generated
        public B type(String type) {
            this.type$value = type;
            this.type$set = true;
            return (B)this.self();
        }

        @Generated
        public B before(String before) {
            this.before = before;
            return (B)this.self();
        }

        @Generated
        public B keepAmount(Integer keepAmount) {
            this.keepAmount = keepAmount;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Version.VersionBuilder(super=" + super.toString() + ", type$value=" + this.type$value + ", before=" + this.before + ", keepAmount=" + this.keepAmount + ")";
        }
    }

    @Generated
    private static final class VersionBuilderImpl
    extends VersionBuilder<Version, VersionBuilderImpl> {
        @Generated
        private VersionBuilderImpl() {
        }

        @Override
        @Generated
        protected VersionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Version build() {
            return new Version(this);
        }
    }
}

