/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.log;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.runners.PluginUtilsService;
import io.kestra.core.repositories.LogRepositoryInterface;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.FileSerde;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.event.Level;

@Schema(title="Fetch execution logs and store them in a file.", description="This task is useful to automate moving logs between various systems and environments.")
@Plugin(examples={@Example(code={"level: INFO", "executionId: \"{{ trigger.executionId }}\""}), @Example(code={"level: WARN", "executionId: \"{{ execution.id }}\"", "tasksId: ", "  - \"previous_task_id\""})}, aliases={"io.kestra.core.tasks.log.Fetch"})
public class Fetch
extends Task
implements RunnableTask<Output> {
    @Schema(title="Filter for a specific namespace in case `executionId` is set.")
    private Property<String> namespace;
    @Schema(title="Filter for a specific flow identifier in case `executionId` is set.")
    private Property<String> flowId;
    @Schema(title="Filter for a specific execution.", description="If not set, the task will use the ID of the current execution.\nIf set, it will try to locate the execution on the current flow unless the `namespace` and `flowId` properties are set.")
    private Property<String> executionId;
    @Schema(title="Filter for one or more task(s).")
    private Property<List<String>> tasksId;
    @Schema(title="The lowest log level that you want to fetch")
    private Property<Level> level;

    @Override
    public Output run(RunContext runContext) throws Exception {
        PluginUtilsService.ExecutionInfo executionInfo = PluginUtilsService.executionFromTaskParameters(runContext, runContext.render(this.namespace).as(String.class).orElse(null), runContext.render(this.flowId).as(String.class).orElse(null), runContext.render(this.executionId).as(String.class).orElse(null));
        LogRepositoryInterface logRepository = (LogRepositoryInterface)((DefaultRunContext)runContext).getApplicationContext().getBean(LogRepositoryInterface.class);
        File tempFile = runContext.workingDir().createTempFile(".ion").toFile();
        AtomicLong count = new AtomicLong();
        try (FileOutputStream output = new FileOutputStream(tempFile);){
            List<String> renderedTaskId = runContext.render(this.tasksId).asList(String.class);
            Level logLevel = runContext.render(this.level).as(Level.class).orElseThrow();
            if (!renderedTaskId.isEmpty()) {
                for (String taskId : renderedTaskId) {
                    logRepository.findByExecutionIdAndTaskId(executionInfo.tenantId(), executionInfo.namespace(), executionInfo.flowId(), executionInfo.id(), taskId, logLevel).forEach(Rethrow.throwConsumer(log -> {
                        count.incrementAndGet();
                        FileSerde.write(output, log);
                    }));
                }
            } else {
                logRepository.findByExecutionId(executionInfo.tenantId(), executionInfo.namespace(), executionInfo.flowId(), executionInfo.id(), logLevel).forEach(Rethrow.throwConsumer(log -> {
                    count.incrementAndGet();
                    FileSerde.write(output, log);
                }));
            }
        }
        return Output.builder().uri(runContext.storage().putFile(tempFile)).size(count.get()).build();
    }

    @Generated
    private static Property<Level> $default$level() {
        return Property.ofValue(Level.INFO);
    }

    @Generated
    protected Fetch(FetchBuilder<?, ?> b) {
        super(b);
        this.namespace = b.namespace;
        this.flowId = b.flowId;
        this.executionId = b.executionId;
        this.tasksId = b.tasksId;
        this.level = b.level$set ? b.level$value : Fetch.$default$level();
    }

    @Generated
    public static FetchBuilder<?, ?> builder() {
        return new FetchBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Fetch(super=" + super.toString() + ", namespace=" + String.valueOf(this.getNamespace()) + ", flowId=" + String.valueOf(this.getFlowId()) + ", executionId=" + String.valueOf(this.getExecutionId()) + ", tasksId=" + String.valueOf(this.getTasksId()) + ", level=" + String.valueOf(this.getLevel()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Fetch)) {
            return false;
        }
        Fetch other = (Fetch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$namespace = this.getNamespace();
        Property<String> other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !((Object)this$namespace).equals(other$namespace)) {
            return false;
        }
        Property<String> this$flowId = this.getFlowId();
        Property<String> other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !((Object)this$flowId).equals(other$flowId)) {
            return false;
        }
        Property<String> this$executionId = this.getExecutionId();
        Property<String> other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !((Object)this$executionId).equals(other$executionId)) {
            return false;
        }
        Property<List<String>> this$tasksId = this.getTasksId();
        Property<List<String>> other$tasksId = other.getTasksId();
        if (this$tasksId == null ? other$tasksId != null : !((Object)this$tasksId).equals(other$tasksId)) {
            return false;
        }
        Property<Level> this$level = this.getLevel();
        Property<Level> other$level = other.getLevel();
        return !(this$level == null ? other$level != null : !((Object)this$level).equals(other$level));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Fetch;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : ((Object)$namespace).hashCode());
        Property<String> $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : ((Object)$flowId).hashCode());
        Property<String> $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : ((Object)$executionId).hashCode());
        Property<List<String>> $tasksId = this.getTasksId();
        result = result * 59 + ($tasksId == null ? 43 : ((Object)$tasksId).hashCode());
        Property<Level> $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        return result;
    }

    @Generated
    public Property<String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Property<String> getFlowId() {
        return this.flowId;
    }

    @Generated
    public Property<String> getExecutionId() {
        return this.executionId;
    }

    @Generated
    public Property<List<String>> getTasksId() {
        return this.tasksId;
    }

    @Generated
    public Property<Level> getLevel() {
        return this.level;
    }

    @Generated
    public Fetch() {
        this.level = Fetch.$default$level();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The number of rows fetched")
        private Long size;
        @Schema(title="Internal storage URI of stored results", description="Stored as Amazon ION file in a row per row format.")
        private URI uri;

        @ConstructorProperties(value={"size", "uri"})
        @Generated
        Output(Long size, URI uri) {
            this.size = size;
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Long getSize() {
            return this.size;
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Long size;
            @Generated
            private URI uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder size(Long size) {
                this.size = size;
                return this;
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.size, this.uri);
            }

            @Generated
            public String toString() {
                return "Fetch.Output.OutputBuilder(size=" + this.size + ", uri=" + String.valueOf(this.uri) + ")";
            }
        }
    }

    @Generated
    public static abstract class FetchBuilder<C extends Fetch, B extends FetchBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> namespace;
        @Generated
        private Property<String> flowId;
        @Generated
        private Property<String> executionId;
        @Generated
        private Property<List<String>> tasksId;
        @Generated
        private boolean level$set;
        @Generated
        private Property<Level> level$value;

        @Generated
        public B namespace(Property<String> namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B flowId(Property<String> flowId) {
            this.flowId = flowId;
            return (B)this.self();
        }

        @Generated
        public B executionId(Property<String> executionId) {
            this.executionId = executionId;
            return (B)this.self();
        }

        @Generated
        public B tasksId(Property<List<String>> tasksId) {
            this.tasksId = tasksId;
            return (B)this.self();
        }

        @Generated
        public B level(Property<Level> level) {
            this.level$value = level;
            this.level$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Fetch.FetchBuilder(super=" + super.toString() + ", namespace=" + String.valueOf(this.namespace) + ", flowId=" + String.valueOf(this.flowId) + ", executionId=" + String.valueOf(this.executionId) + ", tasksId=" + String.valueOf(this.tasksId) + ", level$value=" + String.valueOf(this.level$value) + ")";
        }
    }

    @Generated
    private static final class FetchBuilderImpl
    extends FetchBuilder<Fetch, FetchBuilderImpl> {
        @Generated
        private FetchBuilderImpl() {
        }

        @Override
        @Generated
        protected FetchBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Fetch build() {
            return new Fetch(this);
        }
    }
}

