/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.metric;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.models.tasks.metrics.AbstractMetric;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;

@Schema(title="Publish Kestra metrics within an execution.", description="This task is useful to easily publish metrics for a flow.")
@Plugin(examples={@Example(full=true, code={"id: publish_metrics\nnamespace: company.team\n\ntasks:\n  - id: metric\n    type: io.kestra.plugin.core.metric.Publish\n    metrics:\n      - type: timer\n        name: duration\n        value: PT10M\n        tags:\n          flow: \"{{flow.id}}\"\n          project: kestra\n      - type: counter\n        name: number\n        value: 42\n        tags:\n          flow: \"{{flow.id}}\"\n          project: kestra\n"})})
public class Publish
extends Task
implements RunnableTask<VoidOutput> {
    @Schema(title="List of metrics to publish")
    private Property<List<AbstractMetric>> metrics;

    @Override
    public VoidOutput run(RunContext runContext) throws Exception {
        runContext.render(this.metrics).asList(AbstractMetric.class).stream().map(abstractMetric -> {
            try {
                return abstractMetric.toMetric(runContext);
            }
            catch (IllegalVariableEvaluationException e) {
                throw new RuntimeException(e);
            }
        }).toList().forEach(runContext::metric);
        return null;
    }

    @Generated
    protected Publish(PublishBuilder<?, ?> b) {
        super(b);
        this.metrics = b.metrics;
    }

    @Generated
    public static PublishBuilder<?, ?> builder() {
        return new PublishBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Publish(super=" + super.toString() + ", metrics=" + String.valueOf(this.getMetrics()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Publish)) {
            return false;
        }
        Publish other = (Publish)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<List<AbstractMetric>> this$metrics = this.getMetrics();
        Property<List<AbstractMetric>> other$metrics = other.getMetrics();
        return !(this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Publish;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<List<AbstractMetric>> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        return result;
    }

    @Generated
    public Property<List<AbstractMetric>> getMetrics() {
        return this.metrics;
    }

    @Generated
    public Publish() {
    }

    @Generated
    public static abstract class PublishBuilder<C extends Publish, B extends PublishBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<List<AbstractMetric>> metrics;

        @Generated
        public B metrics(Property<List<AbstractMetric>> metrics) {
            this.metrics = metrics;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Publish.PublishBuilder(super=" + super.toString() + ", metrics=" + String.valueOf(this.metrics) + ")";
        }
    }

    @Generated
    private static final class PublishBuilderImpl
    extends PublishBuilder<Publish, PublishBuilderImpl> {
        @Generated
        private PublishBuilderImpl() {
        }

        @Override
        @Generated
        protected PublishBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Publish build() {
            return new Publish(this);
        }
    }
}

