/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import com.fasterxml.jackson.core.type.TypeReference;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.IOUtils;

@Schema(title="Concat files from Kestra\u2019s internal storage.")
@Plugin(examples={@Example(title="Concat 2 files with a custom separator.", code={"files: ", "  - \"kestra://long/url/file1.txt\"", "  - \"kestra://long/url/file2.txt\"", "separator: \"\\n\""}), @Example(title="Concat files generated by an each task.", code={"tasks:", "  - id: each", "    type: io.kestra.plugin.core.flow.ForEach", "    tasks:", "      - id: start_api_call", "        type: io.kestra.plugin.scripts.shell.Commands", "        commands:", "          - echo {{ taskrun.value }} > {{ temp.generated }}", "        files:", "          - generated", "    values: '[\"value1\", \"value2\", \"value3\"]'", "", "  - id: concat", "    type: io.kestra.plugin.core.storage.Concat", "    files:", "      - \"{{ outputs.start_api_call.value1.files.generated }}\"", "      - \"{{ outputs.start_api_call.value2.files.generated }}\"", "      - \"{{ outputs.start_api_call.value3.files.generated }}\""}, full=true), @Example(title="Concat a dynamic number of files.", code={"tasks:", "  - id: echo", "    type: io.kestra.plugin.scripts.shell.Commands", "    commands:", "      - echo \"Hello John\" > {{ outputDirs.output }}/1.txt", "      - echo \"Hello Jane\" > {{ outputDirs.output }}/2.txt", "      - echo \"Hello Doe\" > {{ outputDirs.output }}/3.txt", "    outputDirs:", "      - output", "  - id: concat", "    type: io.kestra.plugin.core.storage.Concat", "    files: \"{{ outputs.echo.files | jq('.[]') }}\""}, full=true)}, aliases={"io.kestra.core.tasks.storages.Concat"})
public class Concat
extends Task
implements RunnableTask<Output> {
    @Schema(title="List of files to be concatenated", description="Must be `kestra://` storage URIs; it can be a list of strings or a JSON string.")
    @PluginProperty(dynamic=true, internalStorageURI=true)
    @NotNull
    private Object files;
    @Schema(title="The separator to used between files \u2014 the default is no separator")
    private Property<String> separator;
    @Schema(title="The extension of the created file \u2014 the default is `.tmp`")
    private Property<String> extension;

    @Override
    public Output run(RunContext runContext) throws Exception {
        File tempFile = runContext.workingDir().createTempFile(runContext.render(this.extension).as(String.class).orElseThrow()).toFile();
        try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile);){
            List finalFiles;
            Object object = this.files;
            if (object instanceof List) {
                List listValue;
                finalFiles = listValue = (List)object;
            } else {
                object = this.files;
                if (object instanceof String) {
                    String stringValue = (String)object;
                    TypeReference<List<String>> reference = new TypeReference<List<String>>(this){};
                    finalFiles = (List)JacksonMapper.ofJson(false).readValue(runContext.render(stringValue), (TypeReference)reference);
                } else {
                    throw new Exception("Invalid `files` properties with type '" + String.valueOf(this.files.getClass()) + "'");
                }
            }
            finalFiles.forEach(Rethrow.throwConsumer(s -> {
                URI from = new URI(runContext.render((String)s));
                try (InputStream inputStream = runContext.storage().getFile(from);){
                    IOUtils.copyLarge((InputStream)inputStream, (OutputStream)fileOutputStream);
                }
                if (this.separator != null) {
                    IOUtils.copy((InputStream)new ByteArrayInputStream(runContext.render(this.separator).as(String.class).orElseThrow().getBytes()), (OutputStream)fileOutputStream);
                }
            }));
        }
        return Output.builder().uri(runContext.storage().putFile(tempFile)).build();
    }

    @Generated
    private static Property<String> $default$extension() {
        return Property.ofValue(".tmp");
    }

    @Generated
    protected Concat(ConcatBuilder<?, ?> b) {
        super(b);
        this.files = b.files;
        this.separator = b.separator;
        this.extension = b.extension$set ? b.extension$value : Concat.$default$extension();
    }

    @Generated
    public static ConcatBuilder<?, ?> builder() {
        return new ConcatBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Concat(super=" + super.toString() + ", files=" + String.valueOf(this.getFiles()) + ", separator=" + String.valueOf(this.getSeparator()) + ", extension=" + String.valueOf(this.getExtension()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Concat)) {
            return false;
        }
        Concat other = (Concat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$files = this.getFiles();
        Object other$files = other.getFiles();
        if (this$files == null ? other$files != null : !this$files.equals(other$files)) {
            return false;
        }
        Property<String> this$separator = this.getSeparator();
        Property<String> other$separator = other.getSeparator();
        if (this$separator == null ? other$separator != null : !((Object)this$separator).equals(other$separator)) {
            return false;
        }
        Property<String> this$extension = this.getExtension();
        Property<String> other$extension = other.getExtension();
        return !(this$extension == null ? other$extension != null : !((Object)this$extension).equals(other$extension));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Concat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : $files.hashCode());
        Property<String> $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : ((Object)$separator).hashCode());
        Property<String> $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : ((Object)$extension).hashCode());
        return result;
    }

    @Generated
    public Object getFiles() {
        return this.files;
    }

    @Generated
    public Property<String> getSeparator() {
        return this.separator;
    }

    @Generated
    public Property<String> getExtension() {
        return this.extension;
    }

    @Generated
    public Concat() {
        this.extension = Concat.$default$extension();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The concatenated file URI")
        private final URI uri;

        @ConstructorProperties(value={"uri"})
        @Generated
        Output(URI uri) {
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri);
            }

            @Generated
            public String toString() {
                return "Concat.Output.OutputBuilder(uri=" + String.valueOf(this.uri) + ")";
            }
        }
    }

    @Generated
    public static abstract class ConcatBuilder<C extends Concat, B extends ConcatBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Object files;
        @Generated
        private Property<String> separator;
        @Generated
        private boolean extension$set;
        @Generated
        private Property<String> extension$value;

        @Generated
        public B files(Object files) {
            this.files = files;
            return (B)this.self();
        }

        @Generated
        public B separator(Property<String> separator) {
            this.separator = separator;
            return (B)this.self();
        }

        @Generated
        public B extension(Property<String> extension) {
            this.extension$value = extension;
            this.extension$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Concat.ConcatBuilder(super=" + super.toString() + ", files=" + String.valueOf(this.files) + ", separator=" + String.valueOf(this.separator) + ", extension$value=" + String.valueOf(this.extension$value) + ")";
        }
    }

    @Generated
    private static final class ConcatBuilderImpl
    extends ConcatBuilder<Concat, ConcatBuilderImpl> {
        @Generated
        private ConcatBuilderImpl() {
        }

        @Override
        @Generated
        protected ConcatBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Concat build() {
            return new Concat(this);
        }
    }
}

