/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.micronaut.core.util.functional.ThrowingFunction;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

@Schema(title="Deduplicate a file by retaining only the latest item for each extracted key.", description="The `Deduplicate` task involves reading the input file twice, rather than loading the entire file into memory.\nThe first iteration is used to build a deduplication map in memory containing the last lines observed for each key.\nThe second iteration is used to rewrite the file without the duplicates. The task must be used with this in mind.\n")
@Plugin(examples={@Example(code={"tasks:\n   - id: deduplicate\n     type: io.kestra.plugin.core.storage.DeduplicateItems\n     from: \"{{ inputs.uri }}\"\n     expr: \"{{ key }}\"\n"})}, aliases={"io.kestra.core.tasks.storages.DeduplicateItems"})
public class DeduplicateItems
extends Task
implements RunnableTask<Output> {
    @Schema(title="The file to be deduplicated")
    @NotNull
    @PluginProperty(internalStorageURI=true)
    private Property<String> from;
    @Schema(title="The Pebble expression to extract the deduplication key from each item", description="The 'pebble' expression can be used for constructing a composite key.")
    @PluginProperty
    @NotNull
    private String expr;

    @Override
    public Output run(RunContext runContext) throws Exception {
        URI from = new URI(runContext.render(this.from).as(String.class).orElseThrow());
        PebbleFieldExtractor keyExtractor = this.getKeyExtractor(runContext);
        HashMap<String, Long> index = new HashMap<String, Long>();
        try (BufferedReader reader = this.newBufferedReader(runContext, from);){
            String item;
            long offset = 0L;
            while ((item = reader.readLine()) != null) {
                String key = keyExtractor.apply(item);
                index.put(key, offset);
                ++offset;
            }
        }
        long processedItemsTotal = 0L;
        long droppedItemsTotal = 0L;
        long numKeys = index.size();
        Path path = runContext.workingDir().createTempFile(".ion");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
             BufferedReader reader = this.newBufferedReader(runContext, from);){
            String item;
            long offset = 0L;
            while ((item = reader.readLine()) != null) {
                String key = keyExtractor.apply(item);
                Long lastOffset = (Long)index.get(key);
                if (lastOffset != null && lastOffset == offset) {
                    writer.write(item);
                    writer.newLine();
                } else {
                    ++droppedItemsTotal;
                }
                ++offset;
                ++processedItemsTotal;
            }
        }
        URI uri = runContext.storage().putFile(path.toFile());
        index.clear();
        return Output.builder().uri(uri).numKeys(numKeys).processedItemsTotal(processedItemsTotal).droppedItemsTotal(droppedItemsTotal).build();
    }

    private PebbleFieldExtractor getKeyExtractor(RunContext runContext) {
        return new PebbleFieldExtractor(runContext, this.expr);
    }

    private BufferedReader newBufferedReader(RunContext runContext, URI objectURI) throws IOException {
        InputStream is = runContext.storage().getFile(objectURI);
        return new BufferedReader(new InputStreamReader(is));
    }

    @Generated
    protected DeduplicateItems(DeduplicateItemsBuilder<?, ?> b) {
        super(b);
        this.from = b.from;
        this.expr = b.expr;
    }

    @Generated
    public static DeduplicateItemsBuilder<?, ?> builder() {
        return new DeduplicateItemsBuilderImpl();
    }

    @Generated
    public String toString() {
        return "DeduplicateItems(super=" + super.toString() + ", from=" + String.valueOf(this.getFrom()) + ", expr=" + this.getExpr() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeduplicateItems)) {
            return false;
        }
        DeduplicateItems other = (DeduplicateItems)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$from = this.getFrom();
        Property<String> other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        String this$expr = this.getExpr();
        String other$expr = other.getExpr();
        return !(this$expr == null ? other$expr != null : !this$expr.equals(other$expr));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeduplicateItems;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        String $expr = this.getExpr();
        result = result * 59 + ($expr == null ? 43 : $expr.hashCode());
        return result;
    }

    @Generated
    public Property<String> getFrom() {
        return this.from;
    }

    @Generated
    public String getExpr() {
        return this.expr;
    }

    @Generated
    public DeduplicateItems() {
    }

    private static class PebbleFieldExtractor
    implements ThrowingFunction<String, String, Exception> {
        protected static final ObjectMapper MAPPER = JacksonMapper.ofIon();
        private final RunContext runContext;
        private final String expression;

        public PebbleFieldExtractor(RunContext runContext, String expression) {
            this.runContext = runContext;
            this.expression = expression;
        }

        public String apply(String data) throws Exception {
            try {
                return this.extract((Map)MAPPER.readValue(data, Map.class));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public String extract(Map<String, Object> item) throws Exception {
            return this.runContext.render(this.expression, item);
        }
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The deduplicated file URI")
        private final URI uri;
        @Schema(title="The number of distinct keys observed by the task")
        private final Long numKeys;
        @Schema(title="The total number of items that was processed by the task")
        private final Long processedItemsTotal;
        @Schema(title="The total number of items that was dropped by the task")
        private final Long droppedItemsTotal;

        @ConstructorProperties(value={"uri", "numKeys", "processedItemsTotal", "droppedItemsTotal"})
        @Generated
        Output(URI uri, Long numKeys, Long processedItemsTotal, Long droppedItemsTotal) {
            this.uri = uri;
            this.numKeys = numKeys;
            this.processedItemsTotal = processedItemsTotal;
            this.droppedItemsTotal = droppedItemsTotal;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public Long getNumKeys() {
            return this.numKeys;
        }

        @Generated
        public Long getProcessedItemsTotal() {
            return this.processedItemsTotal;
        }

        @Generated
        public Long getDroppedItemsTotal() {
            return this.droppedItemsTotal;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;
            @Generated
            private Long numKeys;
            @Generated
            private Long processedItemsTotal;
            @Generated
            private Long droppedItemsTotal;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public OutputBuilder numKeys(Long numKeys) {
                this.numKeys = numKeys;
                return this;
            }

            @Generated
            public OutputBuilder processedItemsTotal(Long processedItemsTotal) {
                this.processedItemsTotal = processedItemsTotal;
                return this;
            }

            @Generated
            public OutputBuilder droppedItemsTotal(Long droppedItemsTotal) {
                this.droppedItemsTotal = droppedItemsTotal;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri, this.numKeys, this.processedItemsTotal, this.droppedItemsTotal);
            }

            @Generated
            public String toString() {
                return "DeduplicateItems.Output.OutputBuilder(uri=" + String.valueOf(this.uri) + ", numKeys=" + this.numKeys + ", processedItemsTotal=" + this.processedItemsTotal + ", droppedItemsTotal=" + this.droppedItemsTotal + ")";
            }
        }
    }

    @Generated
    public static abstract class DeduplicateItemsBuilder<C extends DeduplicateItems, B extends DeduplicateItemsBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> from;
        @Generated
        private String expr;

        @Generated
        public B from(Property<String> from) {
            this.from = from;
            return (B)this.self();
        }

        @Generated
        public B expr(String expr) {
            this.expr = expr;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DeduplicateItems.DeduplicateItemsBuilder(super=" + super.toString() + ", from=" + String.valueOf(this.from) + ", expr=" + this.expr + ")";
        }
    }

    @Generated
    private static final class DeduplicateItemsBuilderImpl
    extends DeduplicateItemsBuilder<DeduplicateItems, DeduplicateItemsBuilderImpl> {
        @Generated
        private DeduplicateItemsBuilderImpl() {
        }

        @Override
        @Generated
        protected DeduplicateItemsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DeduplicateItems build() {
            return new DeduplicateItems(this);
        }
    }
}

