/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.StorageInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.NoSuchElementException;
import lombok.Generated;

@Schema(title="Delete a file from Kestra's internal storage.")
@Plugin(examples={@Example(code={"uri: \"kestra://long/url/file.txt\""})}, aliases={"io.kestra.core.tasks.storages.Delete"})
public class Delete
extends Task
implements RunnableTask<Output> {
    @Schema(title="The file to be deleted")
    @NotNull
    @PluginProperty(internalStorageURI=true)
    private Property<String> uri;
    @Schema(title="Raise an error if the file is not found")
    private final Property<Boolean> errorOnMissing;

    @Override
    public Output run(RunContext runContext) throws Exception {
        StorageInterface storageInterface = (StorageInterface)((DefaultRunContext)runContext).getApplicationContext().getBean(StorageInterface.class);
        URI render = URI.create(runContext.render(this.uri).as(String.class).orElseThrow());
        boolean delete = storageInterface.delete(runContext.flowInfo().tenantId(), runContext.flowInfo().namespace(), render);
        if (runContext.render(this.errorOnMissing).as(Boolean.class).orElseThrow().booleanValue() && !delete) {
            throw new NoSuchElementException("Unable to find file '" + String.valueOf(render) + "'");
        }
        return Output.builder().uri(render).deleted(delete).build();
    }

    @Generated
    private static Property<Boolean> $default$errorOnMissing() {
        return Property.ofValue(false);
    }

    @Generated
    protected Delete(DeleteBuilder<?, ?> b) {
        super(b);
        this.uri = b.uri;
        this.errorOnMissing = b.errorOnMissing$set ? b.errorOnMissing$value : Delete.$default$errorOnMissing();
    }

    @Generated
    public static DeleteBuilder<?, ?> builder() {
        return new DeleteBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Delete(super=" + super.toString() + ", uri=" + String.valueOf(this.getUri()) + ", errorOnMissing=" + String.valueOf(this.getErrorOnMissing()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Delete)) {
            return false;
        }
        Delete other = (Delete)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$uri = this.getUri();
        Property<String> other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        Property<Boolean> this$errorOnMissing = this.getErrorOnMissing();
        Property<Boolean> other$errorOnMissing = other.getErrorOnMissing();
        return !(this$errorOnMissing == null ? other$errorOnMissing != null : !((Object)this$errorOnMissing).equals(other$errorOnMissing));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Delete;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        Property<Boolean> $errorOnMissing = this.getErrorOnMissing();
        result = result * 59 + ($errorOnMissing == null ? 43 : ((Object)$errorOnMissing).hashCode());
        return result;
    }

    @Generated
    public Property<String> getUri() {
        return this.uri;
    }

    @Generated
    public Property<Boolean> getErrorOnMissing() {
        return this.errorOnMissing;
    }

    @Generated
    public Delete() {
        this.errorOnMissing = Delete.$default$errorOnMissing();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The deleted file URI")
        private final URI uri;
        @Schema(title="A flag for whether the file was deleted")
        private final Boolean deleted;

        @ConstructorProperties(value={"uri", "deleted"})
        @Generated
        Output(URI uri, Boolean deleted) {
            this.uri = uri;
            this.deleted = deleted;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public Boolean getDeleted() {
            return this.deleted;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;
            @Generated
            private Boolean deleted;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public OutputBuilder deleted(Boolean deleted) {
                this.deleted = deleted;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri, this.deleted);
            }

            @Generated
            public String toString() {
                return "Delete.Output.OutputBuilder(uri=" + String.valueOf(this.uri) + ", deleted=" + this.deleted + ")";
            }
        }
    }

    @Generated
    public static abstract class DeleteBuilder<C extends Delete, B extends DeleteBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> uri;
        @Generated
        private boolean errorOnMissing$set;
        @Generated
        private Property<Boolean> errorOnMissing$value;

        @Generated
        public B uri(Property<String> uri) {
            this.uri = uri;
            return (B)this.self();
        }

        @Generated
        public B errorOnMissing(Property<Boolean> errorOnMissing) {
            this.errorOnMissing$value = errorOnMissing;
            this.errorOnMissing$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Delete.DeleteBuilder(super=" + super.toString() + ", uri=" + String.valueOf(this.uri) + ", errorOnMissing$value=" + String.valueOf(this.errorOnMissing$value) + ")";
        }
    }

    @Generated
    private static final class DeleteBuilderImpl
    extends DeleteBuilder<Delete, DeleteBuilderImpl> {
        @Generated
        private DeleteBuilderImpl() {
        }

        @Override
        @Generated
        protected DeleteBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Delete build() {
            return new Delete(this);
        }
    }
}

