/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.List;
import lombok.Generated;

@Schema(title="Purge all files from Kestra's internal storage created by this execution.", description="This will delete all the generated files from a flow for the current execution. This will delete all files from:\n- inputs\n- outputs\n- triggers\n\nIf the current execution doesn't have any generated files, the task will not fail.")
@Plugin(examples={@Example(code={})}, aliases={"io.kestra.core.tasks.storages.PurgeExecution", "io.kestra.plugin.core.storage.PurgeExecution"})
public class PurgeCurrentExecutionFiles
extends Task
implements RunnableTask<Output> {
    @Override
    public Output run(RunContext runContext) throws Exception {
        return Output.builder().uris(runContext.storage().deleteExecutionFiles()).build();
    }

    @Generated
    protected PurgeCurrentExecutionFiles(PurgeCurrentExecutionFilesBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static PurgeCurrentExecutionFilesBuilder<?, ?> builder() {
        return new PurgeCurrentExecutionFilesBuilderImpl();
    }

    @Generated
    public String toString() {
        return "PurgeCurrentExecutionFiles(super=" + super.toString() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PurgeCurrentExecutionFiles)) {
            return false;
        }
        PurgeCurrentExecutionFiles other = (PurgeCurrentExecutionFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PurgeCurrentExecutionFiles;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public PurgeCurrentExecutionFiles() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The deleted file URIs from Kestra's internal storage")
        private final List<URI> uris;

        @ConstructorProperties(value={"uris"})
        @Generated
        Output(List<URI> uris) {
            this.uris = uris;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public List<URI> getUris() {
            return this.uris;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private List<URI> uris;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uris(List<URI> uris) {
                this.uris = uris;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uris);
            }

            @Generated
            public String toString() {
                return "PurgeCurrentExecutionFiles.Output.OutputBuilder(uris=" + String.valueOf(this.uris) + ")";
            }
        }
    }

    @Generated
    private static final class PurgeCurrentExecutionFilesBuilderImpl
    extends PurgeCurrentExecutionFilesBuilder<PurgeCurrentExecutionFiles, PurgeCurrentExecutionFilesBuilderImpl> {
        @Generated
        private PurgeCurrentExecutionFilesBuilderImpl() {
        }

        @Override
        @Generated
        protected PurgeCurrentExecutionFilesBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PurgeCurrentExecutionFiles build() {
            return new PurgeCurrentExecutionFiles(this);
        }
    }

    @Generated
    public static abstract class PurgeCurrentExecutionFilesBuilder<C extends PurgeCurrentExecutionFiles, B extends PurgeCurrentExecutionFilesBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PurgeCurrentExecutionFiles.PurgeCurrentExecutionFilesBuilder(super=" + super.toString() + ")";
        }
    }
}

