/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.FileUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ReversedLinesFileReader;

@Schema(title="Reverse a file from Kestra's internal storage, last line first.")
@Plugin(examples={@Example(code={"from: \"kestra://long/url/file1.txt\""})}, aliases={"io.kestra.core.tasks.storages.Reverse"})
public class Reverse
extends Task
implements RunnableTask<Output> {
    @Schema(title="The file to be split")
    @NotNull
    @PluginProperty(internalStorageURI=true)
    private Property<String> from;
    @Schema(title="The separator used to join the file into chunks. By default, it's a newline `\\n` character. If you are on Windows, you might want to use `\\r\\n` instead.")
    private Property<String> separator;
    @Schema(title="The name of a supported charset")
    private final Property<String> charset;

    @Override
    public Output run(RunContext runContext) throws Exception {
        URI from = new URI(runContext.render(this.from).as(String.class).orElseThrow());
        String extension = FileUtils.getExtension(from);
        String separator = runContext.render(this.separator).as(String.class).orElseThrow();
        Charset charset = Charsets.toCharset((String)runContext.render(this.charset).as(String.class).orElseThrow());
        File tempFile = runContext.workingDir().createTempFile(extension).toFile();
        File originalFile = runContext.workingDir().createTempFile(extension).toFile();
        try (FileOutputStream outputStream = new FileOutputStream(originalFile);){
            IOUtils.copyLarge((InputStream)runContext.storage().getFile(from), (OutputStream)outputStream);
        }
        ReversedLinesFileReader reversedLinesFileReader = ((ReversedLinesFileReader.Builder)((ReversedLinesFileReader.Builder)ReversedLinesFileReader.builder().setPath(originalFile.toPath())).setCharset(charset)).get();
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(tempFile));){
            String line;
            while ((line = reversedLinesFileReader.readLine()) != null) {
                output.write((line + separator).getBytes(charset));
            }
        }
        return Output.builder().uri(runContext.storage().putFile(tempFile)).build();
    }

    @Generated
    private static Property<String> $default$separator() {
        return Property.ofValue("\n");
    }

    @Generated
    private static Property<String> $default$charset() {
        return Property.ofValue(StandardCharsets.UTF_8.name());
    }

    @Generated
    protected Reverse(ReverseBuilder<?, ?> b) {
        super(b);
        this.from = b.from;
        this.separator = b.separator$set ? b.separator$value : Reverse.$default$separator();
        this.charset = b.charset$set ? b.charset$value : Reverse.$default$charset();
    }

    @Generated
    public static ReverseBuilder<?, ?> builder() {
        return new ReverseBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Reverse(super=" + super.toString() + ", from=" + String.valueOf(this.getFrom()) + ", separator=" + String.valueOf(this.getSeparator()) + ", charset=" + String.valueOf(this.getCharset()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reverse)) {
            return false;
        }
        Reverse other = (Reverse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$from = this.getFrom();
        Property<String> other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Property<String> this$separator = this.getSeparator();
        Property<String> other$separator = other.getSeparator();
        if (this$separator == null ? other$separator != null : !((Object)this$separator).equals(other$separator)) {
            return false;
        }
        Property<String> this$charset = this.getCharset();
        Property<String> other$charset = other.getCharset();
        return !(this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Reverse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Property<String> $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : ((Object)$separator).hashCode());
        Property<String> $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        return result;
    }

    @Generated
    public Property<String> getFrom() {
        return this.from;
    }

    @Generated
    public Property<String> getSeparator() {
        return this.separator;
    }

    @Generated
    public Property<String> getCharset() {
        return this.charset;
    }

    @Generated
    public Reverse() {
        this.separator = Reverse.$default$separator();
        this.charset = Reverse.$default$charset();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The URIs of reverse files in the Kestra's internal storage")
        private final URI uri;

        @ConstructorProperties(value={"uri"})
        @Generated
        Output(URI uri) {
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri);
            }

            @Generated
            public String toString() {
                return "Reverse.Output.OutputBuilder(uri=" + String.valueOf(this.uri) + ")";
            }
        }
    }

    @Generated
    public static abstract class ReverseBuilder<C extends Reverse, B extends ReverseBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> from;
        @Generated
        private boolean separator$set;
        @Generated
        private Property<String> separator$value;
        @Generated
        private boolean charset$set;
        @Generated
        private Property<String> charset$value;

        @Generated
        public B from(Property<String> from) {
            this.from = from;
            return (B)this.self();
        }

        @Generated
        public B separator(Property<String> separator) {
            this.separator$value = separator;
            this.separator$set = true;
            return (B)this.self();
        }

        @Generated
        public B charset(Property<String> charset) {
            this.charset$value = charset;
            this.charset$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Reverse.ReverseBuilder(super=" + super.toString() + ", from=" + String.valueOf(this.from) + ", separator$value=" + String.valueOf(this.separator$value) + ", charset$value=" + String.valueOf(this.charset$value) + ")";
        }
    }

    @Generated
    private static final class ReverseBuilderImpl
    extends ReverseBuilder<Reverse, ReverseBuilderImpl> {
        @Generated
        private ReverseBuilderImpl() {
        }

        @Override
        @Generated
        protected ReverseBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Reverse build() {
            return new Reverse(this);
        }
    }
}

