/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import io.kestra.core.cache.NoopCache;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class NoopCacheTest {
    private Cache<String, String> cache = new NoopCache();

    NoopCacheTest() {
    }

    @Test
    void getIfPresent() {
        this.cache.put((Object)"key", (Object)"value");
        Assertions.assertThat((String)((String)this.cache.getIfPresent((Object)"key"))).isNull();
    }

    @Test
    void get() {
        this.cache.put((Object)"key", (Object)"value");
        Assertions.assertThat((String)((String)this.cache.get((Object)"key", k -> "value"))).isEqualTo("value");
    }

    @Test
    void getAllPresent() {
        this.cache.put((Object)"key", (Object)"value");
        Assertions.assertThat((Map)this.cache.getAllPresent(List.of("key"))).hasSize(0);
    }

    @Test
    void getAll() {
        this.cache.put((Object)"key", (Object)"value");
        Assertions.assertThat((Map)this.cache.getAll(List.of("key"), it -> Map.of("key", "value"))).hasSize(0);
    }

    @Test
    void putAll() {
        this.cache.putAll(Map.of("key", "value"));
        Assertions.assertThat((Map)this.cache.getAllPresent(List.of("key"))).hasSize(0);
    }

    @Test
    void invalidate() {
        this.cache.put((Object)"key", (Object)"value");
        this.cache.invalidate((Object)"key");
        Assertions.assertThat((String)((String)this.cache.getIfPresent((Object)"key"))).isNull();
    }

    @Test
    void invalidateAll() {
        this.cache.putAll(Map.of("key", "value"));
        this.cache.invalidateAll();
        Assertions.assertThat((String)((String)this.cache.getIfPresent((Object)"key"))).isNull();
    }

    @Test
    void estimatedSize() {
        this.cache.put((Object)"key", (Object)"value");
        Assertions.assertThat((long)this.cache.estimatedSize()).isEqualTo(0L);
    }

    @Test
    void stats() {
        this.cache.put((Object)"key", (Object)"value");
        Assertions.assertThat((Object)this.cache.stats()).isEqualTo((Object)CacheStats.empty());
    }

    @Test
    void asMap() {
        this.cache.put((Object)"key", (Object)"value");
        Assertions.assertThat((Map)this.cache.asMap()).hasSize(0);
    }

    @Test
    void cleanUp() {
        this.cache.put((Object)"key", (Object)"value");
        this.cache.cleanUp();
        Assertions.assertThat((Map)this.cache.getAllPresent(List.of("key"))).hasSize(0);
    }

    @Test
    void policy() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> this.cache.policy());
    }
}

