/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import io.kestra.core.Helpers;
import io.kestra.core.docs.ClassPluginDocumentation;
import io.kestra.core.docs.JsonSchemaGenerator;
import io.kestra.core.models.property.DynamicPropertyExampleTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.plugins.PluginClassAndMetadata;
import io.kestra.core.plugins.PluginScanner;
import io.kestra.core.plugins.RegisteredPlugin;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.core.runner.Process;
import io.kestra.plugin.core.trigger.Schedule;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ClassPluginDocumentationTest {
    ClassPluginDocumentationTest() {
    }

    @Test
    void tasks() throws URISyntaxException {
        Helpers.runApplicationContext((Consumer)Rethrow.throwConsumer(applicationContext -> {
            JsonSchemaGenerator jsonSchemaGenerator = (JsonSchemaGenerator)applicationContext.getBean(JsonSchemaGenerator.class);
            Path plugins = Paths.get(Objects.requireNonNull(ClassPluginDocumentationTest.class.getClassLoader().getResource("plugins")).toURI());
            PluginScanner pluginScanner = new PluginScanner(ClassPluginDocumentationTest.class.getClassLoader());
            List scan = pluginScanner.scan(plugins);
            Assertions.assertThat((int)scan.size()).isEqualTo(1);
            Assertions.assertThat((int)((RegisteredPlugin)scan.getFirst()).getTasks().size()).isEqualTo(1);
            PluginClassAndMetadata metadata = PluginClassAndMetadata.create((RegisteredPlugin)((RegisteredPlugin)scan.getFirst()), (Class)((Class)((RegisteredPlugin)scan.getFirst()).getTasks().getFirst()), Task.class, null);
            ClassPluginDocumentation doc = ClassPluginDocumentation.of((JsonSchemaGenerator)jsonSchemaGenerator, (PluginClassAndMetadata)metadata, (String)((RegisteredPlugin)scan.getFirst()).version(), (boolean)false);
            Assertions.assertThat((int)doc.getDocExamples().size()).isEqualTo(2);
            Assertions.assertThat((String)doc.getIcon()).isNotNull();
            Assertions.assertThat((int)doc.getInputs().size()).isEqualTo(5);
            Assertions.assertThat((String)doc.getDocLicense()).isEqualTo("EE");
            Assertions.assertThat((String)((String)((Map)doc.getInputs().get("format")).get("type"))).isEqualTo("string");
            Assertions.assertThat((String)((String)((Map)doc.getInputs().get("format")).get("default"))).isEqualTo("{}");
            Assertions.assertThat((String)((String)((Map)doc.getInputs().get("format")).get("pattern"))).isEqualTo(".*");
            Assertions.assertThat((String)((String)((Map)doc.getInputs().get("format")).get("description"))).contains(new CharSequence[]{"of this input"});
            Assertions.assertThat((int)doc.getDefs().size()).isEqualTo(5);
            Map enumProperties = (Map)((Map)((Map)doc.getDefs().get("io.kestra.plugin.templates.ExampleTask-PropertyChildInput")).get("properties")).get("childEnum");
            Assertions.assertThat((int)((List)enumProperties.get("enum")).size()).isEqualTo(2);
            Assertions.assertThat((List)((List)enumProperties.get("enum"))).containsExactlyInAnyOrder((Object[])new String[]{"VALUE_1", "VALUE_2"});
            Map childInput = (Map)((Map)doc.getDefs().get("io.kestra.plugin.templates.ExampleTask-PropertyChildInput")).get("properties");
            Map childInputList = (Map)childInput.get("list");
            Assertions.assertThat((String)((String)childInputList.get("type"))).isEqualTo("array");
            Assertions.assertThat((String)((String)childInputList.get("title"))).isEqualTo("List of string");
            Assertions.assertThat((Integer)((Integer)childInputList.get("minItems"))).isEqualTo(1);
            Assertions.assertThat((String)((String)((Map)childInputList.get("items")).get("type"))).isEqualTo("string");
            Map childInputMap = (Map)childInput.get("map");
            Assertions.assertThat((String)((String)childInputMap.get("type"))).isEqualTo("object");
            Assertions.assertThat((Boolean)((Boolean)childInputMap.get("$dynamic"))).isTrue();
            Assertions.assertThat((String)((String)((Map)childInputMap.get("additionalProperties")).get("type"))).isEqualTo("number");
            Map childOutput = (Map)((Map)doc.getDefs().get("io.kestra.plugin.templates.AbstractTask-OutputChild")).get("properties");
            Assertions.assertThat((String)((String)((Map)childOutput.get("value")).get("type"))).isEqualTo("string");
            Assertions.assertThat(((Map)childOutput.get("outputChildMap")).get("type")).isEqualTo((Object)"object");
            Assertions.assertThat((String)((String)((Map)((Map)childOutput.get("outputChildMap")).get("additionalProperties")).get("$ref"))).contains(new CharSequence[]{"OutputMap"});
            Map propertiesChild = (Map)doc.getDefs().get("io.kestra.plugin.templates.ExampleTask-PropertyChildInput");
            Assertions.assertThat((int)((List)propertiesChild.get("required")).size()).isEqualTo(3);
            Map outputMap = (Map)((Map)doc.getDefs().get("io.kestra.plugin.templates.AbstractTask-OutputMap")).get("properties");
            Assertions.assertThat((int)outputMap.size()).isEqualTo(2);
            Assertions.assertThat(((Map)outputMap.get("code")).get("type")).isEqualTo((Object)"integer");
        }));
    }

    @Test
    void trigger() throws URISyntaxException {
        Helpers.runApplicationContext((Consumer)Rethrow.throwConsumer(applicationContext -> {
            JsonSchemaGenerator jsonSchemaGenerator = (JsonSchemaGenerator)applicationContext.getBean(JsonSchemaGenerator.class);
            PluginScanner pluginScanner = new PluginScanner(ClassPluginDocumentationTest.class.getClassLoader());
            RegisteredPlugin scan = pluginScanner.scan();
            PluginClassAndMetadata metadata = PluginClassAndMetadata.create((RegisteredPlugin)scan, Schedule.class, AbstractTrigger.class, null);
            ClassPluginDocumentation doc = ClassPluginDocumentation.of((JsonSchemaGenerator)jsonSchemaGenerator, (PluginClassAndMetadata)metadata, (String)scan.version(), (boolean)true);
            Assertions.assertThat((int)doc.getDefs().size()).isEqualTo(20);
            Assertions.assertThat((String)doc.getDocLicense()).isNull();
            Assertions.assertThat(((Map)doc.getDefs().get("io.kestra.core.models.tasks.WorkerGroup")).get("type")).isEqualTo((Object)"object");
            Assertions.assertThat((int)((Map)((Map)doc.getDefs().get("io.kestra.core.models.tasks.WorkerGroup")).get("properties")).size()).isEqualTo(2);
        }));
    }

    @Test
    void taskRunner() throws URISyntaxException {
        Helpers.runApplicationContext((Consumer)Rethrow.throwConsumer(applicationContext -> {
            JsonSchemaGenerator jsonSchemaGenerator = (JsonSchemaGenerator)applicationContext.getBean(JsonSchemaGenerator.class);
            PluginScanner pluginScanner = new PluginScanner(ClassPluginDocumentationTest.class.getClassLoader());
            RegisteredPlugin scan = pluginScanner.scan();
            PluginClassAndMetadata metadata = PluginClassAndMetadata.create((RegisteredPlugin)scan, Process.class, Process.class, null);
            ClassPluginDocumentation doc = ClassPluginDocumentation.of((JsonSchemaGenerator)jsonSchemaGenerator, (PluginClassAndMetadata)metadata, (String)scan.version(), (boolean)false);
            Assertions.assertThat(((Map)doc.getPropertiesSchema().get("properties")).get("version")).isNotNull();
            Assertions.assertThat((String)doc.getCls()).isEqualTo("io.kestra.plugin.core.runner.Process");
            Assertions.assertThat(doc.getPropertiesSchema().get("title")).isEqualTo((Object)"Task runner that executes a task as a subprocess on the Kestra host.");
            Assertions.assertThat((Map)doc.getDefs()).isEmpty();
        }));
    }

    @Test
    void dynamicProperty() throws URISyntaxException {
        Helpers.runApplicationContext((Consumer)Rethrow.throwConsumer(applicationContext -> {
            JsonSchemaGenerator jsonSchemaGenerator = (JsonSchemaGenerator)applicationContext.getBean(JsonSchemaGenerator.class);
            PluginScanner pluginScanner = new PluginScanner(ClassPluginDocumentationTest.class.getClassLoader());
            RegisteredPlugin scan = pluginScanner.scan();
            PluginClassAndMetadata metadata = PluginClassAndMetadata.create((RegisteredPlugin)scan, DynamicPropertyExampleTask.class, DynamicPropertyExampleTask.class, null);
            ClassPluginDocumentation doc = ClassPluginDocumentation.of((JsonSchemaGenerator)jsonSchemaGenerator, (PluginClassAndMetadata)metadata, (String)scan.version(), (boolean)true);
            Assertions.assertThat((String)doc.getCls()).isEqualTo("io.kestra.core.models.property.DynamicPropertyExampleTask");
            Assertions.assertThat((Map)doc.getDefs()).hasSize(6);
            Map properties = (Map)doc.getPropertiesSchema().get("properties");
            Assertions.assertThat((Map)properties).hasSize(21);
            Map number = (Map)properties.get("number");
            Assertions.assertThat(number.get("anyOf")).isNotNull();
            List anyOf = (List)number.get("anyOf");
            Assertions.assertThat((List)anyOf).hasSize(2);
            Assertions.assertThat(((Map)anyOf.getFirst()).get("type")).isEqualTo((Object)"integer");
            Assertions.assertThat((Boolean)((Boolean)((Map)anyOf.getFirst()).get("$dynamic"))).isTrue();
            Assertions.assertThat(((Map)anyOf.get(1)).get("type")).isEqualTo((Object)"string");
            Map withDefault = (Map)properties.get("withDefault");
            Assertions.assertThat(withDefault.get("type")).isEqualTo((Object)"string");
            Assertions.assertThat(withDefault.get("default")).isEqualTo((Object)"Default Value");
            Assertions.assertThat((Boolean)((Boolean)withDefault.get("$dynamic"))).isTrue();
        }));
    }
}

