/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import io.kestra.core.docs.ClassPluginDocumentation;
import io.kestra.core.docs.ClassPluginDocumentationTest;
import io.kestra.core.docs.Document;
import io.kestra.core.docs.DocumentationGenerator;
import io.kestra.core.docs.JsonSchemaGenerator;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.plugins.PluginClassAndMetadata;
import io.kestra.core.plugins.PluginScanner;
import io.kestra.core.plugins.RegisteredPlugin;
import io.kestra.plugin.core.debug.Echo;
import io.kestra.plugin.core.debug.Return;
import io.kestra.plugin.core.flow.Dag;
import io.kestra.plugin.core.flow.Subflow;
import io.kestra.plugin.core.runner.Process;
import io.kestra.plugin.core.state.Set;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@KestraTest
@Execution(value=ExecutionMode.SAME_THREAD)
class DocumentationGeneratorTest {
    @Inject
    JsonSchemaGenerator jsonSchemaGenerator;
    @Inject
    DocumentationGenerator documentationGenerator;

    DocumentationGeneratorTest() {
    }

    @Test
    void tasks() throws URISyntaxException, IOException {
        Path plugins = Paths.get(Objects.requireNonNull(ClassPluginDocumentationTest.class.getClassLoader().getResource("plugins")).toURI());
        PluginScanner pluginScanner = new PluginScanner(ClassPluginDocumentationTest.class.getClassLoader());
        List scan = pluginScanner.scan(plugins);
        Assertions.assertThat((int)scan.size()).isEqualTo(1);
        PluginClassAndMetadata metadata = PluginClassAndMetadata.create((RegisteredPlugin)((RegisteredPlugin)scan.getFirst()), (Class)((Class)((RegisteredPlugin)scan.getFirst()).getTasks().getFirst()), Task.class, null);
        ClassPluginDocumentation doc = ClassPluginDocumentation.of((JsonSchemaGenerator)this.jsonSchemaGenerator, (PluginClassAndMetadata)metadata, (String)((RegisteredPlugin)scan.getFirst()).version(), (boolean)false);
        String render = DocumentationGenerator.render((ClassPluginDocumentation)doc);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"ExampleTask"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"description: \"Short description for this task\""});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"`VALUE_1`"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"`VALUE_2`"});
    }

    @Test
    void dag() throws IOException {
        PluginScanner pluginScanner = new PluginScanner(ClassPluginDocumentationTest.class.getClassLoader());
        RegisteredPlugin scan = pluginScanner.scan();
        Class dag = (Class)scan.findClass(Dag.class.getName()).orElseThrow();
        PluginClassAndMetadata metadata = PluginClassAndMetadata.create((RegisteredPlugin)scan, (Class)dag, Task.class, null);
        ClassPluginDocumentation doc = ClassPluginDocumentation.of((JsonSchemaGenerator)this.jsonSchemaGenerator, (PluginClassAndMetadata)metadata, (String)scan.version(), (boolean)false);
        String render = DocumentationGenerator.render((ClassPluginDocumentation)doc);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"Dag"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"**Required:** \u2714\ufe0f"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"`concurrent`"});
        Assertions.assertThat((String)render).doesNotContain(new CharSequence[]{"requires an Enterprise Edition"});
        int propertiesIndex = render.indexOf("Properties");
        int definitionsIndex = render.indexOf("Definitions");
        DocumentationGeneratorTest.assertRequiredPropsAreFirst(render.substring(propertiesIndex, definitionsIndex));
        String definitionsDoc = render.substring(definitionsIndex);
        Arrays.stream(definitionsDoc.split("[^#]### ")).skip(1L).forEach(DocumentationGeneratorTest::assertRequiredPropsAreFirst);
    }

    private static void assertRequiredPropsAreFirst(String propertiesDoc) {
        int lastRequiredPropIndex = propertiesDoc.lastIndexOf("* **Required:** \u2714\ufe0f");
        int firstOptionalPropIndex = propertiesDoc.indexOf("* **Required:** \u274c");
        if (lastRequiredPropIndex != -1 && firstOptionalPropIndex != -1) {
            Assertions.assertThat((int)lastRequiredPropIndex).isLessThanOrEqualTo(firstOptionalPropIndex);
        }
    }

    @Test
    void returnDoc() throws IOException {
        PluginScanner pluginScanner = new PluginScanner(ClassPluginDocumentationTest.class.getClassLoader());
        RegisteredPlugin scan = pluginScanner.scan();
        Class returnTask = (Class)scan.findClass(Return.class.getName()).orElseThrow();
        PluginClassAndMetadata metadata = PluginClassAndMetadata.create((RegisteredPlugin)scan, (Class)returnTask, Task.class, null);
        ClassPluginDocumentation doc = ClassPluginDocumentation.of((JsonSchemaGenerator)this.jsonSchemaGenerator, (PluginClassAndMetadata)metadata, (String)scan.version(), (boolean)false);
        String render = DocumentationGenerator.render((ClassPluginDocumentation)doc);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"Return a value for debugging purposes."});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"This task is mostly useful for troubleshooting."});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"## Metrics"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"### `length`\n* **Type:** ==counter== "});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"### `duration`\n* **Type:** ==timer== "});
    }

    @Test
    void defaultBool() throws IOException {
        PluginScanner pluginScanner = new PluginScanner(ClassPluginDocumentationTest.class.getClassLoader());
        RegisteredPlugin scan = pluginScanner.scan();
        Class bash = (Class)scan.findClass(Subflow.class.getName()).orElseThrow();
        PluginClassAndMetadata metadata = PluginClassAndMetadata.create((RegisteredPlugin)scan, (Class)bash, Task.class, null);
        ClassPluginDocumentation doc = ClassPluginDocumentation.of((JsonSchemaGenerator)this.jsonSchemaGenerator, (PluginClassAndMetadata)metadata, (String)scan.version(), (boolean)false);
        String render = DocumentationGenerator.render((ClassPluginDocumentation)doc);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"* **Default:** `false`"});
    }

    @Test
    void echo() throws IOException {
        PluginScanner pluginScanner = new PluginScanner(ClassPluginDocumentationTest.class.getClassLoader());
        RegisteredPlugin scan = pluginScanner.scan();
        Class bash = (Class)scan.findClass(Echo.class.getName()).orElseThrow();
        PluginClassAndMetadata metadata = PluginClassAndMetadata.create((RegisteredPlugin)scan, (Class)bash, Task.class, null);
        ClassPluginDocumentation doc = ClassPluginDocumentation.of((JsonSchemaGenerator)this.jsonSchemaGenerator, (PluginClassAndMetadata)metadata, (String)scan.version(), (boolean)false);
        String render = DocumentationGenerator.render((ClassPluginDocumentation)doc);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"Echo"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"This feature is deprecated and will be removed in the future"});
    }

    @Test
    void state() throws IOException {
        PluginScanner pluginScanner = new PluginScanner(ClassPluginDocumentationTest.class.getClassLoader());
        RegisteredPlugin scan = pluginScanner.scan();
        Class set = (Class)scan.findClass(Set.class.getName()).orElseThrow();
        PluginClassAndMetadata metadata = PluginClassAndMetadata.create((RegisteredPlugin)scan, (Class)set, Task.class, null);
        ClassPluginDocumentation doc = ClassPluginDocumentation.of((JsonSchemaGenerator)this.jsonSchemaGenerator, (PluginClassAndMetadata)metadata, (String)scan.version(), (boolean)false);
        String render = DocumentationGenerator.render((ClassPluginDocumentation)doc);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"Set"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"::alert{type=\"warning\"}\n"});
    }

    @Test
    void pluginDoc() throws Exception {
        PluginScanner pluginScanner = new PluginScanner(ClassPluginDocumentationTest.class.getClassLoader());
        RegisteredPlugin core = pluginScanner.scan();
        List docs = this.documentationGenerator.generate(core);
        Document doc = (Document)docs.getFirst();
        Assertions.assertThat((String)doc.getIcon()).isNotNull();
        Assertions.assertThat((String)doc.getBody()).contains(new CharSequence[]{"## <img width=\"25\" src=\"data:image/svg+xml;base64,"});
    }

    @Test
    void pluginEeDoc() throws Exception {
        Path plugins = Paths.get(Objects.requireNonNull(ClassPluginDocumentationTest.class.getClassLoader().getResource("plugins")).toURI());
        PluginScanner pluginScanner = new PluginScanner(ClassPluginDocumentationTest.class.getClassLoader());
        List list = pluginScanner.scan(plugins);
        List docs = this.documentationGenerator.generate(list.stream().filter(r -> r.license() != null).findFirst().orElseThrow());
        Document doc = (Document)docs.getFirst();
        Assertions.assertThat((String)doc.getBody()).contains(new CharSequence[]{"This plugin is exclusively available on the Cloud and Enterprise editions of Kestra."});
    }

    @Test
    void taskRunner() throws IOException {
        PluginScanner pluginScanner = new PluginScanner(ClassPluginDocumentationTest.class.getClassLoader());
        RegisteredPlugin scan = pluginScanner.scan();
        Class processTaskRunner = (Class)scan.findClass(Process.class.getName()).orElseThrow();
        PluginClassAndMetadata metadata = PluginClassAndMetadata.create((RegisteredPlugin)scan, (Class)processTaskRunner, Process.class, null);
        ClassPluginDocumentation doc = ClassPluginDocumentation.of((JsonSchemaGenerator)this.jsonSchemaGenerator, (PluginClassAndMetadata)metadata, (String)scan.version(), (boolean)false);
        String render = DocumentationGenerator.render((ClassPluginDocumentation)doc);
        Assertions.assertThat((String)render).contains(new CharSequence[]{"title: Process"});
        Assertions.assertThat((String)render).contains(new CharSequence[]{"Task runner that executes a task as a subprocess on the Kestra host."});
    }
}

