/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import io.kestra.core.Helpers;
import io.kestra.core.docs.JsonSchemaGenerator;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.dashboards.Dashboard;
import io.kestra.core.models.dashboards.GraphStyle;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.models.tasks.logs.LogExporter;
import io.kestra.core.models.tasks.logs.LogRecord;
import io.kestra.core.models.tasks.retrys.Constant;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.plugins.PluginRegistry;
import io.kestra.core.plugins.RegisteredPlugin;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.core.dashboard.data.IExecutions;
import io.kestra.plugin.core.debug.Echo;
import io.kestra.plugin.core.debug.Return;
import io.kestra.plugin.core.flow.Dag;
import io.kestra.plugin.core.log.Log;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;

@KestraTest
class JsonSchemaGeneratorTest {
    @Inject
    JsonSchemaGenerator jsonSchemaGenerator;
    @Inject
    PluginRegistry pluginRegistry;

    JsonSchemaGeneratorTest() {
    }

    @BeforeAll
    public static void beforeAll() {
        Helpers.loadExternalPluginsFromClasspath();
    }

    @Test
    void tasks() {
        List scan = this.pluginRegistry.externalPlugins();
        Class cls = (Class)((RegisteredPlugin)scan.getFirst()).getTasks().getFirst();
        Map generate = this.jsonSchemaGenerator.properties(Task.class, cls);
        MatcherAssert.assertThat((Object)((Map)generate.get("properties")).size(), (Matcher)Matchers.is((Object)6));
        Map<String, Object> format = this.properties(generate).get("format");
        MatcherAssert.assertThat((Object)format.get("default"), (Matcher)Matchers.is((Object)"{}"));
        generate = this.jsonSchemaGenerator.outputs(Task.class, cls);
        MatcherAssert.assertThat((Object)((Map)generate.get("properties")).size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    void flow() throws URISyntaxException {
        Helpers.runApplicationContext(applicationContext -> {
            JsonSchemaGenerator jsonSchemaGenerator = (JsonSchemaGenerator)applicationContext.getBean(JsonSchemaGenerator.class);
            Map generate = jsonSchemaGenerator.schemas(Flow.class);
            Map definitions = (Map)generate.get("definitions");
            Map flow = (Map)definitions.get(Flow.class.getName());
            MatcherAssert.assertThat((Object)((List)flow.get("required")), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{"deleted"})));
            MatcherAssert.assertThat((Object)((List)flow.get("required")), (Matcher)Matchers.hasItems((Object[])new String[]{"id", "namespace", "tasks"}));
            Map<String, Object> items = this.map(this.properties(flow).get("tasks").get("items"));
            MatcherAssert.assertThat((Object)items.containsKey("anyOf"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)items.containsKey("oneOf"), (Matcher)Matchers.is((Object)false));
            Map log = (Map)definitions.get(Log.class.getName());
            MatcherAssert.assertThat((Object)((List)log.get("required")), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{"level"})));
            MatcherAssert.assertThat((Object)((String)((Map)((Map)log.get("properties")).get("level")).get("markdownDescription")), (Matcher)Matchers.containsString((String)"Default value is : `INFO`"));
            MatcherAssert.assertThat((Object)((String)((Map)((Map)log.get("properties")).get("message")).get("markdownDescription")).contains("can be a string"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((Map)((Map)log.get("properties")).get("type")).containsKey("pattern"), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat(((Map)((Map)log.get("properties")).get("description")).get("$group"), (Matcher)Matchers.is((Object)"core"));
            MatcherAssert.assertThat((Object)((Map)((Map)log.get("properties")).get("level")).containsKey("$group"), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)((String)log.get("markdownDescription")), (Matcher)Matchers.containsString((String)"##### Examples"));
            MatcherAssert.assertThat((Object)((String)log.get("markdownDescription")), (Matcher)Matchers.containsString((String)"level: DEBUG"));
            Map logType = (Map)definitions.get(Log.class.getName());
            MatcherAssert.assertThat((Object)logType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Map requiredWithDefault = (Map)definitions.get("io.kestra.core.docs.JsonSchemaGeneratorTest-RequiredWithDefault");
            MatcherAssert.assertThat((Object)requiredWithDefault, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)((List)requiredWithDefault.get("required")), (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"requiredWithDefault", "anotherRequiredWithDefault"})));
            Map properties = (Map)flow.get("properties");
            Map listeners = (Map)properties.get("listeners");
            MatcherAssert.assertThat(listeners.get("$deprecated"), (Matcher)Matchers.is((Object)true));
        });
    }

    @Test
    void task() throws URISyntaxException {
        Helpers.runApplicationContext(applicationContext -> {
            JsonSchemaGenerator jsonSchemaGenerator = (JsonSchemaGenerator)applicationContext.getBean(JsonSchemaGenerator.class);
            Map generate = jsonSchemaGenerator.schemas(Task.class);
            Map definitions = (Map)generate.get("definitions");
            Map task = (Map)definitions.get(Task.class.getName());
            Assertions.assertNotNull(task.get("anyOf"));
        });
    }

    @Test
    void taskRunner() throws URISyntaxException {
        Helpers.runApplicationContext(applicationContext -> {
            JsonSchemaGenerator jsonSchemaGenerator = (JsonSchemaGenerator)applicationContext.getBean(JsonSchemaGenerator.class);
            Map generate = jsonSchemaGenerator.schemas(TaskRunner.class);
            Map definitions = (Map)generate.get("definitions");
            Map taskRunner = (Map)definitions.get(TaskRunner.class.getName());
            Assertions.assertNotNull(taskRunner.get("$ref"));
        });
    }

    @Test
    void logShipper() throws URISyntaxException {
        Helpers.runApplicationContext(applicationContext -> {
            JsonSchemaGenerator jsonSchemaGenerator = (JsonSchemaGenerator)applicationContext.getBean(JsonSchemaGenerator.class);
            Map generate = jsonSchemaGenerator.schemas(LogExporter.class);
            Map definitions = (Map)generate.get("definitions");
            Map logShipper = (Map)definitions.get(LogExporter.class.getName());
            Assertions.assertNotNull(logShipper.get("$ref"));
        });
    }

    @Test
    void trigger() throws URISyntaxException {
        Helpers.runApplicationContext(applicationContext -> {
            JsonSchemaGenerator jsonSchemaGenerator = (JsonSchemaGenerator)applicationContext.getBean(JsonSchemaGenerator.class);
            Map jsonSchema = jsonSchemaGenerator.generate(AbstractTrigger.class, AbstractTrigger.class);
            MatcherAssert.assertThat((Object)((Map)jsonSchema.get("properties")), (Matcher)Matchers.allOf((Matcher)Matchers.aMapWithSize((int)3), (Matcher)Matchers.hasKey((Object)"conditions"), (Matcher)Matchers.hasKey((Object)"stopAfter"), (Matcher)Matchers.hasKey((Object)"type")));
        });
    }

    @Test
    void dag() throws URISyntaxException {
        Helpers.runApplicationContext(applicationContext -> {
            JsonSchemaGenerator jsonSchemaGenerator = (JsonSchemaGenerator)applicationContext.getBean(JsonSchemaGenerator.class);
            Map generate = jsonSchemaGenerator.schemas(Dag.class);
            Map definitions = (Map)generate.get("definitions");
            Map dag = (Map)definitions.get(Dag.class.getName());
            MatcherAssert.assertThat((Object)((List)dag.get("required")), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{"errors"})));
        });
    }

    @Test
    void returnTask() throws URISyntaxException {
        Helpers.runApplicationContext(applicationContext -> {
            JsonSchemaGenerator jsonSchemaGenerator = (JsonSchemaGenerator)applicationContext.getBean(JsonSchemaGenerator.class);
            Map returnSchema = jsonSchemaGenerator.schemas(Return.class);
            Map definitions = (Map)returnSchema.get("definitions");
            Map returnTask = (Map)definitions.get(Return.class.getName());
            List metrics = (List)returnTask.get("$metrics");
            MatcherAssert.assertThat((Object)metrics.size(), (Matcher)Matchers.is((Object)2));
            Map firstMetric = (Map)metrics.getFirst();
            MatcherAssert.assertThat(firstMetric.get("name"), (Matcher)Matchers.is((Object)"length"));
            MatcherAssert.assertThat(firstMetric.get("type"), (Matcher)Matchers.is((Object)"counter"));
            Map secondMetric = (Map)metrics.get(1);
            MatcherAssert.assertThat(secondMetric.get("name"), (Matcher)Matchers.is((Object)"duration"));
            MatcherAssert.assertThat(secondMetric.get("type"), (Matcher)Matchers.is((Object)"timer"));
        });
    }

    @Test
    void echoTask() throws URISyntaxException {
        Helpers.runApplicationContext(applicationContext -> {
            JsonSchemaGenerator jsonSchemaGenerator = (JsonSchemaGenerator)applicationContext.getBean(JsonSchemaGenerator.class);
            Map returnSchema = jsonSchemaGenerator.schemas(Echo.class);
            Map definitions = (Map)returnSchema.get("definitions");
            Map returnTask = (Map)definitions.get(Echo.class.getName());
            String deprecated = (String)returnTask.get("$deprecated");
            MatcherAssert.assertThat((Object)deprecated, (Matcher)Matchers.is((Object)"true"));
        });
    }

    @Test
    void testEnum() {
        Map generate = this.jsonSchemaGenerator.properties(Task.class, TaskWithEnum.class);
        MatcherAssert.assertThat((Object)generate, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)((Map)generate.get("properties")).size(), (Matcher)Matchers.is((Object)6));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("stringWithDefault")).get("default"), (Matcher)Matchers.is((Object)"default"));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("uri")).get("$internalStorageURI"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void betaTask() {
        Map generate = this.jsonSchemaGenerator.properties(Task.class, BetaTask.class);
        MatcherAssert.assertThat((Object)generate, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat(generate.get("$beta"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((Map)generate.get("properties")).size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("beta")).get("$beta"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void requiredAreRemovedIfThereIsADefault() {
        Map generate = this.jsonSchemaGenerator.properties(Task.class, RequiredWithDefault.class);
        MatcherAssert.assertThat((Object)generate, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)((List)generate.get("required")), (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"requiredWithDefault", "anotherRequiredWithDefault"})));
        MatcherAssert.assertThat((Object)((List)generate.get("required")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"requiredWithNoDefault"}));
    }

    @Test
    void testDocumentation() {
        Map generate = this.jsonSchemaGenerator.properties(Task.class, TaskWithDynamicDocumentedFields.class);
        MatcherAssert.assertThat((Object)generate, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("stringProperty")).get("title"), (Matcher)Matchers.is((Object)"stringProperty title"));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("stringProperty")).get("description"), (Matcher)Matchers.is((Object)"stringProperty description"));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("stringProperty")).get("$deprecated"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("integerProperty")).get("title"), (Matcher)Matchers.is((Object)"integerProperty title"));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("integerProperty")).get("description"), (Matcher)Matchers.is((Object)"integerProperty description"));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("integerProperty")).get("$deprecated"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("stringPropertyWithDefault")).get("title"), (Matcher)Matchers.is((Object)"stringPropertyWithDefault title"));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("stringPropertyWithDefault")).get("description"), (Matcher)Matchers.is((Object)"stringPropertyWithDefault description"));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("stringPropertyWithDefault")).get("$deprecated"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("stringPropertyWithDefault")).get("default"), (Matcher)Matchers.is((Object)"my string"));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("integerPropertyWithDefault")).get("title"), (Matcher)Matchers.is((Object)"integerPropertyWithDefault title"));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("integerPropertyWithDefault")).get("description"), (Matcher)Matchers.is((Object)"integerPropertyWithDefault description"));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("integerPropertyWithDefault")).get("$deprecated"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(((Map)((Map)generate.get("properties")).get("integerPropertyWithDefault")).get("default"), (Matcher)Matchers.is((Object)"10000"));
    }

    @Test
    void dashboard() throws URISyntaxException {
        Helpers.runApplicationContext(applicationContext -> {
            Map generate = this.jsonSchemaGenerator.schemas(Dashboard.class);
            Map definitions = (Map)generate.get("definitions");
            String executionTimeSeriesColumnDescriptorExecutionFieldsKey = "io.kestra.plugin.core.dashboard.data.Executions_io.kestra.plugin.core.dashboard.chart.timeseries.TimeSeriesColumnDescriptor_io.kestra.plugin.core.dashboard.data.IExecutions-Fields__";
            MatcherAssert.assertThat((Object)this.properties((Map)definitions.get("io.kestra.plugin.core.dashboard.chart.TimeSeries_io.kestra.plugin.core.dashboard.data.IExecutions-Fields.io.kestra.plugin.core.dashboard.data.Executions_io.kestra.plugin.core.dashboard.chart.timeseries.TimeSeriesColumnDescriptor_io.kestra.plugin.core.dashboard.data.IExecutions-Fields___")).get("data").get("$ref"), (Matcher)Matchers.is((Object)("#/definitions/" + executionTimeSeriesColumnDescriptorExecutionFieldsKey)));
            String timeseriesColumnDescriptorExecutionFields = "io.kestra.plugin.core.dashboard.chart.timeseries.TimeSeriesColumnDescriptor_io.kestra.plugin.core.dashboard.data.IExecutions-Fields_";
            MatcherAssert.assertThat((Object)((String)((Map)this.properties((Map)definitions.get("io.kestra.plugin.core.dashboard.data.Executions_io.kestra.plugin.core.dashboard.chart.timeseries.TimeSeriesColumnDescriptor_io.kestra.plugin.core.dashboard.data.IExecutions-Fields__")).get("columns").get("additionalProperties")).get("$ref")), (Matcher)Matchers.is((Object)("#/definitions/" + timeseriesColumnDescriptorExecutionFields)));
            Map<String, Map<String, Object>> executionTimeseriesProps = this.properties((Map)definitions.get(timeseriesColumnDescriptorExecutionFields));
            MatcherAssert.assertThat((Object)((List)executionTimeseriesProps.get("graphStyle").get("enum")).toArray(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])Arrays.stream(GraphStyle.values()).map(Object::toString).toArray()));
            MatcherAssert.assertThat((Object)((List)executionTimeseriesProps.get("field").get("enum")).toArray(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])Arrays.stream(IExecutions.Fields.values()).map(Object::toString).toArray()));
        });
    }

    @Test
    void subtypesTypePropertyAsConst() {
        List scan = this.pluginRegistry.externalPlugins();
        Class cls = (Class)((RegisteredPlugin)scan.getFirst()).getTasks().getFirst();
        Map generate = this.jsonSchemaGenerator.properties(null, cls);
        MatcherAssert.assertThat(((Map)((Map)((Map)((Map)generate.get("$defs")).get("io.kestra.core.models.tasks.retrys.Constant")).get("properties")).get("type")).get("const"), (Matcher)Matchers.is((Object)new Constant().getType()));
    }

    @Test
    void pluginSchemaShouldNotResolveTaskAndTriggerSubtypes() {
        Map generate = this.jsonSchemaGenerator.properties(null, TaskWithSubTaskAndSubTrigger.class);
        Map definitions = (Map)generate.get("$defs");
        MatcherAssert.assertThat((Object)definitions.size(), (Matcher)Matchers.is((Object)27));
    }

    private Map<String, Map<String, Object>> properties(Map<String, Object> generate) {
        return (Map)generate.get("properties");
    }

    private Map<String, Object> map(Object object) {
        return (Map)object;
    }

    public static class TaskWithEnum
    extends ParentClass
    implements RunnableTask<VoidOutput> {
        @PluginProperty
        @Schema(title="Title from the attribute")
        private TestEnum testEnum;
        @PluginProperty
        @Schema(title="Title from the attribute", description="Description from the attribute")
        private TestClass testClass;
        @PluginProperty(internalStorageURI=true)
        @Schema(title="Title from the attribute", description="Description from the attribute")
        private String uri;
        @PluginProperty
        @Schema(title="Title from the attribute", oneOf={String.class, Example[].class, Example.class})
        private Object testObject;

        public VoidOutput run(RunContext runContext) throws Exception {
            return null;
        }

        @Generated
        protected TaskWithEnum(TaskWithEnumBuilder<?, ?> b) {
            super(b);
            this.testEnum = b.testEnum;
            this.testClass = b.testClass;
            this.uri = b.uri;
            this.testObject = b.testObject;
        }

        @Generated
        public static TaskWithEnumBuilder<?, ?> builder() {
            return new TaskWithEnumBuilderImpl();
        }

        @Override
        @Generated
        public String toString() {
            return "JsonSchemaGeneratorTest.TaskWithEnum(super=" + super.toString() + ", testEnum=" + String.valueOf((Object)this.getTestEnum()) + ", testClass=" + String.valueOf(this.getTestClass()) + ", uri=" + this.getUri() + ", testObject=" + String.valueOf(this.getTestObject()) + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskWithEnum)) {
                return false;
            }
            TaskWithEnum other = (TaskWithEnum)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TestEnum this$testEnum = this.getTestEnum();
            TestEnum other$testEnum = other.getTestEnum();
            if (this$testEnum == null ? other$testEnum != null : !((Object)((Object)this$testEnum)).equals((Object)other$testEnum)) {
                return false;
            }
            TestClass this$testClass = this.getTestClass();
            TestClass other$testClass = other.getTestClass();
            if (this$testClass == null ? other$testClass != null : !this$testClass.equals(other$testClass)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            Object this$testObject = this.getTestObject();
            Object other$testObject = other.getTestObject();
            return !(this$testObject == null ? other$testObject != null : !this$testObject.equals(other$testObject));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaskWithEnum;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            TestEnum $testEnum = this.getTestEnum();
            result = result * 59 + ($testEnum == null ? 43 : ((Object)((Object)$testEnum)).hashCode());
            TestClass $testClass = this.getTestClass();
            result = result * 59 + ($testClass == null ? 43 : $testClass.hashCode());
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            Object $testObject = this.getTestObject();
            result = result * 59 + ($testObject == null ? 43 : $testObject.hashCode());
            return result;
        }

        @Generated
        public TestEnum getTestEnum() {
            return this.testEnum;
        }

        @Generated
        public TestClass getTestClass() {
            return this.testClass;
        }

        @Generated
        public String getUri() {
            return this.uri;
        }

        @Generated
        public Object getTestObject() {
            return this.testObject;
        }

        @Generated
        public TaskWithEnum() {
        }

        @Generated
        public static abstract class TaskWithEnumBuilder<C extends TaskWithEnum, B extends TaskWithEnumBuilder<C, B>>
        extends ParentClass.ParentClassBuilder<C, B> {
            @Generated
            private TestEnum testEnum;
            @Generated
            private TestClass testClass;
            @Generated
            private String uri;
            @Generated
            private Object testObject;

            @Generated
            public B testEnum(TestEnum testEnum) {
                this.testEnum = testEnum;
                return (B)((Object)this.self());
            }

            @Generated
            public B testClass(TestClass testClass) {
                this.testClass = testClass;
                return (B)((Object)this.self());
            }

            @Generated
            public B uri(String uri) {
                this.uri = uri;
                return (B)((Object)this.self());
            }

            @Generated
            public B testObject(Object testObject) {
                this.testObject = testObject;
                return (B)((Object)this.self());
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "JsonSchemaGeneratorTest.TaskWithEnum.TaskWithEnumBuilder(super=" + super.toString() + ", testEnum=" + String.valueOf((Object)this.testEnum) + ", testClass=" + String.valueOf(this.testClass) + ", uri=" + this.uri + ", testObject=" + String.valueOf(this.testObject) + ")";
            }
        }

        @Schema(title="Title from the enum")
        private static enum TestEnum {
            VALUE1,
            VALUE2,
            VALUE3;

        }

        @Schema(title="Test class")
        private static class TestClass {
            @Schema(title="Test property")
            public String testProperty;

            @ConstructorProperties(value={"testProperty"})
            @Generated
            TestClass(String testProperty) {
                this.testProperty = testProperty;
            }

            @Generated
            public static TestClassBuilder builder() {
                return new TestClassBuilder();
            }

            @Generated
            public static class TestClassBuilder {
                @Generated
                private String testProperty;

                @Generated
                TestClassBuilder() {
                }

                @Generated
                public TestClassBuilder testProperty(String testProperty) {
                    this.testProperty = testProperty;
                    return this;
                }

                @Generated
                public TestClass build() {
                    return new TestClass(this.testProperty);
                }

                @Generated
                public String toString() {
                    return "JsonSchemaGeneratorTest.TaskWithEnum.TestClass.TestClassBuilder(testProperty=" + this.testProperty + ")";
                }
            }
        }

        @Generated
        private static final class TaskWithEnumBuilderImpl
        extends TaskWithEnumBuilder<TaskWithEnum, TaskWithEnumBuilderImpl> {
            @Generated
            private TaskWithEnumBuilderImpl() {
            }

            @Override
            @Generated
            protected TaskWithEnumBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public TaskWithEnum build() {
                return new TaskWithEnum(this);
            }
        }
    }

    @Plugin(beta=true)
    public static class BetaTask
    extends Task {
        @PluginProperty(beta=true)
        private String beta;

        @Generated
        protected BetaTask(BetaTaskBuilder<?, ?> b) {
            super(b);
            this.beta = b.beta;
        }

        @Generated
        public static BetaTaskBuilder<?, ?> builder() {
            return new BetaTaskBuilderImpl();
        }

        @Generated
        public String toString() {
            return "JsonSchemaGeneratorTest.BetaTask(super=" + super.toString() + ", beta=" + this.getBeta() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BetaTask)) {
                return false;
            }
            BetaTask other = (BetaTask)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$beta = this.getBeta();
            String other$beta = other.getBeta();
            return !(this$beta == null ? other$beta != null : !this$beta.equals(other$beta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BetaTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $beta = this.getBeta();
            result = result * 59 + ($beta == null ? 43 : $beta.hashCode());
            return result;
        }

        @Generated
        public String getBeta() {
            return this.beta;
        }

        @Generated
        public BetaTask() {
        }

        @Generated
        public static abstract class BetaTaskBuilder<C extends BetaTask, B extends BetaTaskBuilder<C, B>>
        extends Task.TaskBuilder<C, B> {
            @Generated
            private String beta;

            @Generated
            public B beta(String beta) {
                this.beta = beta;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "JsonSchemaGeneratorTest.BetaTask.BetaTaskBuilder(super=" + super.toString() + ", beta=" + this.beta + ")";
            }
        }

        @Generated
        private static final class BetaTaskBuilderImpl
        extends BetaTaskBuilder<BetaTask, BetaTaskBuilderImpl> {
            @Generated
            private BetaTaskBuilderImpl() {
            }

            @Override
            @Generated
            protected BetaTaskBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public BetaTask build() {
                return new BetaTask(this);
            }
        }
    }

    @Plugin
    public static class RequiredWithDefault
    extends Task {
        @PluginProperty
        @NotNull
        private Property<TaskWithEnum.TestClass> requiredWithDefault;
        @PluginProperty
        @NotNull
        private Property<TaskWithEnum.TestClass> anotherRequiredWithDefault;
        @PluginProperty
        @NotNull
        private Property<TaskWithEnum.TestClass> requiredWithNoDefault;

        @Generated
        private static Property<TaskWithEnum.TestClass> $default$requiredWithDefault() {
            return Property.ofValue((Object)TaskWithEnum.TestClass.builder().testProperty("test").build());
        }

        @Generated
        private static Property<TaskWithEnum.TestClass> $default$anotherRequiredWithDefault() {
            return Property.ofValue((Object)TaskWithEnum.TestClass.builder().testProperty("test2").build());
        }

        @Generated
        protected RequiredWithDefault(RequiredWithDefaultBuilder<?, ?> b) {
            super(b);
            this.requiredWithDefault = b.requiredWithDefault$set ? b.requiredWithDefault$value : RequiredWithDefault.$default$requiredWithDefault();
            this.anotherRequiredWithDefault = b.anotherRequiredWithDefault$set ? b.anotherRequiredWithDefault$value : RequiredWithDefault.$default$anotherRequiredWithDefault();
            this.requiredWithNoDefault = b.requiredWithNoDefault;
        }

        @Generated
        public static RequiredWithDefaultBuilder<?, ?> builder() {
            return new RequiredWithDefaultBuilderImpl();
        }

        @Generated
        public String toString() {
            return "JsonSchemaGeneratorTest.RequiredWithDefault(super=" + super.toString() + ", requiredWithDefault=" + String.valueOf(this.getRequiredWithDefault()) + ", anotherRequiredWithDefault=" + String.valueOf(this.getAnotherRequiredWithDefault()) + ", requiredWithNoDefault=" + String.valueOf(this.getRequiredWithNoDefault()) + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequiredWithDefault)) {
                return false;
            }
            RequiredWithDefault other = (RequiredWithDefault)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Property<TaskWithEnum.TestClass> this$requiredWithDefault = this.getRequiredWithDefault();
            Property<TaskWithEnum.TestClass> other$requiredWithDefault = other.getRequiredWithDefault();
            if (this$requiredWithDefault == null ? other$requiredWithDefault != null : !this$requiredWithDefault.equals(other$requiredWithDefault)) {
                return false;
            }
            Property<TaskWithEnum.TestClass> this$anotherRequiredWithDefault = this.getAnotherRequiredWithDefault();
            Property<TaskWithEnum.TestClass> other$anotherRequiredWithDefault = other.getAnotherRequiredWithDefault();
            if (this$anotherRequiredWithDefault == null ? other$anotherRequiredWithDefault != null : !this$anotherRequiredWithDefault.equals(other$anotherRequiredWithDefault)) {
                return false;
            }
            Property<TaskWithEnum.TestClass> this$requiredWithNoDefault = this.getRequiredWithNoDefault();
            Property<TaskWithEnum.TestClass> other$requiredWithNoDefault = other.getRequiredWithNoDefault();
            return !(this$requiredWithNoDefault == null ? other$requiredWithNoDefault != null : !this$requiredWithNoDefault.equals(other$requiredWithNoDefault));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RequiredWithDefault;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Property<TaskWithEnum.TestClass> $requiredWithDefault = this.getRequiredWithDefault();
            result = result * 59 + ($requiredWithDefault == null ? 43 : $requiredWithDefault.hashCode());
            Property<TaskWithEnum.TestClass> $anotherRequiredWithDefault = this.getAnotherRequiredWithDefault();
            result = result * 59 + ($anotherRequiredWithDefault == null ? 43 : $anotherRequiredWithDefault.hashCode());
            Property<TaskWithEnum.TestClass> $requiredWithNoDefault = this.getRequiredWithNoDefault();
            result = result * 59 + ($requiredWithNoDefault == null ? 43 : $requiredWithNoDefault.hashCode());
            return result;
        }

        @Generated
        public Property<TaskWithEnum.TestClass> getRequiredWithDefault() {
            return this.requiredWithDefault;
        }

        @Generated
        public Property<TaskWithEnum.TestClass> getAnotherRequiredWithDefault() {
            return this.anotherRequiredWithDefault;
        }

        @Generated
        public Property<TaskWithEnum.TestClass> getRequiredWithNoDefault() {
            return this.requiredWithNoDefault;
        }

        @Generated
        public RequiredWithDefault() {
            this.requiredWithDefault = RequiredWithDefault.$default$requiredWithDefault();
            this.anotherRequiredWithDefault = RequiredWithDefault.$default$anotherRequiredWithDefault();
        }

        @Generated
        public static abstract class RequiredWithDefaultBuilder<C extends RequiredWithDefault, B extends RequiredWithDefaultBuilder<C, B>>
        extends Task.TaskBuilder<C, B> {
            @Generated
            private boolean requiredWithDefault$set;
            @Generated
            private Property<TaskWithEnum.TestClass> requiredWithDefault$value;
            @Generated
            private boolean anotherRequiredWithDefault$set;
            @Generated
            private Property<TaskWithEnum.TestClass> anotherRequiredWithDefault$value;
            @Generated
            private Property<TaskWithEnum.TestClass> requiredWithNoDefault;

            @Generated
            public B requiredWithDefault(Property<TaskWithEnum.TestClass> requiredWithDefault) {
                this.requiredWithDefault$value = requiredWithDefault;
                this.requiredWithDefault$set = true;
                return (B)this.self();
            }

            @Generated
            public B anotherRequiredWithDefault(Property<TaskWithEnum.TestClass> anotherRequiredWithDefault) {
                this.anotherRequiredWithDefault$value = anotherRequiredWithDefault;
                this.anotherRequiredWithDefault$set = true;
                return (B)this.self();
            }

            @Generated
            public B requiredWithNoDefault(Property<TaskWithEnum.TestClass> requiredWithNoDefault) {
                this.requiredWithNoDefault = requiredWithNoDefault;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "JsonSchemaGeneratorTest.RequiredWithDefault.RequiredWithDefaultBuilder(super=" + super.toString() + ", requiredWithDefault$value=" + String.valueOf(this.requiredWithDefault$value) + ", anotherRequiredWithDefault$value=" + String.valueOf(this.anotherRequiredWithDefault$value) + ", requiredWithNoDefault=" + String.valueOf(this.requiredWithNoDefault) + ")";
            }
        }

        @Generated
        private static final class RequiredWithDefaultBuilderImpl
        extends RequiredWithDefaultBuilder<RequiredWithDefault, RequiredWithDefaultBuilderImpl> {
            @Generated
            private RequiredWithDefaultBuilderImpl() {
            }

            @Override
            @Generated
            protected RequiredWithDefaultBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public RequiredWithDefault build() {
                return new RequiredWithDefault(this);
            }
        }
    }

    public static class TaskWithDynamicDocumentedFields
    extends Task
    implements RunnableTask<VoidOutput> {
        @Deprecated(since="deprecation_version_1", forRemoval=true)
        @Schema(title="integerPropertyWithDefault title", description="integerPropertyWithDefault description")
        protected Property<Integer> integerPropertyWithDefault;
        @Deprecated(since="deprecation_version_1", forRemoval=true)
        @Schema(title="stringPropertyWithDefault title", description="stringPropertyWithDefault description")
        protected Property<String> stringPropertyWithDefault;
        @Deprecated(since="deprecation_version_1", forRemoval=true)
        @Schema(title="stringProperty title", description="stringProperty description")
        protected Property<String> stringProperty;
        @Deprecated(since="deprecation_version_1", forRemoval=true)
        @Schema(title="integerProperty title", description="integerProperty description")
        protected Property<Integer> integerProperty;

        public VoidOutput run(RunContext runContext) throws Exception {
            return null;
        }

        @Generated
        private static Property<Integer> $default$integerPropertyWithDefault() {
            return Property.ofValue((Object)10000);
        }

        @Generated
        private static Property<String> $default$stringPropertyWithDefault() {
            return Property.ofValue((Object)"my string");
        }

        @Generated
        protected TaskWithDynamicDocumentedFields(TaskWithDynamicDocumentedFieldsBuilder<?, ?> b) {
            super(b);
            this.integerPropertyWithDefault = b.integerPropertyWithDefault$set ? b.integerPropertyWithDefault$value : TaskWithDynamicDocumentedFields.$default$integerPropertyWithDefault();
            this.stringPropertyWithDefault = b.stringPropertyWithDefault$set ? b.stringPropertyWithDefault$value : TaskWithDynamicDocumentedFields.$default$stringPropertyWithDefault();
            this.stringProperty = b.stringProperty;
            this.integerProperty = b.integerProperty;
        }

        @Generated
        public static TaskWithDynamicDocumentedFieldsBuilder<?, ?> builder() {
            return new TaskWithDynamicDocumentedFieldsBuilderImpl();
        }

        @Generated
        public String toString() {
            return "JsonSchemaGeneratorTest.TaskWithDynamicDocumentedFields(super=" + super.toString() + ", integerPropertyWithDefault=" + String.valueOf(this.getIntegerPropertyWithDefault()) + ", stringPropertyWithDefault=" + String.valueOf(this.getStringPropertyWithDefault()) + ", stringProperty=" + String.valueOf(this.getStringProperty()) + ", integerProperty=" + String.valueOf(this.getIntegerProperty()) + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskWithDynamicDocumentedFields)) {
                return false;
            }
            TaskWithDynamicDocumentedFields other = (TaskWithDynamicDocumentedFields)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Property<Integer> this$integerPropertyWithDefault = this.getIntegerPropertyWithDefault();
            Property<Integer> other$integerPropertyWithDefault = other.getIntegerPropertyWithDefault();
            if (this$integerPropertyWithDefault == null ? other$integerPropertyWithDefault != null : !this$integerPropertyWithDefault.equals(other$integerPropertyWithDefault)) {
                return false;
            }
            Property<String> this$stringPropertyWithDefault = this.getStringPropertyWithDefault();
            Property<String> other$stringPropertyWithDefault = other.getStringPropertyWithDefault();
            if (this$stringPropertyWithDefault == null ? other$stringPropertyWithDefault != null : !this$stringPropertyWithDefault.equals(other$stringPropertyWithDefault)) {
                return false;
            }
            Property<String> this$stringProperty = this.getStringProperty();
            Property<String> other$stringProperty = other.getStringProperty();
            if (this$stringProperty == null ? other$stringProperty != null : !this$stringProperty.equals(other$stringProperty)) {
                return false;
            }
            Property<Integer> this$integerProperty = this.getIntegerProperty();
            Property<Integer> other$integerProperty = other.getIntegerProperty();
            return !(this$integerProperty == null ? other$integerProperty != null : !this$integerProperty.equals(other$integerProperty));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaskWithDynamicDocumentedFields;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Property<Integer> $integerPropertyWithDefault = this.getIntegerPropertyWithDefault();
            result = result * 59 + ($integerPropertyWithDefault == null ? 43 : $integerPropertyWithDefault.hashCode());
            Property<String> $stringPropertyWithDefault = this.getStringPropertyWithDefault();
            result = result * 59 + ($stringPropertyWithDefault == null ? 43 : $stringPropertyWithDefault.hashCode());
            Property<String> $stringProperty = this.getStringProperty();
            result = result * 59 + ($stringProperty == null ? 43 : $stringProperty.hashCode());
            Property<Integer> $integerProperty = this.getIntegerProperty();
            result = result * 59 + ($integerProperty == null ? 43 : $integerProperty.hashCode());
            return result;
        }

        @Deprecated
        @Generated
        public Property<Integer> getIntegerPropertyWithDefault() {
            return this.integerPropertyWithDefault;
        }

        @Deprecated
        @Generated
        public Property<String> getStringPropertyWithDefault() {
            return this.stringPropertyWithDefault;
        }

        @Deprecated
        @Generated
        public Property<String> getStringProperty() {
            return this.stringProperty;
        }

        @Deprecated
        @Generated
        public Property<Integer> getIntegerProperty() {
            return this.integerProperty;
        }

        @Generated
        public TaskWithDynamicDocumentedFields() {
            this.integerPropertyWithDefault = TaskWithDynamicDocumentedFields.$default$integerPropertyWithDefault();
            this.stringPropertyWithDefault = TaskWithDynamicDocumentedFields.$default$stringPropertyWithDefault();
        }

        @Generated
        public static abstract class TaskWithDynamicDocumentedFieldsBuilder<C extends TaskWithDynamicDocumentedFields, B extends TaskWithDynamicDocumentedFieldsBuilder<C, B>>
        extends Task.TaskBuilder<C, B> {
            @Generated
            private boolean integerPropertyWithDefault$set;
            @Generated
            private Property<Integer> integerPropertyWithDefault$value;
            @Generated
            private boolean stringPropertyWithDefault$set;
            @Generated
            private Property<String> stringPropertyWithDefault$value;
            @Generated
            private Property<String> stringProperty;
            @Generated
            private Property<Integer> integerProperty;

            @Deprecated
            @Generated
            public B integerPropertyWithDefault(Property<Integer> integerPropertyWithDefault) {
                this.integerPropertyWithDefault$value = integerPropertyWithDefault;
                this.integerPropertyWithDefault$set = true;
                return (B)this.self();
            }

            @Deprecated
            @Generated
            public B stringPropertyWithDefault(Property<String> stringPropertyWithDefault) {
                this.stringPropertyWithDefault$value = stringPropertyWithDefault;
                this.stringPropertyWithDefault$set = true;
                return (B)this.self();
            }

            @Deprecated
            @Generated
            public B stringProperty(Property<String> stringProperty) {
                this.stringProperty = stringProperty;
                return (B)this.self();
            }

            @Deprecated
            @Generated
            public B integerProperty(Property<Integer> integerProperty) {
                this.integerProperty = integerProperty;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "JsonSchemaGeneratorTest.TaskWithDynamicDocumentedFields.TaskWithDynamicDocumentedFieldsBuilder(super=" + super.toString() + ", integerPropertyWithDefault$value=" + String.valueOf(this.integerPropertyWithDefault$value) + ", stringPropertyWithDefault$value=" + String.valueOf(this.stringPropertyWithDefault$value) + ", stringProperty=" + String.valueOf(this.stringProperty) + ", integerProperty=" + String.valueOf(this.integerProperty) + ")";
            }
        }

        @Generated
        private static final class TaskWithDynamicDocumentedFieldsBuilderImpl
        extends TaskWithDynamicDocumentedFieldsBuilder<TaskWithDynamicDocumentedFields, TaskWithDynamicDocumentedFieldsBuilderImpl> {
            @Generated
            private TaskWithDynamicDocumentedFieldsBuilderImpl() {
            }

            @Override
            @Generated
            protected TaskWithDynamicDocumentedFieldsBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public TaskWithDynamicDocumentedFields build() {
                return new TaskWithDynamicDocumentedFields(this);
            }
        }
    }

    public static class TaskWithSubTaskAndSubTrigger
    extends Task
    implements RunnableTask<VoidOutput> {
        @PluginProperty
        @Schema(title="Subtask")
        private Task subTask;
        @PluginProperty
        @Schema(title="Subtrigger")
        private AbstractTrigger subTrigger;

        public VoidOutput run(RunContext runContext) throws Exception {
            return null;
        }

        @Generated
        protected TaskWithSubTaskAndSubTrigger(TaskWithSubTaskAndSubTriggerBuilder<?, ?> b) {
            super(b);
            this.subTask = b.subTask;
            this.subTrigger = b.subTrigger;
        }

        @Generated
        public static TaskWithSubTaskAndSubTriggerBuilder<?, ?> builder() {
            return new TaskWithSubTaskAndSubTriggerBuilderImpl();
        }

        @Generated
        public String toString() {
            return "JsonSchemaGeneratorTest.TaskWithSubTaskAndSubTrigger(super=" + super.toString() + ", subTask=" + String.valueOf(this.getSubTask()) + ", subTrigger=" + String.valueOf(this.getSubTrigger()) + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskWithSubTaskAndSubTrigger)) {
                return false;
            }
            TaskWithSubTaskAndSubTrigger other = (TaskWithSubTaskAndSubTrigger)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Task this$subTask = this.getSubTask();
            Task other$subTask = other.getSubTask();
            if (this$subTask == null ? other$subTask != null : !this$subTask.equals(other$subTask)) {
                return false;
            }
            AbstractTrigger this$subTrigger = this.getSubTrigger();
            AbstractTrigger other$subTrigger = other.getSubTrigger();
            return !(this$subTrigger == null ? other$subTrigger != null : !this$subTrigger.equals(other$subTrigger));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaskWithSubTaskAndSubTrigger;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Task $subTask = this.getSubTask();
            result = result * 59 + ($subTask == null ? 43 : $subTask.hashCode());
            AbstractTrigger $subTrigger = this.getSubTrigger();
            result = result * 59 + ($subTrigger == null ? 43 : $subTrigger.hashCode());
            return result;
        }

        @Generated
        public Task getSubTask() {
            return this.subTask;
        }

        @Generated
        public AbstractTrigger getSubTrigger() {
            return this.subTrigger;
        }

        @Generated
        public TaskWithSubTaskAndSubTrigger() {
        }

        @Generated
        public static abstract class TaskWithSubTaskAndSubTriggerBuilder<C extends TaskWithSubTaskAndSubTrigger, B extends TaskWithSubTaskAndSubTriggerBuilder<C, B>>
        extends Task.TaskBuilder<C, B> {
            @Generated
            private Task subTask;
            @Generated
            private AbstractTrigger subTrigger;

            @Generated
            public B subTask(Task subTask) {
                this.subTask = subTask;
                return (B)this.self();
            }

            @Generated
            public B subTrigger(AbstractTrigger subTrigger) {
                this.subTrigger = subTrigger;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "JsonSchemaGeneratorTest.TaskWithSubTaskAndSubTrigger.TaskWithSubTaskAndSubTriggerBuilder(super=" + super.toString() + ", subTask=" + String.valueOf(this.subTask) + ", subTrigger=" + String.valueOf(this.subTrigger) + ")";
            }
        }

        @Generated
        private static final class TaskWithSubTaskAndSubTriggerBuilderImpl
        extends TaskWithSubTaskAndSubTriggerBuilder<TaskWithSubTaskAndSubTrigger, TaskWithSubTaskAndSubTriggerBuilderImpl> {
            @Generated
            private TaskWithSubTaskAndSubTriggerBuilderImpl() {
            }

            @Override
            @Generated
            protected TaskWithSubTaskAndSubTriggerBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public TaskWithSubTaskAndSubTrigger build() {
                return new TaskWithSubTaskAndSubTrigger(this);
            }
        }
    }

    public static class TestLogExporter
    extends LogExporter<VoidOutput> {
        public VoidOutput sendLogs(RunContext runContext, Flux<LogRecord> logRecord) throws Exception {
            return null;
        }
    }

    private static abstract class ParentClass
    extends Task {
        private Property<String> stringWithDefault;

        @Generated
        private static Property<String> $default$stringWithDefault() {
            return Property.ofValue((Object)"default");
        }

        @Generated
        protected ParentClass(ParentClassBuilder<?, ?> b) {
            super(b);
            this.stringWithDefault = b.stringWithDefault$set ? b.stringWithDefault$value : ParentClass.$default$stringWithDefault();
        }

        @Generated
        public String toString() {
            return "JsonSchemaGeneratorTest.ParentClass(super=" + super.toString() + ", stringWithDefault=" + String.valueOf(this.getStringWithDefault()) + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParentClass)) {
                return false;
            }
            ParentClass other = (ParentClass)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Property<String> this$stringWithDefault = this.getStringWithDefault();
            Property<String> other$stringWithDefault = other.getStringWithDefault();
            return !(this$stringWithDefault == null ? other$stringWithDefault != null : !this$stringWithDefault.equals(other$stringWithDefault));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParentClass;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Property<String> $stringWithDefault = this.getStringWithDefault();
            result = result * 59 + ($stringWithDefault == null ? 43 : $stringWithDefault.hashCode());
            return result;
        }

        @Generated
        public Property<String> getStringWithDefault() {
            return this.stringWithDefault;
        }

        @Generated
        public ParentClass() {
            this.stringWithDefault = ParentClass.$default$stringWithDefault();
        }

        @Generated
        public static abstract class ParentClassBuilder<C extends ParentClass, B extends ParentClassBuilder<C, B>>
        extends Task.TaskBuilder<C, B> {
            @Generated
            private boolean stringWithDefault$set;
            @Generated
            private Property<String> stringWithDefault$value;

            @Generated
            public B stringWithDefault(Property<String> stringWithDefault) {
                this.stringWithDefault$value = stringWithDefault;
                this.stringWithDefault$set = true;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "JsonSchemaGeneratorTest.ParentClass.ParentClassBuilder(super=" + super.toString() + ", stringWithDefault$value=" + String.valueOf(this.stringWithDefault$value) + ")";
            }
        }
    }
}

