/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.encryption;

import io.kestra.core.encryption.EncryptionService;
import java.security.GeneralSecurityException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class EncryptionServiceTest {
    private static final String KEY = "I6EGNzRESu3X3pKZidrqCGOHQFUFC0yK";

    @Test
    void encryptAndDecryptString() throws GeneralSecurityException {
        String text = "Hello World!";
        String encrypted = EncryptionService.encrypt((String)KEY, (String)text);
        String decrypted = EncryptionService.decrypt((String)KEY, (String)encrypted);
        Assertions.assertThat((String)decrypted).isEqualTo(text);
    }

    @Test
    void encryptAndDecryptByteArray() throws GeneralSecurityException {
        byte[] text = "Hello World!".getBytes();
        byte[] encrypted = EncryptionService.encrypt((String)KEY, (byte[])text);
        byte[] decrypted = EncryptionService.decrypt((String)KEY, (byte[])encrypted);
        Assertions.assertThat((String)new String(decrypted)).isEqualTo("Hello World!");
    }

    @Test
    void avoidNpeForEmptyOrNullText() throws GeneralSecurityException {
        Assertions.assertThat((String)EncryptionService.encrypt((String)KEY, (String)null)).isNull();
        Assertions.assertThat((String)EncryptionService.decrypt((String)KEY, (String)null)).isNull();
        Assertions.assertThat((byte[])EncryptionService.encrypt((String)KEY, (byte[])null)).isNull();
        Assertions.assertThat((byte[])EncryptionService.decrypt((String)KEY, (byte[])null)).isNull();
        Assertions.assertThat((String)EncryptionService.encrypt((String)KEY, (String)"")).isEqualTo("");
        Assertions.assertThat((String)EncryptionService.decrypt((String)KEY, (String)"")).isEqualTo("");
    }
}

