/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.endpoints;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.env.MapPropertySource;
import io.micronaut.context.env.PropertySource;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.reactor.http.client.ReactorHttpClient;
import io.micronaut.runtime.server.EmbeddedServer;
import java.util.Map;
import java.util.function.BiConsumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BasicAuthEndpointsFilterTest {
    BasicAuthEndpointsFilterTest() {
    }

    void test(boolean password, BiConsumer<ReactorHttpClient, MutableHttpRequest<String>> consumer) {
        MapPropertySource mapPropertySource = new MapPropertySource("unittest", password ? Map.of("endpoints.all.enabled", true, "endpoints.all.sensitive", false, "endpoints.all.basic-auth.username", "foo", "endpoints.all.basic-auth.password", "bar") : Map.of("endpoints.all.enabled", true, "endpoints.all.sensitive", false));
        try (ApplicationContext ctx = ApplicationContext.run((PropertySource)mapPropertySource, (String[])new String[]{"cli", "test"});){
            EmbeddedServer embeddedServer = (EmbeddedServer)ctx.getBean(EmbeddedServer.class);
            embeddedServer.start();
            ReactorHttpClient client = (ReactorHttpClient)ctx.getBean(ReactorHttpClient.class);
            consumer.accept(client, (MutableHttpRequest<String>)HttpRequest.GET((String)("http://localhost:" + embeddedServer.getPort() + "/health")));
        }
    }

    @Test
    void withPasswordOk() {
        this.test(true, (client, httpRequest) -> {
            HttpResponse response = client.toBlocking().exchange((HttpRequest)httpRequest.basicAuth((CharSequence)"foo", (CharSequence)"bar"));
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(HttpStatus.OK.getCode());
        });
    }

    @Test
    void withPasswordKo() {
        this.test(true, (client, httpRequest) -> {
            HttpClientResponseException e = (HttpClientResponseException)org.junit.jupiter.api.Assertions.assertThrows(HttpClientResponseException.class, () -> client.toBlocking().exchange((HttpRequest)httpRequest.basicAuth((CharSequence)"foo", (CharSequence)"bar2")));
            Assertions.assertThat((int)e.getStatus().getCode()).isEqualTo(HttpStatus.UNAUTHORIZED.getCode());
        });
        this.test(true, (client, httpRequest) -> {
            HttpClientResponseException e = (HttpClientResponseException)org.junit.jupiter.api.Assertions.assertThrows(HttpClientResponseException.class, () -> client.toBlocking().exchange((HttpRequest)httpRequest));
            Assertions.assertThat((int)e.getStatus().getCode()).isEqualTo(HttpStatus.UNAUTHORIZED.getCode());
        });
    }

    @Test
    void withoutPasswordOk() {
        this.test(false, (client, httpRequest) -> {
            HttpResponse response = client.toBlocking().exchange((HttpRequest)httpRequest);
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(HttpStatus.OK.getCode());
        });
    }
}

