/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.events;

import io.kestra.core.events.CrudEvent;
import io.kestra.core.events.CrudEventType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class CrudEventTest {
    CrudEventTest() {
    }

    @Test
    void shouldReturnCreateEventWhenModelIsProvided() {
        String model = "testModel";
        CrudEvent event = CrudEvent.create((Object)model);
        AssertionsForClassTypes.assertThat((String)((String)event.getModel())).isEqualTo(model);
        AssertionsForClassTypes.assertThat((String)((String)event.getPreviousModel())).isNull();
        AssertionsForClassTypes.assertThat((Object)event.getType()).isEqualTo((Object)CrudEventType.CREATE);
        AssertionsForClassTypes.assertThat((Object)event.getRequest()).isNull();
    }

    @Test
    void shouldThrowExceptionWhenCreateEventWithNullModel() {
        String model = null;
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> CrudEvent.create((Object)model)).isInstanceOf(NullPointerException.class)).hasMessage("Can't create CREATE event with a null model");
    }

    @Test
    void shouldReturnDeleteEventWhenModelIsProvided() {
        String model = "testModel";
        CrudEvent event = CrudEvent.delete((Object)model);
        AssertionsForClassTypes.assertThat((String)((String)event.getModel())).isNull();
        AssertionsForClassTypes.assertThat((String)((String)event.getPreviousModel())).isEqualTo(model);
        AssertionsForClassTypes.assertThat((Object)event.getType()).isEqualTo((Object)CrudEventType.DELETE);
        AssertionsForClassTypes.assertThat((Object)event.getRequest()).isNull();
    }

    @Test
    void shouldThrowExceptionWhenDeleteEventWithNullModel() {
        String model = null;
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> CrudEvent.delete((Object)model)).isInstanceOf(NullPointerException.class)).hasMessage("Can't create DELETE event with a null model");
    }

    @Test
    void shouldReturnUpdateEventWhenBeforeAndAfterAreProvided() {
        String before = "oldModel";
        String after = "newModel";
        CrudEvent event = CrudEvent.of((Object)before, (Object)after);
        AssertionsForClassTypes.assertThat((String)((String)event.getModel())).isEqualTo(after);
        AssertionsForClassTypes.assertThat((String)((String)event.getPreviousModel())).isEqualTo(before);
        AssertionsForClassTypes.assertThat((Object)event.getType()).isEqualTo((Object)CrudEventType.UPDATE);
        AssertionsForClassTypes.assertThat((Object)event.getRequest()).isNull();
    }

    @Test
    void shouldReturnCreateEventWhenBeforeIsNullAndAfterIsProvided() {
        Object before = null;
        String after = "newModel";
        CrudEvent event = CrudEvent.of(before, (Object)after);
        AssertionsForClassTypes.assertThat((String)((String)event.getModel())).isEqualTo(after);
        AssertionsForClassTypes.assertThat((String)((String)event.getPreviousModel())).isNull();
        AssertionsForClassTypes.assertThat((Object)event.getType()).isEqualTo((Object)CrudEventType.CREATE);
        AssertionsForClassTypes.assertThat((Object)event.getRequest()).isNull();
    }

    @Test
    void shouldReturnDeleteEventWhenAfterIsNullAndBeforeIsProvided() {
        String before = "oldModel";
        Object after = null;
        CrudEvent event = CrudEvent.of((Object)before, after);
        AssertionsForClassTypes.assertThat((String)((String)event.getModel())).isNull();
        AssertionsForClassTypes.assertThat((String)((String)event.getPreviousModel())).isEqualTo(before);
        AssertionsForClassTypes.assertThat((Object)event.getType()).isEqualTo((Object)CrudEventType.DELETE);
        AssertionsForClassTypes.assertThat((Object)event.getRequest()).isNull();
    }

    @Test
    void shouldThrowExceptionWhenBothBeforeAndAfterAreNull() {
        String before = null;
        String after = null;
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> CrudEvent.of((Object)before, (Object)after)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Both before and after cannot be null");
    }
}

