/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.http.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.http.HttpRequest;
import io.kestra.core.http.HttpResponse;
import io.kestra.core.http.client.HttpClient;
import io.kestra.core.http.client.HttpClientException;
import io.kestra.core.http.client.HttpClientRequestException;
import io.kestra.core.http.client.HttpClientResponseException;
import io.kestra.core.http.client.configurations.HttpConfiguration;
import io.kestra.core.http.client.configurations.ProxyConfiguration;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.property.Property;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.micronaut.context.ApplicationContext;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.multipart.CompletedFileUpload;
import io.micronaut.http.server.multipart.MultipartBody;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.scheduling.annotation.ExecuteOn;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.RetryingTest;
import org.reactivestreams.Publisher;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;
import reactor.core.publisher.Flux;

@KestraTest
@Testcontainers
@org.junit.jupiter.api.parallel.Execution(value=ExecutionMode.SAME_THREAD)
class HttpClientTest {
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private TestRunContextFactory runContextFactory;
    private URI embeddedServerUri;
    @Container
    static GenericContainer<?> proxy = new GenericContainer("kalaksi/tinyproxy").withExposedPorts(new Integer[]{8888}).withEnv(Map.of("AUTH_USER", "pr0xy", "AUTH_PASSWORD", "p4ss"));
    @Inject
    @Named(value="workerTaskLogQueue")
    QueueInterface<LogEntry> workerTaskLogQueue;
    private static final String UUID = IdUtils.create();

    HttpClientTest() {
    }

    @BeforeEach
    void setUp() {
        EmbeddedServer embeddedServer = (EmbeddedServer)this.applicationContext.getBean(EmbeddedServer.class);
        embeddedServer.start();
        this.embeddedServerUri = embeddedServer.getURI();
    }

    HttpClient client() throws IllegalVariableEvaluationException {
        return this.client(null);
    }

    HttpClient client(@Nullable Consumer<HttpClient.HttpClientBuilder> consumer) throws IllegalVariableEvaluationException {
        HttpClient.HttpClientBuilder builder = HttpClient.builder().runContext(this.runContextFactory.of());
        if (consumer != null) {
            consumer.accept(builder);
        }
        return builder.build();
    }

    @RetryingTest(value=5)
    void getText() throws IllegalVariableEvaluationException, HttpClientException, IOException {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, Map.of());
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        TestsUtils.receive(this.workerTaskLogQueue, either -> logs.add((LogEntry)either.getLeft()));
        RunContext runContext = this.runContextFactory.of((FlowInterface)flow, execution);
        HttpClient.HttpClientBuilder configuration = HttpClient.builder().runContext(runContext).configuration(HttpConfiguration.builder().logs(HttpConfiguration.LoggingType.values()).build());
        try (HttpClient client = configuration.build();){
            HttpResponse response = client.request(HttpRequest.builder().uri(URI.create(String.valueOf(this.embeddedServerUri) + "/http/text")).addHeader("X-Unit", "Test").build(), String.class);
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(200);
            Assertions.assertThat((String)((String)response.getBody())).isEqualTo("pong");
            List logEntries = TestsUtils.awaitLogs(logs, (Integer)6);
            Assertions.assertThat((long)logEntries.stream().filter(logEntry -> logEntry.getMessage().startsWith("request")).count()).isEqualTo(3L);
            Assertions.assertThat((long)logEntries.stream().filter(logEntry -> logEntry.getMessage().contains("X-Unit: Test")).count()).isEqualTo(1L);
            Assertions.assertThat((long)logEntries.stream().filter(logEntry -> logEntry.getMessage().startsWith("response")).count()).isEqualTo(3L);
        }
    }

    @Test
    void getByte() throws IllegalVariableEvaluationException, HttpClientException, IOException {
        try (HttpClient client = this.client();){
            HttpResponse response = client.request(HttpRequest.of((URI)URI.create(String.valueOf(this.embeddedServerUri) + "/http/text")), Byte[].class);
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(200);
            Assertions.assertThat((byte[])ArrayUtils.toPrimitive((Byte[])((Byte[])response.getBody()))).isEqualTo((Object)"pong".getBytes(StandardCharsets.UTF_8));
        }
    }

    @Test
    void getEmpty() throws IllegalVariableEvaluationException, HttpClientException, IOException {
        try (HttpClient client = this.client();){
            HttpResponse response = client.request(HttpRequest.of((URI)URI.create(String.valueOf(this.embeddedServerUri) + "/http/empty")), String.class);
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(204);
            Assertions.assertThat((String)((String)response.getBody())).isNull();
        }
    }

    @Test
    void getJsonMap() throws IllegalVariableEvaluationException, HttpClientException, IOException {
        try (HttpClient client = this.client();){
            HttpResponse response = client.request(HttpRequest.of((URI)URI.create(String.valueOf(this.embeddedServerUri) + "/http/json")));
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(200);
            Assertions.assertThat((String)((String)((Map)response.getBody()).get("ping"))).isEqualTo("pong");
            Assertions.assertThat((String)response.getHeaders().firstValue("Content-Type").orElseThrow()).isEqualTo("application/json");
        }
    }

    @Test
    void getJsonList() throws IllegalVariableEvaluationException, HttpClientException, IOException {
        try (HttpClient client = this.client();){
            HttpResponse response = client.request(HttpRequest.of((URI)URI.create(String.valueOf(this.embeddedServerUri) + "/http/json?array=true")));
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(200);
            Assertions.assertThat((List)((List)response.getBody())).containsExactlyInAnyOrder((Object[])new Integer[]{1, 2, 3});
            Assertions.assertThat((String)response.getHeaders().firstValue("Content-Type").orElseThrow()).isEqualTo("application/json");
        }
    }

    @Test
    void getJsonAsText() throws IllegalVariableEvaluationException, HttpClientException, IOException {
        try (HttpClient client = this.client();){
            HttpResponse response = client.request(HttpRequest.of((URI)URI.create(String.valueOf(this.embeddedServerUri) + "/http/json")), String.class);
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(200);
            Assertions.assertThat((String)((String)response.getBody())).isEqualTo("{\"ping\":\"pong\"}");
            Assertions.assertThat((String)response.getHeaders().firstValue("Content-Type").orElseThrow()).isEqualTo("application/json");
        }
    }

    static Stream<Arguments> postJsonSource() throws JsonProcessingException {
        return Stream.of(Arguments.of((Object[])new Object[]{HttpRequest.JsonRequestBody.builder().content(Map.of("ping", UUID)).build()}), Arguments.of((Object[])new Object[]{HttpRequest.InputStreamRequestBody.builder().content((InputStream)new ByteArrayInputStream(JacksonMapper.ofJson().writeValueAsBytes(Map.of("ping", UUID)))).contentType("application/json").build()}), Arguments.of((Object[])new Object[]{HttpRequest.ByteArrayRequestBody.builder().content(JacksonMapper.ofJson().writeValueAsBytes(Map.of("ping", UUID))).contentType("application/json").build()}));
    }

    @ParameterizedTest
    @MethodSource(value={"postJsonSource"})
    void postJson(HttpRequest.RequestBody requestBody) throws IllegalVariableEvaluationException, HttpClientException, IOException {
        try (HttpClient client = this.client();){
            HttpResponse response = client.request(HttpRequest.of((URI)URI.create(String.valueOf(this.embeddedServerUri) + "/http/json-post"), (String)"POST", (HttpRequest.RequestBody)requestBody));
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(200);
            Assertions.assertThat((String)((String)((Map)response.getBody()).get("ping"))).isEqualTo(UUID);
            Assertions.assertThat((String)response.getHeaders().firstValue("Content-Type").orElseThrow()).isEqualTo("application/json");
        }
    }

    @Test
    void postCustomObject() throws IllegalVariableEvaluationException, HttpClientException, IOException {
        CustomObject test = CustomObject.builder().id(IdUtils.create()).name("test").build();
        try (HttpClient client = this.client();){
            HttpResponse response = client.request(HttpRequest.of((URI)URI.create(String.valueOf(this.embeddedServerUri) + "/http/json-post"), (String)"POST", (HttpRequest.RequestBody)HttpRequest.JsonRequestBody.builder().content((Object)test).build()), CustomObject.class);
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(200);
            Assertions.assertThat((String)((CustomObject)response.getBody()).id).isEqualTo(test.id);
            Assertions.assertThat((String)response.getHeaders().firstValue("Content-Type").orElseThrow()).isEqualTo("application/json");
        }
    }

    @Test
    void postCustomObject_WithUnknownResponseField() throws IllegalVariableEvaluationException, HttpClientException, IOException {
        CustomObject test = CustomObject.builder().id(IdUtils.create()).name("test").build();
        Map withAdditionalField = (Map)JacksonMapper.ofJson().convertValue((Object)test, (TypeReference)new TypeReference<Map<String, String>>(this){});
        withAdditionalField.put("foo", "bar");
        try (HttpClient client = this.client();){
            HttpResponse response = client.request(HttpRequest.of((URI)URI.create(String.valueOf(this.embeddedServerUri) + "/http/json-post"), (String)"POST", (HttpRequest.RequestBody)HttpRequest.JsonRequestBody.builder().content((Object)withAdditionalField).build()), CustomObject.class);
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(200);
            Assertions.assertThat((String)((CustomObject)response.getBody()).id).isEqualTo(test.id);
            Assertions.assertThat((String)response.getHeaders().firstValue("Content-Type").orElseThrow()).isEqualTo("application/json");
        }
    }

    @Test
    void postMultipart() throws IOException, URISyntaxException, IllegalVariableEvaluationException, HttpClientException {
        Map<String, ByteArrayInputStream> multipart = Map.of("ping", "pong", "int", 1, "file", new File(Objects.requireNonNull(this.getClass().getClassLoader().getResource("logback.xml")).toURI()), "inputStream", new ByteArrayInputStream(IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("logback.xml")), (Charset)StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8)));
        try (HttpClient client = this.client();){
            HttpResponse response = client.request(HttpRequest.of((URI)URI.create(String.valueOf(this.embeddedServerUri) + "/http/multipart"), (String)"POST", (HttpRequest.RequestBody)HttpRequest.MultipartRequestBody.builder().content(multipart).build()));
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(200);
            Assertions.assertThat(((Map)response.getBody()).get("ping")).isEqualTo((Object)"pong");
            Assertions.assertThat(((Map)response.getBody()).get("int")).isEqualTo((Object)"1");
            Assertions.assertThat((String)((String)((Map)response.getBody()).get("file"))).contains(new CharSequence[]{"logback"});
            Assertions.assertThat((String)response.getHeaders().firstValue("Content-Type").orElseThrow()).isEqualTo("application/json");
        }
    }

    @Test
    void errorUnreachable() throws IOException, IllegalVariableEvaluationException {
        try (HttpClient client = this.client();){
            URI uri = URI.create("http://localhost:1234");
            HttpClientRequestException e = (HttpClientRequestException)org.junit.jupiter.api.Assertions.assertThrows(HttpClientRequestException.class, () -> client.request(HttpRequest.of((URI)uri)));
            Assertions.assertThat((URI)e.getRequest().getUri()).isEqualTo((Object)uri);
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Connection refused"});
        }
    }

    @Test
    void response305() throws IOException, IllegalVariableEvaluationException, HttpClientException {
        try (HttpClient client = this.client();){
            HttpResponse response = client.request(HttpRequest.of((URI)URI.create(String.valueOf(this.embeddedServerUri) + "/http/error?status=305")));
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(305);
        }
    }

    @Test
    void error400() throws IOException, IllegalVariableEvaluationException {
        try (HttpClient client = this.client();){
            URI uri = URI.create(String.valueOf(this.embeddedServerUri) + "/http/error");
            HttpClientResponseException e = (HttpClientResponseException)org.junit.jupiter.api.Assertions.assertThrows(HttpClientResponseException.class, () -> client.request(HttpRequest.of((URI)uri)));
            Assertions.assertThat((int)Objects.requireNonNull(e.getResponse()).getStatus().getCode()).isEqualTo(400);
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Required QueryValue [status]"});
            Assertions.assertThat((String)new String((byte[])e.getResponse().getBody())).contains(new CharSequence[]{"Required QueryValue [status]"});
        }
    }

    @Test
    void error404() throws IOException, IllegalVariableEvaluationException {
        try (HttpClient client = this.client();){
            URI uri = URI.create(String.valueOf(this.embeddedServerUri) + "/http/error?status=404");
            HttpClientResponseException e = (HttpClientResponseException)org.junit.jupiter.api.Assertions.assertThrows(HttpClientResponseException.class, () -> client.request(HttpRequest.of((URI)uri)));
            Assertions.assertThat((int)Objects.requireNonNull(e.getResponse()).getStatus().getCode()).isEqualTo(404);
        }
    }

    @Test
    void noError404() throws IOException, IllegalVariableEvaluationException, HttpClientException {
        try (HttpClient client = this.client(b -> b.configuration(HttpConfiguration.builder().allowFailed(Property.ofValue((Object)true)).build()));){
            HttpResponse response = client.request(HttpRequest.of((URI)URI.create(String.valueOf(this.embeddedServerUri) + "/http/error?status=404")));
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(404);
        }
    }

    @Test
    void noErrorPost404() throws IOException, IllegalVariableEvaluationException, HttpClientException {
        try (HttpClient client = this.client(b -> b.configuration(HttpConfiguration.builder().allowFailed(Property.ofValue((Object)true)).build()));){
            URI uri = URI.create(String.valueOf(this.embeddedServerUri) + "/http/post-error");
            HttpResponse response = client.request(HttpRequest.builder().uri(uri).method("POST").body((HttpRequest.RequestBody)HttpRequest.StringRequestBody.builder().content("OK").build()).build());
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(404);
        }
    }

    @Test
    void specialContentType() throws IllegalVariableEvaluationException, HttpClientException, IOException {
        try (HttpClient client = this.client();){
            HttpResponse response = client.request(HttpRequest.of((URI)URI.create(String.valueOf(this.embeddedServerUri) + "/http/content-type"), Map.of("Content-Type", List.of("application/vnd.campaignsexport.v1+json"))), String.class);
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(200);
            Assertions.assertThat((String)((String)response.getBody())).isEqualTo("application/vnd.campaignsexport.v1+json");
        }
    }

    @Test
    void getProxy() throws IllegalVariableEvaluationException, HttpClientException, IOException {
        try (HttpClient client = this.client(b -> b.configuration(HttpConfiguration.builder().proxy(ProxyConfiguration.builder().type(Property.ofValue((Object)((Object)Proxy.Type.HTTP))).address(Property.ofValue((Object)proxy.getHost())).username(Property.ofValue((Object)"pr0xy")).password(Property.ofValue((Object)"p4ss")).port(Property.ofValue((Object)proxy.getFirstMappedPort())).build()).build()));){
            HttpResponse response = client.request(HttpRequest.of((URI)URI.create("https://www.google.com")), String.class);
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(200);
            Assertions.assertThat((String)((String)response.getBody())).contains(new CharSequence[]{"<html"});
        }
    }

    @Test
    void shouldReturnResponseForAllowedResponseCode() throws IOException, IllegalVariableEvaluationException, HttpClientException {
        try (HttpClient client = this.client(b -> b.configuration(HttpConfiguration.builder().allowedResponseCodes(Property.of(List.of(Integer.valueOf(404)))).build()));){
            HttpResponse response = client.request(HttpRequest.of((URI)URI.create(String.valueOf(this.embeddedServerUri) + "/http/error?status=404")));
            Assertions.assertThat((int)response.getStatus().getCode()).isEqualTo(404);
        }
    }

    @Test
    void shouldThrowExceptionForNotAllowedResponseCode() throws IOException, IllegalVariableEvaluationException {
        try (HttpClient client = this.client(b -> b.configuration(HttpConfiguration.builder().allowedResponseCodes(Property.of(List.of(Integer.valueOf(404)))).build()));){
            URI uri = URI.create(String.valueOf(this.embeddedServerUri) + "/http/error?status=405");
            HttpClientResponseException e = (HttpClientResponseException)org.junit.jupiter.api.Assertions.assertThrows(HttpClientResponseException.class, () -> client.request(HttpRequest.of((URI)uri)));
            Assertions.assertThat((int)Objects.requireNonNull(e.getResponse()).getStatus().getCode()).isEqualTo(405);
        }
    }

    public static final class CustomObject {
        private final String id;
        private final String name;

        @ConstructorProperties(value={"id", "name"})
        @Generated
        CustomObject(String id, String name) {
            this.id = id;
            this.name = name;
        }

        @Generated
        public static CustomObjectBuilder builder() {
            return new CustomObjectBuilder();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomObject)) {
                return false;
            }
            CustomObject other = (CustomObject)o;
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HttpClientTest.CustomObject(id=" + this.getId() + ", name=" + this.getName() + ")";
        }

        @Generated
        public static class CustomObjectBuilder {
            @Generated
            private String id;
            @Generated
            private String name;

            @Generated
            CustomObjectBuilder() {
            }

            @Generated
            public CustomObjectBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public CustomObjectBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public CustomObject build() {
                return new CustomObject(this.id, this.name);
            }

            @Generated
            public String toString() {
                return "HttpClientTest.CustomObject.CustomObjectBuilder(id=" + this.id + ", name=" + this.name + ")";
            }
        }
    }

    @Controller(value="/http/")
    public static class ClientTestController {
        @Get(value="text")
        @Produces(value={"text/plain"})
        public io.micronaut.http.HttpResponse<String> text() {
            return io.micronaut.http.HttpResponse.ok((Object)"pong");
        }

        @Get(value="content-type")
        @Produces(value={"text/plain"})
        public io.micronaut.http.HttpResponse<String> contentType(io.micronaut.http.HttpRequest<?> request) {
            return io.micronaut.http.HttpResponse.ok((Object)((MediaType)request.getContentType().orElseThrow()).toString());
        }

        @Get(value="json")
        public io.micronaut.http.HttpResponse<Object> json(@QueryValue(defaultValue="false") Boolean array) {
            return io.micronaut.http.HttpResponse.ok(array != false ? List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)) : Map.of("ping", "pong"));
        }

        @Post(value="json-post")
        public io.micronaut.http.HttpResponse<Object> jsonPost(@Body Map<String, Object> data) {
            return io.micronaut.http.HttpResponse.ok(data);
        }

        @Get(value="empty")
        public io.micronaut.http.HttpResponse<Object> empty() {
            return io.micronaut.http.HttpResponse.noContent();
        }

        @Get(value="no-content")
        public io.micronaut.http.HttpResponse<Void> noContent() {
            return io.micronaut.http.HttpResponse.noContent();
        }

        @Get(value="error")
        public io.micronaut.http.HttpResponse<Object> errors(@QueryValue int status) {
            return io.micronaut.http.HttpResponse.status((HttpStatus)HttpStatus.valueOf((int)status)).body(Map.of("status", status));
        }

        @Post(value="error")
        public io.micronaut.http.HttpResponse<Object> postErrors(@QueryValue int status, @Body String body) {
            return io.micronaut.http.HttpResponse.status((HttpStatus)HttpStatus.valueOf((int)status)).body(Map.of("status", status));
        }

        @ExecuteOn(value="io")
        @Post(uri="multipart", consumes={"multipart/form-data"})
        public io.micronaut.http.HttpResponse<Object> multipartPost(@Body MultipartBody body) {
            Map result = (Map)Flux.from((Publisher)body).handle((input, sink) -> {
                if (input instanceof CompletedFileUpload) {
                    CompletedFileUpload fileUpload = (CompletedFileUpload)input;
                    try (InputStream inputStream = fileUpload.getInputStream();){
                        sink.next(new AbstractMap.SimpleEntry<String, String>(fileUpload.getName(), IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8)));
                    }
                    catch (IOException e) {
                        fileUpload.discard();
                        sink.error((Throwable)e);
                    }
                } else {
                    try {
                        sink.next(new AbstractMap.SimpleEntry<String, String>(input.getName(), new String(input.getBytes())));
                    }
                    catch (IOException e) {
                        sink.error((Throwable)e);
                    }
                }
            }).collectMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue).block();
            return io.micronaut.http.HttpResponse.ok((Object)result);
        }
    }
}

