/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.Label;
import io.kestra.core.models.validations.ModelValidator;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class LabelTest {
    @Inject
    private ModelValidator modelValidator;

    LabelTest() {
    }

    @Test
    void shouldGetNestedMapGivenDistinctLabels() {
        Map result = Label.toNestedMap(List.of(new Label("system.username", "test"), new Label("system.correlationId", "id"), new Label("", "bar"), new Label(null, "bar"), new Label("foo", ""), new Label("baz", null)));
        Assertions.assertThat((Map)result).isEqualTo(Map.of("system", Map.of("username", "test", "correlationId", "id")));
    }

    @Test
    void shouldGetNestedMapGivenDuplicateLabels() {
        Map result = Label.toNestedMap(List.of(new Label("system.username", "test1"), new Label("system.username", "test2"), new Label("system.correlationId", "id")));
        Assertions.assertThat((Map)result).isEqualTo(Map.of("system", Map.of("username", "test2", "correlationId", "id")));
    }

    @Test
    void toNestedMapShouldIgnoreEmptyOrNull() {
        Map result = Label.toNestedMap(List.of(new Label("", "bar"), new Label(null, "bar"), new Label("foo", ""), new Label("baz", null)));
        Assertions.assertThat((Map)result).isEmpty();
    }

    @Test
    void shouldGetMapGivenDistinctLabels() {
        Map result = Label.toMap(List.of(new Label("system.username", "test"), new Label("system.correlationId", "id")));
        Assertions.assertThat((Map)result).isEqualTo(Map.of("system.username", "test", "system.correlationId", "id"));
    }

    @Test
    void shouldGetMapGivenDuplicateLabels() {
        Map result = Label.toMap(List.of(new Label("system.username", "test1"), new Label("system.username", "test2"), new Label("system.correlationId", "id")));
        Assertions.assertThat((Map)result).isEqualTo(Map.of("system.username", "test2", "system.correlationId", "id"));
    }

    @Test
    void toMapShouldIgnoreEmptyOrNull() {
        Map result = Label.toMap(List.of(new Label("", "bar"), new Label(null, "bar"), new Label("foo", ""), new Label("baz", null)));
        Assertions.assertThat((Map)result).isEmpty();
    }

    @Test
    void shouldDuplicateLabelsWithKeyOrderKept() {
        List result = Label.deduplicate(List.of(new Label("system.username", "test1"), new Label("system.username", "test2"), new Label("system.correlationId", "id"), new Label("system.username", "test3")));
        Assertions.assertThat((List)result).containsExactly((Object[])new Label[]{new Label("system.username", "test3"), new Label("system.correlationId", "id")});
    }

    @Test
    void deduplicateShouldIgnoreEmptyAndNull() {
        List result = Label.deduplicate(List.of(new Label("", "bar"), new Label(null, "bar"), new Label("foo", ""), new Label("baz", null)));
        Assertions.assertThat((List)result).isEmpty();
    }

    @Test
    void shouldValidateEmpty() {
        Optional validLabelResult = this.modelValidator.isValid((Object)new Label("foo", "bar"));
        Assertions.assertThat((boolean)validLabelResult.isPresent()).isFalse();
        Optional emptyValueLabelResult = this.modelValidator.isValid((Object)new Label("foo", ""));
        Assertions.assertThat((boolean)emptyValueLabelResult.isPresent()).isTrue();
        Optional emptyKeyLabelResult = this.modelValidator.isValid((Object)new Label("", "bar"));
        Assertions.assertThat((boolean)emptyKeyLabelResult.isPresent()).isTrue();
    }
}

