/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models;

import io.kestra.core.exceptions.InvalidQueryFiltersException;
import io.kestra.core.models.QueryFilter;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class QueryFilterTest {
    @ParameterizedTest
    @MethodSource(value={"validOperationFilters"})
    void should_validate_all_operations(QueryFilter filter, QueryFilter.Resource resource) {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> QueryFilter.validateQueryFilters(List.of(filter), (QueryFilter.Resource)resource));
    }

    @ParameterizedTest
    @MethodSource(value={"invalidOperationFilters"})
    void should_fail_to_validate_all_operations(QueryFilter filter, QueryFilter.Resource resource) {
        InvalidQueryFiltersException e = (InvalidQueryFiltersException)Assert.assertThrows(InvalidQueryFiltersException.class, () -> QueryFilter.validateQueryFilters(List.of(filter), (QueryFilter.Resource)resource));
        Assertions.assertThat((String)e.formatedInvalidObjects()).contains(new CharSequence[]{"Operation"});
    }

    static Stream<Arguments> validOperationFilters() {
        return Stream.of(Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.QUERY).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.QUERY).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.SCOPE).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.SCOPE).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.IN).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.REGEX).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.PREFIX).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.IN).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).operation(QueryFilter.Op.REGEX).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.START_DATE).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.START_DATE).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.START_DATE).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.START_DATE).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.START_DATE).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.START_DATE).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.END_DATE).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.END_DATE).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.END_DATE).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.END_DATE).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.END_DATE).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.END_DATE).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.STATE).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.STATE).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.STATE).operation(QueryFilter.Op.IN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.STATE).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).operation(QueryFilter.Op.IN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).operation(QueryFilter.Op.IN).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).operation(QueryFilter.Op.IN).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.Resource.TRIGGER}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.Resource.TRIGGER}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).operation(QueryFilter.Op.IN).build(), QueryFilter.Resource.TRIGGER}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.Resource.TRIGGER}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.Resource.TRIGGER}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.Resource.TRIGGER}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.Resource.TRIGGER}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.Resource.NAMESPACE}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.Resource.NAMESPACE}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).operation(QueryFilter.Op.EQUALS).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).operation(QueryFilter.Op.NOT_EQUALS).build(), QueryFilter.Resource.LOG}));
    }

    static Stream<Arguments> invalidOperationFilters() {
        return Stream.of(Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.QUERY).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.QUERY).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.QUERY).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.QUERY).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.QUERY).operation(QueryFilter.Op.IN).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.QUERY).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.QUERY).operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.QUERY).operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.QUERY).operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.QUERY).operation(QueryFilter.Op.REGEX).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.QUERY).operation(QueryFilter.Op.PREFIX).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.SCOPE).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.SCOPE).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.SCOPE).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.SCOPE).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.SCOPE).operation(QueryFilter.Op.IN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.SCOPE).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.SCOPE).operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.SCOPE).operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.SCOPE).operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.SCOPE).operation(QueryFilter.Op.REGEX).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.SCOPE).operation(QueryFilter.Op.PREFIX).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.NAMESPACE).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.REGEX).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.LABELS).operation(QueryFilter.Op.PREFIX).build(), QueryFilter.Resource.FLOW}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).operation(QueryFilter.Op.IN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.FLOW_ID).operation(QueryFilter.Op.PREFIX).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.START_DATE).operation(QueryFilter.Op.IN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.START_DATE).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.START_DATE).operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.START_DATE).operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.START_DATE).operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.START_DATE).operation(QueryFilter.Op.REGEX).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.START_DATE).operation(QueryFilter.Op.PREFIX).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.END_DATE).operation(QueryFilter.Op.IN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.END_DATE).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.END_DATE).operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.END_DATE).operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.END_DATE).operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.END_DATE).operation(QueryFilter.Op.REGEX).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.END_DATE).operation(QueryFilter.Op.PREFIX).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.STATE).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.STATE).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.STATE).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.STATE).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.STATE).operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.STATE).operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.STATE).operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.STATE).operation(QueryFilter.Op.REGEX).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.STATE).operation(QueryFilter.Op.PREFIX).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).operation(QueryFilter.Op.REGEX).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_EXECUTION_ID).operation(QueryFilter.Op.PREFIX).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).operation(QueryFilter.Op.REGEX).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.TRIGGER_ID).operation(QueryFilter.Op.PREFIX).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).operation(QueryFilter.Op.REGEX).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXECUTION_ID).operation(QueryFilter.Op.PREFIX).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).operation(QueryFilter.Op.IN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).operation(QueryFilter.Op.REGEX).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.CHILD_FILTER).operation(QueryFilter.Op.PREFIX).build(), QueryFilter.Resource.EXECUTION}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.Resource.TRIGGER}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.Resource.TRIGGER}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.TRIGGER}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.TRIGGER}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).operation(QueryFilter.Op.REGEX).build(), QueryFilter.Resource.TRIGGER}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.WORKER_ID).operation(QueryFilter.Op.PREFIX).build(), QueryFilter.Resource.TRIGGER}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.Resource.NAMESPACE}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.Resource.NAMESPACE}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.NAMESPACE}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.NAMESPACE}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).operation(QueryFilter.Op.IN).build(), QueryFilter.Resource.NAMESPACE}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.Resource.NAMESPACE}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.Resource.NAMESPACE}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.Resource.NAMESPACE}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.Resource.NAMESPACE}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).operation(QueryFilter.Op.REGEX).build(), QueryFilter.Resource.NAMESPACE}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.EXISTING_ONLY).operation(QueryFilter.Op.PREFIX).build(), QueryFilter.Resource.NAMESPACE}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).operation(QueryFilter.Op.GREATER_THAN).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).operation(QueryFilter.Op.LESS_THAN).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).operation(QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).operation(QueryFilter.Op.LESS_THAN_OR_EQUAL_TO).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).operation(QueryFilter.Op.IN).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).operation(QueryFilter.Op.NOT_IN).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).operation(QueryFilter.Op.STARTS_WITH).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).operation(QueryFilter.Op.ENDS_WITH).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).operation(QueryFilter.Op.CONTAINS).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).operation(QueryFilter.Op.REGEX).build(), QueryFilter.Resource.LOG}), Arguments.of((Object[])new Object[]{QueryFilter.builder().field(QueryFilter.Field.MIN_LEVEL).operation(QueryFilter.Op.PREFIX).build(), QueryFilter.Resource.LOG}));
    }
}

