/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.collectors;

import io.kestra.core.models.collectors.ServiceUsage;
import io.kestra.core.server.Service;
import io.kestra.core.server.ServiceInstance;
import io.kestra.core.server.ServiceType;
import io.kestra.core.utils.IdUtils;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ServiceUsageTest {
    ServiceUsageTest() {
    }

    @Test
    void shouldGetDailyUsage() {
        LocalDate now = LocalDate.now();
        LocalDate start = now.withDayOfMonth(1);
        LocalDate end = start.withDayOfMonth(start.getMonth().length(start.isLeapYear()));
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        while (start.toEpochDay() < end.toEpochDay()) {
            Instant createAt = start.atStartOfDay(ZoneId.systemDefault()).toInstant();
            Instant updatedAt = start.atStartOfDay(ZoneId.systemDefault()).plus(Duration.ofHours(10L)).toInstant();
            ServiceInstance instance = new ServiceInstance(IdUtils.create(), ServiceType.WORKER, Service.ServiceState.INACTIVE, null, createAt, updatedAt, List.of(), null, Map.of(), Set.of());
            instance = instance.state(Service.ServiceState.RUNNING, createAt).state(Service.ServiceState.NOT_RUNNING, updatedAt);
            instances.add(instance);
            start = start.plusDays(1L);
        }
        ServiceUsage.DailyServiceStatistics statistics = ServiceUsage.of((ServiceType)ServiceType.WORKER, (Duration)Duration.ofMinutes(15L), instances);
        Assertions.assertEquals((int)instances.size(), (int)statistics.values().size());
    }
}

