/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.executions;

import io.kestra.core.models.Label;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.utils.IdUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class ExecutionTest {
    ExecutionTest() {
    }

    @Test
    void hasTaskRunJoinableTrue() {
        Execution execution = Execution.builder().taskRunList(Collections.singletonList(TaskRun.builder().id("test").state(new State(State.Type.RUNNING, new State())).build())).build();
        Assertions.assertThat((boolean)execution.hasTaskRunJoinable(TaskRun.builder().id("test").state(new State(State.Type.FAILED, new State().withState(State.Type.RUNNING))).build())).isTrue();
    }

    @Test
    void hasTaskRunJoinableSameState() {
        Execution execution = Execution.builder().taskRunList(Collections.singletonList(TaskRun.builder().id("test").state(new State()).build())).build();
        Assertions.assertThat((boolean)execution.hasTaskRunJoinable(TaskRun.builder().id("test").state(new State()).build())).isFalse();
    }

    @Test
    void hasTaskRunJoinableFailedExecutionFromExecutor() {
        Execution execution = Execution.builder().taskRunList(Collections.singletonList(TaskRun.builder().id("test").state(new State(State.Type.FAILED, new State().withState(State.Type.RUNNING))).build())).build();
        Assertions.assertThat((boolean)execution.hasTaskRunJoinable(TaskRun.builder().id("test").state(new State(State.Type.RUNNING, new State())).build())).isFalse();
    }

    @Test
    void hasTaskRunJoinableRestartFailed() {
        Execution execution = Execution.builder().taskRunList(Collections.singletonList(TaskRun.builder().id("test").state(new State(State.Type.CREATED, new State().withState(State.Type.RUNNING).withState(State.Type.FAILED))).build())).build();
        Assertions.assertThat((boolean)execution.hasTaskRunJoinable(TaskRun.builder().id("test").state(new State(State.Type.FAILED, new State().withState(State.Type.RUNNING))).build())).isFalse();
    }

    @Test
    void hasTaskRunJoinableRestartSuccess() {
        Execution execution = Execution.builder().taskRunList(Collections.singletonList(TaskRun.builder().id("test").state(new State(State.Type.CREATED, new State().withState(State.Type.RUNNING).withState(State.Type.SUCCESS))).build())).build();
        Assertions.assertThat((boolean)execution.hasTaskRunJoinable(TaskRun.builder().id("test").state(new State(State.Type.SUCCESS, new State().withState(State.Type.RUNNING).withState(State.Type.SUCCESS))).build())).isTrue();
    }

    @Test
    void hasTaskRunJoinableAfterRestart() {
        Execution execution = Execution.builder().taskRunList(Collections.singletonList(TaskRun.builder().id("test").state(new State(State.Type.CREATED, new State().withState(State.Type.RUNNING).withState(State.Type.FAILED))).build())).build();
        Assertions.assertThat((boolean)execution.hasTaskRunJoinable(TaskRun.builder().id("test").state(new State(State.Type.SUCCESS, new State().withState(State.Type.RUNNING).withState(State.Type.FAILED).withState(State.Type.CREATED).withState(State.Type.RUNNING))).build())).isTrue();
    }

    @Test
    void originalId() {
        Execution execution = Execution.builder().id(IdUtils.create()).state(new State()).build();
        Assertions.assertThat((String)execution.getOriginalId()).isEqualTo(execution.getId());
        Execution restart1 = execution.childExecution(IdUtils.create(), execution.getTaskRunList(), execution.withState(State.Type.RESTARTED).getState());
        Assertions.assertThat((String)restart1.getOriginalId()).isEqualTo(execution.getId());
        Execution restart2 = restart1.childExecution(IdUtils.create(), restart1.getTaskRunList(), restart1.withState(State.Type.PAUSED).getState());
        Assertions.assertThat((String)restart2.getOriginalId()).isEqualTo(execution.getId());
    }

    @Test
    void labels() {
        Execution execution = Execution.builder().labels(List.of(new Label("test", "test-value"))).build();
        Assertions.assertThat((List)execution.getLabels()).containsExactly((Object[])new Label[]{new Label("test", "test-value")});
    }

    @Test
    void labelsGetDeduplicated() {
        List<Label> duplicatedLabels = List.of(new Label("test", "value1"), new Label("test", "value2"));
        Execution executionWithLabels = Execution.builder().build().withLabels(duplicatedLabels);
        Assertions.assertThat((List)executionWithLabels.getLabels()).containsExactly((Object[])new Label[]{new Label("test", "value2")});
        Execution executionBuilder = Execution.builder().labels(duplicatedLabels).build();
        Assertions.assertThat((List)executionBuilder.getLabels()).containsExactly((Object[])new Label[]{new Label("test", "value2")});
    }

    @Test
    @Disabled(value="Solve label deduplication on instantization")
    void labelsGetDeduplicatedOnNewInstance() {
        List<Label> duplicatedLabels = List.of(new Label("test", "value1"), new Label("test", "value2"));
        Execution executionNew = new Execution("foo", "id", "namespace", "flowId", Integer.valueOf(1), Collections.emptyList(), Map.of(), Map.of(), duplicatedLabels, Map.of(), State.of((State.Type)State.Type.SUCCESS, Collections.emptyList()), "parentId", "originalId", null, false, null, null, null, null, null, null);
        Assertions.assertThat((List)executionNew.getLabels()).containsExactly((Object[])new Label[]{new Label("test", "value2")});
    }
}

