/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.executions;

import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.flows.State;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TaskRunTest {
    TaskRunTest() {
    }

    @Test
    void onRunningResendNoAttempts() {
        TaskRun taskRun = TaskRun.builder().state(new State()).build().onRunningResend();
        Assertions.assertThat((int)taskRun.getAttempts().size()).isEqualTo(1);
        Assertions.assertThat((Object)((State.History)((TaskRunAttempt)taskRun.getAttempts().getFirst()).getState().getHistories().getFirst())).isEqualTo(taskRun.getState().getHistories().getFirst());
        Assertions.assertThat((Comparable)((TaskRunAttempt)taskRun.getAttempts().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.RESUBMITTED);
    }

    @Test
    void onRunningResendRunning() {
        TaskRun taskRun = TaskRun.builder().state(new State()).attempts(Collections.singletonList(TaskRunAttempt.builder().state(new State().withState(State.Type.RUNNING)).build())).build().onRunningResend();
        Assertions.assertThat((int)taskRun.getAttempts().size()).isEqualTo(1);
        Assertions.assertThat((Object)((State.History)((TaskRunAttempt)taskRun.getAttempts().getFirst()).getState().getHistories().getFirst())).isNotEqualTo(taskRun.getState().getHistories().getFirst());
        Assertions.assertThat((Comparable)((TaskRunAttempt)taskRun.getAttempts().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.RESUBMITTED);
    }

    @Test
    void onRunningResendTerminated() {
        TaskRun taskRun = TaskRun.builder().state(new State()).attempts(Collections.singletonList(TaskRunAttempt.builder().state(new State().withState(State.Type.SUCCESS)).build())).build().onRunningResend();
        Assertions.assertThat((int)taskRun.getAttempts().size()).isEqualTo(2);
        Assertions.assertThat((Object)((State.History)((TaskRunAttempt)taskRun.getAttempts().get(1)).getState().getHistories().getFirst())).isNotEqualTo(taskRun.getState().getHistories().getFirst());
        Assertions.assertThat((Comparable)((TaskRunAttempt)taskRun.getAttempts().get(1)).getState().getCurrent()).isEqualTo((Object)State.Type.RESUBMITTED);
    }
}

