/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.executions;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Variables;
import io.kestra.core.storages.InternalStorage;
import io.kestra.core.storages.Storage;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.StorageInterface;
import jakarta.inject.Inject;
import java.net.URI;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class VariablesTest {
    @Inject
    private StorageInterface storageInterface;

    VariablesTest() {
    }

    @Test
    void inMemory() {
        Map<String, String> outputs = Map.of("key", "value");
        Variables variables = Variables.inMemory(outputs);
        Assertions.assertThat((Object)variables.get((Object)"key")).isEqualTo((Object)"value");
        Map<String, String> nest = Map.of("nest", "value");
        Variables nestVariables = Variables.inMemory(nest);
        Map<String, Variables> host = Map.of("key", nestVariables);
        Variables hostVariables = Variables.inMemory(host);
        Assertions.assertThat(((Map)hostVariables.get((Object)"key")).get("nest")).isEqualTo((Object)"value");
    }

    @Test
    void inStorage() {
        StorageContext.Task storageContext = StorageContext.forTask((String)"main", (String)"namespace", (String)"flow", (String)"execution", (String)"task", (String)"taskRun", null);
        InternalStorage internalStorage = new InternalStorage((StorageContext)storageContext, this.storageInterface);
        Variables.StorageContext variablesContext = new Variables.StorageContext("main", "namespace");
        Map<String, String> outputs = Map.of("key", "value");
        Variables variables = Variables.inStorage((Storage)internalStorage, outputs);
        Assertions.assertThat((Object)variables.get((Object)"key")).isEqualTo((Object)"value");
        URI uri = ((Variables.InStorageVariables)variables).getStorageUri();
        variables = Variables.inStorage((Variables.StorageContext)variablesContext, (URI)uri);
        Assertions.assertThat((Object)variables.get((Object)"key")).isEqualTo((Object)"value");
        Map<String, String> nest = Map.of("nest", "value");
        Variables nestVariables = Variables.inStorage((Storage)internalStorage, nest);
        Map<String, Variables> host = Map.of("key", nestVariables);
        Variables hostVariables = Variables.inStorage((Storage)internalStorage, host);
        Assertions.assertThat(((Map)hostVariables.get((Object)"key")).get("nest")).isEqualTo((Object)"value");
        uri = ((Variables.InStorageVariables)hostVariables).getStorageUri();
        hostVariables = Variables.inStorage((Variables.StorageContext)variablesContext, (URI)uri);
        Assertions.assertThat(((Map)hostVariables.get((Object)"key")).get("nest")).isEqualTo((Object)"value");
    }
}

