/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows;

import io.kestra.core.models.flows.FlowId;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FlowIdTest {
    FlowIdTest() {
    }

    @Test
    void shouldGetUidWithoutRevision() {
        String id = FlowId.uidWithoutRevision((String)"tenant", (String)"io.kestra.unittest", (String)"flow-id");
        Assertions.assertThat((String)id).isEqualTo("tenant_io.kestra.unittest_flow-id");
    }

    @Test
    void shouldGetUidGivenEmptyRevision() {
        String id = FlowId.uid((String)"tenant", (String)"io.kestra.unittest", (String)"flow-id", Optional.empty());
        Assertions.assertThat((String)id).isEqualTo("tenant_io.kestra.unittest_flow-id_-1");
    }

    @Test
    void shouldGetUidGivenRevision() {
        String id = FlowId.uid((String)"tenant", (String)"io.kestra.unittest", (String)"flow-id", Optional.of(42));
        Assertions.assertThat((String)id).isEqualTo("tenant_io.kestra.unittest_flow-id_42");
    }
}

