/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.input.StringInput;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.serializers.YamlParser;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.debug.Return;
import io.kestra.plugin.core.log.Log;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.io.File;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class FlowTest {
    @Inject
    ModelValidator modelValidator;

    FlowTest() {
    }

    @Test
    void duplicate() {
        Flow flow = this.parse("flows/invalids/duplicate.yaml");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isTrue();
        Assertions.assertThat((int)((ConstraintViolationException)validate.get()).getConstraintViolations().size()).isEqualTo(1);
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"Duplicate task id with name [date, listen]"});
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"Duplicate trigger id with name [trigger]"});
    }

    @Test
    void duplicateInputs() {
        Flow flow = this.parse("flows/invalids/duplicate-inputs.yaml");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isTrue();
        Assertions.assertThat((int)((ConstraintViolationException)validate.get()).getConstraintViolations().size()).isEqualTo(1);
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"Duplicate input with name [first_input]"});
    }

    @Test
    void duplicateParallel() {
        Flow flow = this.parse("flows/invalids/duplicate-parallel.yaml");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isTrue();
        Assertions.assertThat((int)((ConstraintViolationException)validate.get()).getConstraintViolations().size()).isEqualTo(1);
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"Duplicate task id with name [t3]"});
    }

    @Test
    void duplicateUpdate() {
        Flow flow = this.parse("flows/valids/logs.yaml");
        Flow updated = this.parse("flows/invalids/duplicate.yaml");
        Optional validate = flow.validateUpdate(updated);
        Assertions.assertThat((boolean)validate.isPresent()).isTrue();
        Assertions.assertThat((int)((ConstraintViolationException)validate.get()).getConstraintViolations().size()).isEqualTo(1);
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"Illegal flow id update"});
    }

    @Test
    void switchTaskInvalid() {
        Flow flow = this.parse("flows/invalids/switch-invalid.yaml");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isTrue();
        Assertions.assertThat((int)((ConstraintViolationException)validate.get()).getConstraintViolations().size()).isEqualTo(1);
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"impossible: No task defined, neither cases or default have any tasks"});
    }

    @Test
    void workingDirectoryTaskInvalid() {
        Flow flow = this.parse("flows/invalids/workingdirectory-invalid.yaml");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isTrue();
        Assertions.assertThat((int)((ConstraintViolationException)validate.get()).getConstraintViolations().size()).isEqualTo(1);
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"impossible: Only runnable tasks are allowed as children of a WorkingDirectory task"});
    }

    @Test
    void workingDirectoryNoTasks() {
        Flow flow = this.parse("flows/invalids/workingdirectory-no-tasks.yaml");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isTrue();
        Assertions.assertThat((int)((ConstraintViolationException)validate.get()).getConstraintViolations().size()).isEqualTo(2);
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"impossible: The 'tasks' property cannot be empty"});
    }

    @Test
    void updateTask() throws InternalException {
        Flow flow = this.parse("flows/valids/each-sequential-nested.yaml");
        Flow updated = flow.updateTask("1-2-2_return", (Task)((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id("1-2-2_return")).type(Return.class.getName())).format(Property.ofExpression((String)"{{task.id}}")).build());
        Task findUpdated = updated.findTaskByTaskId("1-2-2_return");
        Assertions.assertThat((String)((Return)findUpdated).getFormat().toString()).isEqualTo("{{task.id}}");
    }

    @Test
    void allTasksWithChildsAndTriggerIds() {
        Flow flow = this.parse("flows/valids/trigger-flow-listener-no-inputs.yaml");
        List all = flow.allTasksWithChildsAndTriggerIds();
        Assertions.assertThat((int)all.size()).isEqualTo(3);
    }

    @Test
    void inputValidation() {
        Flow flow = this.parse("flows/invalids/inputs-validation.yaml");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isTrue();
        Assertions.assertThat((int)((ConstraintViolationException)validate.get()).getConstraintViolations().size()).isEqualTo(2);
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"file: inputs of type 'FILE' only support `defaults` as local files using a file URI"});
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"array: `itemType` cannot be `ARRAY"});
    }

    @Test
    void equals() {
        Flow flowA = FlowTest.baseFlow();
        LinkedHashMap<String, String> triggerInputsReverseOrder = new LinkedHashMap<String, String>();
        triggerInputsReverseOrder.put("c", "d");
        triggerInputsReverseOrder.put("a", "b");
        Flow flowABis = ((Flow.FlowBuilder)FlowTest.baseFlow().toBuilder().revision(Integer.valueOf(2))).triggers(List.of(io.kestra.plugin.core.trigger.Flow.builder().inputs(triggerInputsReverseOrder).build())).build();
        Assertions.assertThat((boolean)flowA.equalsWithoutRevision((FlowInterface)flowABis)).isTrue();
        Flow flowB = ((Flow.FlowBuilder)FlowTest.baseFlow().toBuilder().id("b")).build();
        Assertions.assertThat((boolean)flowA.equalsWithoutRevision((FlowInterface)flowB)).isFalse();
        Flow flowAnotherTenant = ((Flow.FlowBuilder)FlowTest.baseFlow().toBuilder().tenantId("b")).build();
        Assertions.assertThat((boolean)flowA.equalsWithoutRevision((FlowInterface)flowAnotherTenant)).isFalse();
    }

    private static Flow baseFlow() {
        LinkedHashMap<String, String> triggerInputs = new LinkedHashMap<String, String>();
        triggerInputs.put("a", "b");
        triggerInputs.put("c", "d");
        return ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id("a")).namespace("a")).revision(Integer.valueOf(1))).tenantId("a")).inputs(List.of(((StringInput.StringInputBuilder)StringInput.builder().id("a")).build(), ((StringInput.StringInputBuilder)StringInput.builder().id("b")).build()))).tasks(List.of(Log.builder().message((Object)"a").build(), Log.builder().message((Object)"b").build())).triggers(List.of(io.kestra.plugin.core.trigger.Flow.builder().inputs(triggerInputs).build())).build();
    }

    private Flow parse(String path) {
        URL resource = TestsUtils.class.getClassLoader().getResource(path);
        assert (resource != null);
        File file = new File(resource.getFile());
        return (Flow)YamlParser.parse((File)file, Flow.class);
    }
}

