/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.kestra.core.models.Label;
import io.kestra.core.models.flows.Concurrency;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.PluginDefault;
import io.kestra.core.models.flows.input.StringInput;
import io.kestra.core.models.listeners.Listener;
import io.kestra.core.models.property.Property;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.IdUtils;
import io.kestra.plugin.core.condition.Expression;
import io.kestra.plugin.core.debug.Return;
import io.kestra.plugin.core.log.Log;
import io.kestra.plugin.core.trigger.Schedule;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FlowWithSourceTest {
    FlowWithSourceTest() {
    }

    @Test
    void source() throws JsonProcessingException {
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)FlowWithSource.builder().id(IdUtils.create())).namespace("io.kestra.unittest")).tasks(List.of(((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id(IdUtils.create())).type(Return.class.getName())).format(Property.ofValue((Object)"123456789 \n123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789\n123456789 \n123456789 \n123456789     \n")).build()))).build();
        flow = flow.toBuilder().source(flow.sourceOrGenerateIfNull()).build();
        String source = flow.getSource();
        Assertions.assertThat((String)source).doesNotContain(new CharSequence[]{"deleted: false"});
        Assertions.assertThat((String)source).contains(new CharSequence[]{"format: |\n"});
    }

    @Test
    void scalar() throws JsonProcessingException {
        FlowWithSource.FlowWithSourceBuilder builder = (FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)FlowWithSource.builder().id(IdUtils.create())).namespace("io.kestra.unittest")).tasks(List.of(((Log.LogBuilder)((Log.LogBuilder)Log.builder().id(IdUtils.create())).type(Log.class.getName())).message((Object)"Hello World").build()))).triggers(List.of(((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).cron("0 1 9 * * *").build()));
        FlowWithSource flow = builder.source(JacksonMapper.ofYaml().writeValueAsString((Object)builder.build())).build();
        String source = flow.getSource();
        Assertions.assertThat((String)source).contains(new CharSequence[]{"message: Hello World"});
        Assertions.assertThat((String)source).contains(new CharSequence[]{"  cron: 0 1 9 * * *"});
    }

    @Test
    void of() {
        FlowWithSource flow = ((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)FlowWithSource.builder().tenantId("tenantId")).id(IdUtils.create())).namespace("io.kestra.unittest")).description("description")).labels(List.of(new Label("key", "value")))).inputs(List.of(((StringInput.StringInputBuilder)StringInput.builder().id("strInput")).build()))).variables(Map.of("varKey", "varValue"))).tasks(List.of(((Log.LogBuilder)((Log.LogBuilder)Log.builder().id(IdUtils.create())).type(Log.class.getName())).message((Object)"Hello World").build()))).errors(List.of(((Log.LogBuilder)((Log.LogBuilder)Log.builder().id(IdUtils.create())).type(Log.class.getName())).message((Object)"Error").build())))._finally(List.of(((Log.LogBuilder)((Log.LogBuilder)Log.builder().id(IdUtils.create())).type(Log.class.getName())).message((Object)"Finally").build()))).listeners(List.of(Listener.builder().conditions(List.of(Expression.builder().expression(Property.ofValue((Object)"true")).build())).build()))).triggers(List.of(((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).cron("0 1 9 * * *").build()))).pluginDefaults(List.of(PluginDefault.builder().type(Log.class.getName()).forced(true).values(Map.of("message", "Default message")).build()))).concurrency(Concurrency.builder().behavior(Concurrency.Behavior.CANCEL).limit(Integer.valueOf(2)).build())).build();
        String expectedSource = flow.sourceOrGenerateIfNull() + " # additional comment";
        FlowWithSource of = FlowWithSource.of((Flow)flow, (String)expectedSource);
        Assertions.assertThat((boolean)of.equalsWithoutRevision((FlowInterface)flow)).isTrue();
        Assertions.assertThat((String)of.getSource()).isEqualTo(expectedSource);
    }
}

