/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.input;

import io.kestra.core.models.flows.input.FileInput;
import jakarta.validation.ConstraintViolationException;
import java.net.URI;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FileInputTest {
    FileInputTest() {
    }

    @Test
    void shouldGetExtensionWhenFindingFileExtensionForExistingFile() {
        List<FileInput> inputs = List.of(((FileInput.FileInputBuilder)FileInput.builder().id("test-file1")).extension(".zip").build(), ((FileInput.FileInputBuilder)FileInput.builder().id("test-file2")).extension(".gz").build());
        String result = FileInput.findFileInputExtension(inputs, (String)"test-file1");
        Assertions.assertEquals((Object)".zip", (Object)result);
    }

    @Test
    void shouldReturnDefaultExtensionWhenFindingExtensionForUnknownFile() {
        List<FileInput> inputs = List.of(((FileInput.FileInputBuilder)FileInput.builder().id("test-file1")).extension(".zip").build(), ((FileInput.FileInputBuilder)FileInput.builder().id("test-file2")).extension(".gz").build());
        String result = FileInput.findFileInputExtension(inputs, (String)"???");
        Assertions.assertEquals((Object)".upl", (Object)result);
    }

    @Test
    void validateValidFileTypes() {
        FileInput csvInput = ((FileInput.FileInputBuilder)FileInput.builder().id("csvFile")).allowedFileExtensions(List.of(".csv")).build();
        Assertions.assertDoesNotThrow(() -> csvInput.validate(URI.create("file:///path/to/file.csv")));
        Assertions.assertDoesNotThrow(() -> csvInput.validate(URI.create("nsfile:///path/to/file.CSV")));
        FileInput docInput = ((FileInput.FileInputBuilder)FileInput.builder().id("docFile")).allowedFileExtensions(List.of(".doc", ".docx", ".pdf")).build();
        Assertions.assertDoesNotThrow(() -> docInput.validate(URI.create("file:///path/to/file.doc")));
        Assertions.assertDoesNotThrow(() -> docInput.validate(URI.create("file:///path/to/file.docx")));
        Assertions.assertDoesNotThrow(() -> docInput.validate(URI.create("file:///path/to/file.pdf")));
    }

    @Test
    void validateInvalidFileTypes() {
        FileInput csvInput = ((FileInput.FileInputBuilder)FileInput.builder().id("csvFile")).allowedFileExtensions(List.of(".csv")).build();
        ConstraintViolationException exception = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> csvInput.validate(URI.create("file:///path/to/file.txt")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"Accepted extensions: .csv"));
        FileInput imageInput = ((FileInput.FileInputBuilder)FileInput.builder().id("imageFile")).allowedFileExtensions(List.of(".jpg", ".png")).build();
        exception = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> imageInput.validate(URI.create("file:///path/to/file.gif")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"Accepted extensions: .jpg, .png"));
    }

    @Test
    void validateMimeTypes() {
        FileInput textInput = ((FileInput.FileInputBuilder)FileInput.builder().id("textFile")).allowedFileExtensions(List.of(".csv", ".json")).build();
        Assertions.assertDoesNotThrow(() -> textInput.validate(URI.create("file:///path/to/file.csv")));
        Assertions.assertDoesNotThrow(() -> textInput.validate(URI.create("file:///path/to/file.json")));
        ConstraintViolationException exception = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> textInput.validate(URI.create("file:///path/to/file.xml")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"Accepted extensions: .csv, .json"));
    }

    @Test
    void validateNullValues() {
        FileInput csvInput = ((FileInput.FileInputBuilder)FileInput.builder().id("csvFile")).allowedFileExtensions(List.of(".csv")).build();
        Assertions.assertDoesNotThrow(() -> csvInput.validate(null));
        FileInput anyInput = ((FileInput.FileInputBuilder)FileInput.builder().id("anyFile")).allowedFileExtensions(null).build();
        Assertions.assertDoesNotThrow(() -> anyInput.validate(URI.create("file:///path/to/any.file")));
    }

    @Test
    void validateEmptyAccept() {
        FileInput anyInput = ((FileInput.FileInputBuilder)FileInput.builder().id("anyFile")).allowedFileExtensions(List.of()).build();
        Assertions.assertDoesNotThrow(() -> anyInput.validate(URI.create("file:///path/to/any.file")));
    }
}

