/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.input;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.Input;
import io.kestra.core.models.flows.RenderableInput;
import io.kestra.core.models.flows.input.SelectInput;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class SelectInputTest {
    @Inject
    RunContextFactory runContextFactory;

    SelectInputTest() {
    }

    @Test
    void shouldRenderInputGivenExpressionReturningStrings() {
        RunContext runContext = this.runContextFactory.of(Map.of("values", List.of("V1", "V2")));
        SelectInput input = ((SelectInput.SelectInputBuilder)SelectInput.builder().id("id")).expression("{{ values }}\n").build();
        Input renderInput = RenderableInput.mayRenderInput((Input)input, s -> {
            try {
                return runContext.renderTyped(s);
            }
            catch (IllegalVariableEvaluationException e) {
                throw new RuntimeException(e);
            }
        });
        Assertions.assertEquals((Object)((SelectInput)renderInput).getValues(), List.of("V1", "V2"));
    }

    @Test
    void shouldRenderInputGivenExpressionReturningIntegers() {
        RunContext runContext = this.runContextFactory.of(Map.of("values", List.of(Integer.valueOf(1), Integer.valueOf(2))));
        SelectInput input = ((SelectInput.SelectInputBuilder)SelectInput.builder().id("id")).expression("{{ values }}").build();
        Input renderInput = RenderableInput.mayRenderInput((Input)input, s -> {
            try {
                return runContext.renderTyped(s);
            }
            catch (IllegalVariableEvaluationException e) {
                throw new RuntimeException(e);
            }
        });
        Assertions.assertEquals((Object)((SelectInput)renderInput).getValues(), List.of("1", "2"));
    }

    @Test
    void staticAutoselectFirst() throws IllegalVariableEvaluationException {
        RunContext runContext = this.runContextFactory.of();
        SelectInput input = ((SelectInput.SelectInputBuilder)SelectInput.builder().id("id")).values(List.of("V1", "V2")).autoSelectFirst(Boolean.valueOf(true)).build();
        Assertions.assertEquals((Object)"V1", runContext.render(input.getDefaults()).as(String.class).orElseThrow());
    }

    @Test
    void dynamicAutoselectFirst() throws IllegalVariableEvaluationException {
        RunContext runContext = this.runContextFactory.of(Map.of("values", List.of("V1", "V2")));
        SelectInput input = ((SelectInput.SelectInputBuilder)SelectInput.builder().id("id")).expression("{{ values }}").autoSelectFirst(Boolean.valueOf(true)).build();
        Assertions.assertNull((Object)input.getDefaults());
        Input renderInput = RenderableInput.mayRenderInput((Input)input, s -> {
            try {
                return runContext.renderTyped(s);
            }
            catch (IllegalVariableEvaluationException e) {
                throw new RuntimeException(e);
            }
        });
        Assertions.assertEquals((Object)"V1", runContext.render(((SelectInput)renderInput).getDefaults()).as(String.class).orElseThrow());
    }
}

