/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.sla.types;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.sla.Violation;
import io.kestra.core.models.flows.sla.types.ExecutionAssertionSLA;
import io.kestra.core.runners.RunContext;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class ExecutionAssertionSLATest {
    @Inject
    private TestRunContextFactory runContextFactory;

    ExecutionAssertionSLATest() {
    }

    @Test
    void shouldEvaluateToAViolation() throws InternalException {
        ExecutionAssertionSLA sla = ExecutionAssertionSLA.builder()._assert("{{ condition == 'true'}}").build();
        RunContext runContext = this.runContextFactory.of(Map.of("condition", "false"));
        Optional evaluate = sla.evaluate(runContext, null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)evaluate.isPresent());
        Assertions.assertThat((String)((Violation)evaluate.get()).reason()).isEqualTo("assertion is false: {{ condition == 'true'}}.");
    }

    @Test
    void shouldEvaluateToNoViolation() throws InternalException {
        ExecutionAssertionSLA sla = ExecutionAssertionSLA.builder()._assert("{{ condition == 'true'}}").build();
        RunContext runContext = this.runContextFactory.of(Map.of("condition", "true"));
        Optional evaluate = sla.evaluate(runContext, null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)evaluate.isEmpty());
    }

    @Test
    void shouldFailToEvaluate() throws InternalException {
        ExecutionAssertionSLA sla = ExecutionAssertionSLA.builder()._assert("{{ condition == 'true'}}").build();
        RunContext runContext = this.runContextFactory.of();
        org.junit.jupiter.api.Assertions.assertThrows(InternalException.class, () -> sla.evaluate(runContext, null));
    }
}

