/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.sla.types;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.flows.sla.Violation;
import io.kestra.core.models.flows.sla.types.MaxDurationSLA;
import java.time.Duration;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MaxDurationSLATest {
    MaxDurationSLATest() {
    }

    @Test
    void shouldEvaluateToAViolation() throws InternalException, InterruptedException {
        MaxDurationSLA maxDurationSLA = MaxDurationSLA.builder().duration(Duration.ofMillis(50L)).build();
        Execution execution = Execution.builder().state(new State().withState(State.Type.RUNNING)).build();
        Thread.sleep(100L);
        Optional evaluate = maxDurationSLA.evaluate(null, execution);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)evaluate.isPresent());
        Assertions.assertThat((String)((Violation)evaluate.get()).reason()).contains(new CharSequence[]{"execution duration of"});
        Assertions.assertThat((String)((Violation)evaluate.get()).reason()).contains(new CharSequence[]{"exceed the maximum duration of PT0.05S."});
    }

    @Test
    void shouldEvaluateToNoViolation() throws InternalException {
        MaxDurationSLA maxDurationSLA = MaxDurationSLA.builder().duration(Duration.ofSeconds(10L)).build();
        Execution execution = Execution.builder().state(new State().withState(State.Type.RUNNING)).build();
        Optional evaluate = maxDurationSLA.evaluate(null, execution);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)evaluate.isEmpty());
    }
}

