/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.property;

import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Data;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.event.Level;

@Plugin
public class DynamicPropertyExampleTask
extends Task
implements RunnableTask<Output>,
Data.From {
    private @NotNull Property<@Min(value=0L) Integer> number;
    @NotNull
    private Property<String> string;
    @NotNull
    private Property<String> withDefault;
    @NotNull
    private Property<Level> level;
    @NotNull
    private Property<Duration> someDuration;
    @NotNull
    private Property<List<String>> items;
    @NotNull
    private Property<Map<String, String>> properties;
    @NotNull
    private Object from;

    public Output run(RunContext runContext) throws Exception {
        String value = String.format("%s - %s - %s - %s", runContext.render(this.string).as(String.class).orElse(null), runContext.render(this.number).as(Integer.class).orElse(null), runContext.render(this.withDefault).as(String.class).orElse(null), runContext.render(this.someDuration).as(Duration.class).orElse(null));
        Level level = runContext.render(this.level).as(Level.class).orElse(null);
        List list = (List)runContext.render(this.items).asList(String.class);
        Map map = (Map)runContext.render(this.properties).asMap(String.class, String.class);
        List outputMessages = (List)Data.from((Object)this.from).readAs(runContext, Message.class, message -> Message.fromMap(message)).collectList().block();
        return ((Output.OutputBuilder)((Output.OutputBuilder)((Output.OutputBuilder)((Output.OutputBuilder)((Output.OutputBuilder)Output.builder().value(value)).level(level)).list(list)).map(map)).messages(outputMessages)).build();
    }

    @Generated
    private static Property<String> $default$withDefault() {
        return Property.ofValue((Object)"Default Value");
    }

    @Generated
    private static Property<Level> $default$level() {
        return Property.ofValue((Object)Level.INFO);
    }

    @Generated
    protected DynamicPropertyExampleTask(DynamicPropertyExampleTaskBuilder<?, ?> b) {
        super(b);
        this.number = b.number;
        this.string = b.string;
        this.withDefault = b.withDefault$set ? b.withDefault$value : DynamicPropertyExampleTask.$default$withDefault();
        this.level = b.level$set ? b.level$value : DynamicPropertyExampleTask.$default$level();
        this.someDuration = b.someDuration;
        this.items = b.items;
        this.properties = b.properties;
        this.from = b.from;
    }

    @Generated
    public static DynamicPropertyExampleTaskBuilder<?, ?> builder() {
        return new DynamicPropertyExampleTaskBuilderImpl();
    }

    @Generated
    public String toString() {
        return "DynamicPropertyExampleTask(super=" + super.toString() + ", number=" + String.valueOf(this.getNumber()) + ", string=" + String.valueOf(this.getString()) + ", withDefault=" + String.valueOf(this.getWithDefault()) + ", level=" + String.valueOf(this.getLevel()) + ", someDuration=" + String.valueOf(this.getSomeDuration()) + ", items=" + String.valueOf(this.getItems()) + ", properties=" + String.valueOf(this.getProperties()) + ", from=" + String.valueOf(this.getFrom()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicPropertyExampleTask)) {
            return false;
        }
        DynamicPropertyExampleTask other = (DynamicPropertyExampleTask)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<Integer> this$number = this.getNumber();
        Property<Integer> other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        Property<String> this$string = this.getString();
        Property<String> other$string = other.getString();
        if (this$string == null ? other$string != null : !this$string.equals(other$string)) {
            return false;
        }
        Property<String> this$withDefault = this.getWithDefault();
        Property<String> other$withDefault = other.getWithDefault();
        if (this$withDefault == null ? other$withDefault != null : !this$withDefault.equals(other$withDefault)) {
            return false;
        }
        Property<Level> this$level = this.getLevel();
        Property<Level> other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        Property<Duration> this$someDuration = this.getSomeDuration();
        Property<Duration> other$someDuration = other.getSomeDuration();
        if (this$someDuration == null ? other$someDuration != null : !this$someDuration.equals(other$someDuration)) {
            return false;
        }
        Property<List<String>> this$items = this.getItems();
        Property<List<String>> other$items = other.getItems();
        if (this$items == null ? other$items != null : !this$items.equals(other$items)) {
            return false;
        }
        Property<Map<String, String>> this$properties = this.getProperties();
        Property<Map<String, String>> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        Object this$from = this.getFrom();
        Object other$from = other.getFrom();
        return !(this$from == null ? other$from != null : !this$from.equals(other$from));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DynamicPropertyExampleTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<Integer> $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        Property<String> $string = this.getString();
        result = result * 59 + ($string == null ? 43 : $string.hashCode());
        Property<String> $withDefault = this.getWithDefault();
        result = result * 59 + ($withDefault == null ? 43 : $withDefault.hashCode());
        Property<Level> $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        Property<Duration> $someDuration = this.getSomeDuration();
        result = result * 59 + ($someDuration == null ? 43 : $someDuration.hashCode());
        Property<List<String>> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : $items.hashCode());
        Property<Map<String, String>> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        Object $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        return result;
    }

    @Generated
    public Property<@Min(value=0L) Integer> getNumber() {
        return this.number;
    }

    @Generated
    public Property<String> getString() {
        return this.string;
    }

    @Generated
    public Property<String> getWithDefault() {
        return this.withDefault;
    }

    @Generated
    public Property<Level> getLevel() {
        return this.level;
    }

    @Generated
    public Property<Duration> getSomeDuration() {
        return this.someDuration;
    }

    @Generated
    public Property<List<String>> getItems() {
        return this.items;
    }

    @Generated
    public Property<Map<String, String>> getProperties() {
        return this.properties;
    }

    @Generated
    public Object getFrom() {
        return this.from;
    }

    @Generated
    public DynamicPropertyExampleTask() {
        this.withDefault = DynamicPropertyExampleTask.$default$withDefault();
        this.level = DynamicPropertyExampleTask.$default$level();
    }

    public static class Message {
        private Object key;
        private Object value;

        private static Message fromMap(Map<String, Object> map) {
            return ((MessageBuilder)((MessageBuilder)Message.builder().key(map.get("key"))).value(map.get("value"))).build();
        }

        @Generated
        protected Message(MessageBuilder<?, ?> b) {
            this.key = b.key;
            this.value = b.value;
        }

        @Generated
        public static MessageBuilder<?, ?> builder() {
            return new MessageBuilderImpl();
        }

        @Generated
        public MessageBuilder<?, ?> toBuilder() {
            return new MessageBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public Object getKey() {
            return this.key;
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public Message() {
        }

        @Generated
        public static abstract class MessageBuilder<C extends Message, B extends MessageBuilder<C, B>> {
            @Generated
            private Object key;
            @Generated
            private Object value;

            @Generated
            protected B $fillValuesFrom(C instance) {
                MessageBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(Message instance, MessageBuilder<?, ?> b) {
                b.key(instance.key);
                b.value(instance.value);
            }

            @Generated
            public B key(Object key) {
                this.key = key;
                return this.self();
            }

            @Generated
            public B value(Object value) {
                this.value = value;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "DynamicPropertyExampleTask.Message.MessageBuilder(key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + ")";
            }
        }

        @Generated
        private static final class MessageBuilderImpl
        extends MessageBuilder<Message, MessageBuilderImpl> {
            @Generated
            private MessageBuilderImpl() {
            }

            @Override
            @Generated
            protected MessageBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Message build() {
                return new Message(this);
            }
        }
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        private String value;
        private Level level;
        private List<String> list;
        private Map<String, String> map;
        private List<Message> messages;

        @Generated
        protected Output(OutputBuilder<?, ?> b) {
            this.value = b.value;
            this.level = b.level;
            this.list = b.list;
            this.map = b.map;
            this.messages = b.messages;
        }

        @Generated
        public static OutputBuilder<?, ?> builder() {
            return new OutputBuilderImpl();
        }

        @Generated
        public OutputBuilder<?, ?> toBuilder() {
            return new OutputBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public Level getLevel() {
            return this.level;
        }

        @Generated
        public List<String> getList() {
            return this.list;
        }

        @Generated
        public Map<String, String> getMap() {
            return this.map;
        }

        @Generated
        public List<Message> getMessages() {
            return this.messages;
        }

        @Generated
        public static abstract class OutputBuilder<C extends Output, B extends OutputBuilder<C, B>> {
            @Generated
            private String value;
            @Generated
            private Level level;
            @Generated
            private List<String> list;
            @Generated
            private Map<String, String> map;
            @Generated
            private List<Message> messages;

            @Generated
            protected B $fillValuesFrom(C instance) {
                OutputBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(Output instance, OutputBuilder<?, ?> b) {
                b.value(instance.value);
                b.level(instance.level);
                b.list(instance.list);
                b.map(instance.map);
                b.messages(instance.messages);
            }

            @Generated
            public B value(String value) {
                this.value = value;
                return this.self();
            }

            @Generated
            public B level(Level level) {
                this.level = level;
                return this.self();
            }

            @Generated
            public B list(List<String> list) {
                this.list = list;
                return this.self();
            }

            @Generated
            public B map(Map<String, String> map) {
                this.map = map;
                return this.self();
            }

            @Generated
            public B messages(List<Message> messages) {
                this.messages = messages;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "DynamicPropertyExampleTask.Output.OutputBuilder(value=" + this.value + ", level=" + String.valueOf(this.level) + ", list=" + String.valueOf(this.list) + ", map=" + String.valueOf(this.map) + ", messages=" + String.valueOf(this.messages) + ")";
            }
        }

        @Generated
        private static final class OutputBuilderImpl
        extends OutputBuilder<Output, OutputBuilderImpl> {
            @Generated
            private OutputBuilderImpl() {
            }

            @Override
            @Generated
            protected OutputBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Output build() {
                return new Output(this);
            }
        }
    }

    @Generated
    public static abstract class DynamicPropertyExampleTaskBuilder<C extends DynamicPropertyExampleTask, B extends DynamicPropertyExampleTaskBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<@Min(value=0L) Integer> number;
        @Generated
        private Property<String> string;
        @Generated
        private boolean withDefault$set;
        @Generated
        private Property<String> withDefault$value;
        @Generated
        private boolean level$set;
        @Generated
        private Property<Level> level$value;
        @Generated
        private Property<Duration> someDuration;
        @Generated
        private Property<List<String>> items;
        @Generated
        private Property<Map<String, String>> properties;
        @Generated
        private Object from;

        @Generated
        public B number(Property<@Min(value=0L) Integer> number) {
            this.number = number;
            return (B)this.self();
        }

        @Generated
        public B string(Property<String> string) {
            this.string = string;
            return (B)this.self();
        }

        @Generated
        public B withDefault(Property<String> withDefault) {
            this.withDefault$value = withDefault;
            this.withDefault$set = true;
            return (B)this.self();
        }

        @Generated
        public B level(Property<Level> level) {
            this.level$value = level;
            this.level$set = true;
            return (B)this.self();
        }

        @Generated
        public B someDuration(Property<Duration> someDuration) {
            this.someDuration = someDuration;
            return (B)this.self();
        }

        @Generated
        public B items(Property<List<String>> items) {
            this.items = items;
            return (B)this.self();
        }

        @Generated
        public B properties(Property<Map<String, String>> properties) {
            this.properties = properties;
            return (B)this.self();
        }

        @Generated
        public B from(Object from) {
            this.from = from;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder(super=" + super.toString() + ", number=" + String.valueOf(this.number) + ", string=" + String.valueOf(this.string) + ", withDefault$value=" + String.valueOf(this.withDefault$value) + ", level$value=" + String.valueOf(this.level$value) + ", someDuration=" + String.valueOf(this.someDuration) + ", items=" + String.valueOf(this.items) + ", properties=" + String.valueOf(this.properties) + ", from=" + String.valueOf(this.from) + ")";
        }
    }

    @Generated
    private static final class DynamicPropertyExampleTaskBuilderImpl
    extends DynamicPropertyExampleTaskBuilder<DynamicPropertyExampleTask, DynamicPropertyExampleTaskBuilderImpl> {
        @Generated
        private DynamicPropertyExampleTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected DynamicPropertyExampleTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DynamicPropertyExampleTask build() {
            return new DynamicPropertyExampleTask(this);
        }
    }
}

