/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.property;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.DynamicPropertyExampleTask;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.FileSerde;
import io.kestra.core.storages.StorageInterface;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.beans.ConstructorProperties;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;
import reactor.core.publisher.Flux;

@KestraTest
class PropertyTest {
    @Inject
    private TestRunContextFactory runContextFactory;
    @Inject
    private StorageInterface storage;

    PropertyTest() {
    }

    @Test
    void test() throws Exception {
        Task task = ((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)DynamicPropertyExampleTask.builder().number((Property<Integer>)Property.ofExpression((String)"{{numberValue}}")))).string((Property<String>)Property.ofExpression((String)"{{stringValue}}")))).level((Property<Level>)Property.ofExpression((String)"{{levelValue}}")))).someDuration((Property<Duration>)Property.ofExpression((String)"{{durationValue}}")))).withDefault((Property<String>)Property.ofExpression((String)"{{defaultValue}}")))).items((Property<List<String>>)Property.ofExpression((String)"[\"{{item1}}\", \"{{item2}}\"]")))).properties((Property<Map<String, String>>)Property.ofExpression((String)"{\n  \"key1\": \"{{value1}}\",\n  \"key2\": \"{{value2}}\"\n}")))).from("{\n  \"key\": \"{{mapKey}}\",\n  \"value\": \"{{mapValue}}\"\n}"))).build();
        RunContext runContext = this.runContextFactory.of(Map.ofEntries(Map.entry("numberValue", 9), Map.entry("stringValue", "test"), Map.entry("levelValue", "INFO"), Map.entry("durationValue", "PT60S"), Map.entry("defaultValue", "not-default"), Map.entry("item1", "item1"), Map.entry("item2", "item2"), Map.entry("value1", "value1"), Map.entry("value2", "value2"), Map.entry("mapKey", "mapKey"), Map.entry("mapValue", "mapValue")));
        DynamicPropertyExampleTask.Output output = task.run(runContext);
        Assertions.assertThat((Object)output).isNotNull();
        Assertions.assertThat((String)output.getValue()).isEqualTo("test - 9 - not-default - PT1M");
        Assertions.assertThat((Comparable)output.getLevel()).isEqualTo((Object)Level.INFO);
        Assertions.assertThat(output.getList()).containsExactlyInAnyOrder((Object[])new String[]{"item1", "item2"});
        Assertions.assertThat(output.getMap()).hasSize(2);
        Assertions.assertThat((String)output.getMap().get("key1")).isEqualTo("value1");
        Assertions.assertThat((String)output.getMap().get("key2")).isEqualTo("value2");
        Assertions.assertThat(output.getMessages()).hasSize(1);
        Assertions.assertThat((Object)output.getMessages().getFirst().getKey()).isEqualTo((Object)"mapKey");
        Assertions.assertThat((Object)output.getMessages().getFirst().getValue()).isEqualTo((Object)"mapValue");
    }

    @Test
    void withDefaultsAndMessagesFromList() throws Exception {
        Task task = ((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)DynamicPropertyExampleTask.builder().number((Property<Integer>)Property.ofExpression((String)"{{numberValue}}")))).string((Property<String>)Property.ofExpression((String)"{{stringValue}}")))).level((Property<Level>)Property.ofExpression((String)"{{levelValue}}")))).someDuration((Property<Duration>)Property.ofExpression((String)"{{durationValue}}")))).items((Property<List<String>>)Property.ofExpression((String)"[\"{{item1}}\", \"{{item2}}\"]")))).properties((Property<Map<String, String>>)Property.ofExpression((String)"{\n  \"key1\": \"{{value1}}\",\n  \"key2\": \"{{value2}}\"\n}")))).from("[\n  {\n     \"key\": \"{{mapKey1}}\",\n     \"value\": \"{{mapValue1}}\"\n  },\n  {\n     \"key\": \"{{mapKey2}}\",\n     \"value\": \"{{mapValue2}}\"\n   }\n]"))).build();
        RunContext runContext = this.runContextFactory.of(Map.ofEntries(Map.entry("numberValue", 9), Map.entry("stringValue", "test"), Map.entry("levelValue", "INFO"), Map.entry("durationValue", "PT60S"), Map.entry("item1", "item1"), Map.entry("item2", "item2"), Map.entry("value1", "value1"), Map.entry("value2", "value2"), Map.entry("mapKey1", "mapKey1"), Map.entry("mapValue1", "mapValue1"), Map.entry("mapKey2", "mapKey2"), Map.entry("mapValue2", "mapValue2")));
        DynamicPropertyExampleTask.Output output = task.run(runContext);
        Assertions.assertThat((Object)output).isNotNull();
        Assertions.assertThat((String)output.getValue()).isEqualTo("test - 9 - Default Value - PT1M");
        Assertions.assertThat((Comparable)output.getLevel()).isEqualTo((Object)Level.INFO);
        Assertions.assertThat(output.getList()).containsExactlyInAnyOrder((Object[])new String[]{"item1", "item2"});
        Assertions.assertThat(output.getMap()).hasSize(2);
        Assertions.assertThat((String)output.getMap().get("key1")).isEqualTo("value1");
        Assertions.assertThat((String)output.getMap().get("key2")).isEqualTo("value2");
        Assertions.assertThat(output.getMessages()).hasSize(2);
        Assertions.assertThat((Object)output.getMessages().getFirst().getKey()).isEqualTo((Object)"mapKey1");
        Assertions.assertThat((Object)output.getMessages().getFirst().getValue()).isEqualTo((Object)"mapValue1");
        Assertions.assertThat((Object)output.getMessages().get(1).getKey()).isEqualTo((Object)"mapKey2");
        Assertions.assertThat((Object)output.getMessages().get(1).getValue()).isEqualTo((Object)"mapValue2");
    }

    @Test
    void withMessagesFromURI() throws Exception {
        URI uri;
        Path messages = Files.createTempFile("messages", ".ion", new FileAttribute[0]);
        List inputValues = List.of(((DynamicPropertyExampleTask.Message.MessageBuilder)((DynamicPropertyExampleTask.Message.MessageBuilder)DynamicPropertyExampleTask.Message.builder().key("key1")).value("value1")).build(), ((DynamicPropertyExampleTask.Message.MessageBuilder)((DynamicPropertyExampleTask.Message.MessageBuilder)DynamicPropertyExampleTask.Message.builder().key("key2")).value("value2")).build());
        FileSerde.writeAll((Writer)Files.newBufferedWriter(messages, new OpenOption[0]), (Flux)Flux.fromIterable(inputValues)).block();
        try (FileInputStream input = new FileInputStream(messages.toFile());){
            uri = this.storage.put("main", null, URI.create("/messages.ion"), (InputStream)input);
        }
        Task task = ((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)DynamicPropertyExampleTask.builder().number((Property<Integer>)Property.ofExpression((String)"{{numberValue}}")))).string((Property<String>)Property.ofExpression((String)"{{stringValue}}")))).level((Property<Level>)Property.ofExpression((String)"{{levelValue}}")))).someDuration((Property<Duration>)Property.ofExpression((String)"{{durationValue}}")))).withDefault((Property<String>)Property.ofExpression((String)"{{defaultValue}}")))).items((Property<List<String>>)Property.ofExpression((String)"[\"{{item1}}\", \"{{item2}}\"]")))).properties((Property<Map<String, String>>)Property.ofExpression((String)"{\n  \"key1\": \"{{value1}}\",\n  \"key2\": \"{{value2}}\"\n}")))).from("{{uri}}"))).build();
        RunContext runContext = this.runContextFactory.of(Map.ofEntries(Map.entry("numberValue", 9), Map.entry("stringValue", "test"), Map.entry("levelValue", "INFO"), Map.entry("durationValue", "PT60S"), Map.entry("defaultValue", "not-default"), Map.entry("item1", "item1"), Map.entry("item2", "item2"), Map.entry("value1", "value1"), Map.entry("value2", "value2"), Map.entry("uri", uri)));
        DynamicPropertyExampleTask.Output output = task.run(runContext);
        Assertions.assertThat((Object)output).isNotNull();
        Assertions.assertThat((String)output.getValue()).isEqualTo("test - 9 - not-default - PT1M");
        Assertions.assertThat((Comparable)output.getLevel()).isEqualTo((Object)Level.INFO);
        Assertions.assertThat(output.getList()).containsExactlyInAnyOrder((Object[])new String[]{"item1", "item2"});
        Assertions.assertThat(output.getMap()).hasSize(2);
        Assertions.assertThat((String)output.getMap().get("key1")).isEqualTo("value1");
        Assertions.assertThat((String)output.getMap().get("key2")).isEqualTo("value2");
        Assertions.assertThat(output.getMessages()).hasSize(2);
        Assertions.assertThat((Object)output.getMessages().getFirst().getKey()).isEqualTo((Object)"key1");
        Assertions.assertThat((Object)output.getMessages().getFirst().getValue()).isEqualTo((Object)"value1");
        Assertions.assertThat((Object)output.getMessages().get(1).getKey()).isEqualTo((Object)"key2");
        Assertions.assertThat((Object)output.getMessages().get(1).getValue()).isEqualTo((Object)"value2");
    }

    @Test
    void failingToRender() throws Exception {
        Task task = ((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)DynamicPropertyExampleTask.builder().number((Property<Integer>)Property.ofExpression((String)"{{numberValue}}")))).string((Property<String>)Property.ofExpression((String)"{{stringValue}}")))).level((Property<Level>)Property.ofExpression((String)"{{levelValue}}")))).someDuration((Property<Duration>)Property.ofExpression((String)"{{durationValue}}")))).withDefault((Property<String>)Property.ofExpression((String)"{{defaultValue}}")))).items((Property<List<String>>)Property.ofExpression((String)"[\"{{item1}}\", \"{{item2}}\"]")))).from(Map.of("key", "{{mapValue}}")))).build();
        RunContext runContext = this.runContextFactory.of();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> PropertyTest.lambda$failingToRender$0((DynamicPropertyExampleTask)task, runContext));
    }

    @Test
    void shouldFailValidation() throws Exception {
        Task task = ((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)DynamicPropertyExampleTask.builder().id("dynamic")).type(DynamicPropertyExampleTask.class.getName())).number((Property<Integer>)Property.ofExpression((String)"{{numberValue}}")))).string((Property<String>)Property.ofExpression((String)"{{stringValue}}")))).level((Property<Level>)Property.ofExpression((String)"{{levelValue}}")))).someDuration((Property<Duration>)Property.ofExpression((String)"{{durationValue}}")))).items((Property<List<String>>)Property.ofExpression((String)"[\"{{item1}}\", \"{{item2}}\"]")))).properties((Property<Map<String, String>>)Property.ofExpression((String)"{\n  \"key1\": \"{{value1}}\",\n  \"key2\": \"{{value2}}\"\n}")))).from(Map.of("key", "{{mapKey}}", "value", "{{mapValue}}")))).build();
        RunContext runContext = this.runContextFactory.of(task, Map.ofEntries(Map.entry("numberValue", -2), Map.entry("stringValue", "test"), Map.entry("levelValue", "INFO"), Map.entry("durationValue", "PT60S"), Map.entry("item1", "item1"), Map.entry("item2", "item2"), Map.entry("value1", "value1"), Map.entry("value2", "value2"), Map.entry("mapKey", "mapKey"), Map.entry("mapValue", "mapValue")));
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> PropertyTest.lambda$shouldFailValidation$1((DynamicPropertyExampleTask)task, runContext));
        Assertions.assertThat((int)exception.getConstraintViolations().size()).isEqualTo(1);
        Assertions.assertThat((String)exception.getMessage()).isEqualTo("number: must be greater than or equal to 0");
    }

    @Test
    void ofValue() {
        Property prop = Property.ofValue((Object)TestObj.builder().key("key").value("value").build());
        Assertions.assertThat((Object)prop).isNotNull();
    }

    @Test
    void arrayAndMapToRender() throws Exception {
        Task task = ((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)DynamicPropertyExampleTask.builder().items((Property<List<String>>)Property.ofExpression((String)"{{renderOnce(listToRender)}}")))).properties((Property<Map<String, String>>)Property.ofExpression((String)"{{renderOnce(mapToRender)}}")))).build();
        RunContext runContext = this.runContextFactory.of(Map.ofEntries(Map.entry("arrayValueToRender", "arrayValue1"), Map.entry("listToRender", List.of("{{arrayValueToRender}}", "arrayValue2")), Map.entry("mapKeyToRender", "mapKey1"), Map.entry("mapValueToRender", "mapValue1"), Map.entry("mapToRender", Map.of("{{mapKeyToRender}}", "{{mapValueToRender}}", "mapKey2", "mapValue2"))));
        DynamicPropertyExampleTask.Output output = task.run(runContext);
        Assertions.assertThat((Object)output).isNotNull();
        Assertions.assertThat(output.getList()).containsExactlyInAnyOrder((Object[])new String[]{"arrayValue1", "arrayValue2"});
        Assertions.assertThat(output.getMap()).hasSize(2);
        Assertions.assertThat((String)output.getMap().get("mapKey1")).isEqualTo("mapValue1");
        Assertions.assertThat((String)output.getMap().get("mapKey2")).isEqualTo("mapValue2");
    }

    @Test
    void aListToRender() throws Exception {
        Task task = ((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)DynamicPropertyExampleTask.builder().items((Property<List<String>>)Property.ofExpression((String)"[\"python test.py --input1 \\\"{{ item1 }}\\\" --input2 \\\"{{ item2 }}\\\"\", \"'gs://{{ renderOnce(\\\"bucket\\\") }}/{{ 'table' }}/{{ 'file' }}_*.csv.gz'\"]")))).properties((Property<Map<String, String>>)Property.ofExpression((String)"{\n  \"key1\": \"{{value1}}\",\n  \"key2\": \"{{value2}}\"\n}")))).build();
        RunContext runContext = this.runContextFactory.of(Map.ofEntries(Map.entry("item1", "item1"), Map.entry("item2", "item2"), Map.entry("value1", "value1"), Map.entry("value2", "value2")));
        DynamicPropertyExampleTask.Output output = task.run(runContext);
        Assertions.assertThat((Object)output).isNotNull();
        Assertions.assertThat(output.getList()).containsExactlyInAnyOrder((Object[])new String[]{"python test.py --input1 \"item1\" --input2 \"item2\"", "'gs://bucket/table/file_*.csv.gz'"});
    }

    @Test
    void fromMessage() throws Exception {
        Task task = ((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)DynamicPropertyExampleTask.builder().items((Property<List<String>>)Property.ofExpression((String)"[\"python test.py --input1 \\\"{{ item1 }}\\\" --input2 \\\"{{ item2 }}\\\"\", \"'gs://{{ renderOnce(\\\"bucket\\\") }}/{{ 'table' }}/{{ 'file' }}_*.csv.gz'\"]")))).properties((Property<Map<String, String>>)Property.ofExpression((String)"{\n  \"key1\": \"{{value1}}\",\n  \"key2\": \"{{value2}}\"\n}")))).from(((DynamicPropertyExampleTask.Message.MessageBuilder)((DynamicPropertyExampleTask.Message.MessageBuilder)DynamicPropertyExampleTask.Message.builder().key("key")).value("value")).build()))).build();
        RunContext runContext = this.runContextFactory.of(Map.ofEntries(Map.entry("item1", "item1"), Map.entry("item2", "item2"), Map.entry("value1", "value1"), Map.entry("value2", "value2")));
        DynamicPropertyExampleTask.Output output = task.run(runContext);
        Assertions.assertThat((Object)output).isNotNull();
        Assertions.assertThat(output.getMessages()).hasSize(1);
        Assertions.assertThat((Object)output.getMessages().getFirst().getKey()).isEqualTo((Object)"key");
        Assertions.assertThat((Object)output.getMessages().getFirst().getValue()).isEqualTo((Object)"value");
    }

    @Test
    void fromListOfMessages() throws Exception {
        Task task = ((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)((DynamicPropertyExampleTask.DynamicPropertyExampleTaskBuilder)((Object)DynamicPropertyExampleTask.builder().items((Property<List<String>>)Property.ofExpression((String)"[\"python test.py --input1 \\\"{{ item1 }}\\\" --input2 \\\"{{ item2 }}\\\"\", \"'gs://{{ renderOnce(\\\"bucket\\\") }}/{{ 'table' }}/{{ 'file' }}_*.csv.gz'\"]")))).properties((Property<Map<String, String>>)Property.ofExpression((String)"{\n  \"key1\": \"{{value1}}\",\n  \"key2\": \"{{value2}}\"\n}")))).from(List.of(((DynamicPropertyExampleTask.Message.MessageBuilder)((DynamicPropertyExampleTask.Message.MessageBuilder)DynamicPropertyExampleTask.Message.builder().key("key1")).value("value1")).build(), ((DynamicPropertyExampleTask.Message.MessageBuilder)((DynamicPropertyExampleTask.Message.MessageBuilder)DynamicPropertyExampleTask.Message.builder().key("key2")).value("value2")).build())))).build();
        RunContext runContext = this.runContextFactory.of(Map.ofEntries(Map.entry("item1", "item1"), Map.entry("item2", "item2"), Map.entry("value1", "value1"), Map.entry("value2", "value2")));
        DynamicPropertyExampleTask.Output output = task.run(runContext);
        Assertions.assertThat((Object)output).isNotNull();
        Assertions.assertThat(output.getMessages()).hasSize(2);
        Assertions.assertThat((Object)output.getMessages().getFirst().getKey()).isEqualTo((Object)"key1");
        Assertions.assertThat((Object)output.getMessages().getFirst().getValue()).isEqualTo((Object)"value1");
    }

    private static /* synthetic */ void lambda$shouldFailValidation$1(DynamicPropertyExampleTask task, RunContext runContext) throws Throwable {
        task.run(runContext);
    }

    private static /* synthetic */ void lambda$failingToRender$0(DynamicPropertyExampleTask task, RunContext runContext) throws Throwable {
        task.run(runContext);
    }

    private static class TestObj {
        private String key;
        private String value;

        @ConstructorProperties(value={"key", "value"})
        @Generated
        TestObj(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Generated
        public static TestObjBuilder builder() {
            return new TestObjBuilder();
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public static class TestObjBuilder {
            @Generated
            private String key;
            @Generated
            private String value;

            @Generated
            TestObjBuilder() {
            }

            @Generated
            public TestObjBuilder key(String key) {
                this.key = key;
                return this;
            }

            @Generated
            public TestObjBuilder value(String value) {
                this.value = value;
                return this;
            }

            @Generated
            public TestObj build() {
                return new TestObj(this.key, this.value);
            }

            @Generated
            public String toString() {
                return "PropertyTest.TestObj.TestObjBuilder(key=" + this.key + ", value=" + this.value + ")";
            }
        }
    }
}

