/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.property;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.URIFetcher;
import io.kestra.core.runners.LocalPath;
import io.kestra.core.runners.LocalPathFactory;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@KestraTest
class URIFetcherTest {
    @Inject
    private StorageInterface storage;
    @Inject
    private RunContextFactory runContextFactory;

    URIFetcherTest() {
    }

    @Test
    void supports() {
        Assertions.assertThat((boolean)URIFetcher.supports((String)"kestra://something.something")).isTrue();
        Assertions.assertThat((boolean)URIFetcher.supports((String)"file:///path/something.something")).isTrue();
        Assertions.assertThat((boolean)URIFetcher.supports((String)"Some kestra stuff")).isFalse();
    }

    @Test
    void shouldFetchFromInternalStorage() throws URISyntaxException, IOException {
        URI uri = this.storageUpload();
        RunContext runContext = this.buildRunContext();
        try (InputStream fetched = URIFetcher.of((URI)uri).fetch(runContext);){
            String str = new String(fetched.readAllBytes());
            Assertions.assertThat((String)str).isEqualTo("Hello World");
        }
    }

    @Test
    void shouldFailToFetchFromLocalFileWhenNotAllowed() throws IOException {
        URI uri = this.createFile();
        RunContext runContext = this.buildRunContext();
        org.junit.jupiter.api.Assertions.assertThrows(SecurityException.class, () -> {
            InputStream ignored = URIFetcher.of((URI)uri).fetch(runContext);
            if (ignored != null) {
                ignored.close();
            }
        });
    }

    @Test
    void shouldFetchFromLocalFileWhenAllowedGlobally() throws IOException {
        URI uri = this.createFile();
        RunContext runContext = this.buildRunContext(List.of("/tmp"));
        try (InputStream fetch = URIFetcher.of((URI)uri).fetch(runContext);){
            String fetchedContent = new String(fetch.readAllBytes());
            Assertions.assertThat((String)fetchedContent).isEqualTo("Hello World");
        }
    }

    @Test
    void shouldFetchFromLocalFileWhenAllowedForPlugin() throws IOException {
        URI uri = this.createFile();
        RunContext runContext = this.buildRunContext(Collections.emptyList(), List.of("/tmp"));
        try (InputStream fetch = URIFetcher.of((URI)uri).fetch(runContext);){
            String fetchedContent = new String(fetch.readAllBytes());
            Assertions.assertThat((String)fetchedContent).isEqualTo("Hello World");
        }
    }

    @Test
    void shouldFetchFromNsfile() throws IOException {
        String namespace = IdUtils.create();
        URI uri = this.createNsFile(namespace, false);
        RunContext runContext = this.runContextFactory.of(Map.of("flow", Map.of("namespace", namespace)));
        try (InputStream fetch = URIFetcher.of((URI)uri).fetch(runContext);){
            String fetchedContent = new String(fetch.readAllBytes());
            Assertions.assertThat((String)fetchedContent).isEqualTo("Hello World");
        }
    }

    @Test
    void shouldFetchFromNsfileFromOtherNs() throws IOException {
        String namespace = IdUtils.create();
        URI uri = this.createNsFile(namespace, true);
        RunContext runContext = this.runContextFactory.of(Map.of("flow", Map.of("namespace", "other")));
        try (InputStream fetch = URIFetcher.of((URI)uri).fetch(runContext);){
            String fetchedContent = new String(fetch.readAllBytes());
            Assertions.assertThat((String)fetchedContent).isEqualTo("Hello World");
        }
    }

    private RunContext buildRunContext() {
        return this.buildRunContext(Collections.emptyList(), Collections.emptyList());
    }

    private RunContext buildRunContext(List<String> globalAllowedPaths) {
        return this.buildRunContext(globalAllowedPaths, Collections.emptyList());
    }

    private RunContext buildRunContext(List<String> globalAllowedPaths, List<String> pluginAllowedPath) {
        RunContext spy = (RunContext)Mockito.spy((Object)this.runContextFactory.of());
        LocalPath localPath = new LocalPathFactory(globalAllowedPaths).createLocalPath(spy);
        Mockito.when((Object)spy.localPath()).thenReturn((Object)localPath);
        Mockito.when((Object)spy.pluginConfiguration(Mockito.anyString())).thenReturn(Optional.of(pluginAllowedPath));
        return spy;
    }

    private URI createFile() throws IOException {
        File tempFile = File.createTempFile("file", ".txt");
        Files.write(tempFile.toPath(), "Hello World".getBytes(), new OpenOption[0]);
        return tempFile.toPath().toUri();
    }

    private URI storageUpload() throws URISyntaxException, IOException {
        File tempFile = File.createTempFile("file", ".txt");
        Files.write(tempFile.toPath(), "Hello World".getBytes(), new OpenOption[0]);
        return this.storage.put("main", null, new URI("/file/storage/file.txt"), (InputStream)new FileInputStream(tempFile));
    }

    private URI createNsFile(String namespace, boolean nsInAuthority) throws IOException {
        String filePath = "file.txt";
        this.storage.createDirectory("main", namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace)));
        this.storage.put("main", namespace, URI.create(StorageContext.namespaceFilePrefix((String)namespace) + "/" + filePath), (InputStream)new ByteArrayInputStream("Hello World".getBytes()));
        return URI.create("nsfile://" + (nsInAuthority ? namespace : "") + "/" + filePath);
    }
}

