/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.logs;

import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.tasks.logs.LogRecord;
import io.kestra.core.models.tasks.logs.LogRecordMapper;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.event.Level;

@ExtendWith(value={SoftAssertionsExtension.class})
public class LogRecordMapperTest {
    @Test
    public void should_map_to_log_entry_to_log_record(BDDSoftAssertions softly) {
        LogRecord logRecord = LogRecordMapper.mapToLogRecord((LogEntry)LogEntry.builder().tenantId("tenantId").namespace("namespace").flowId("flowId").taskId("taskId").executionId("executionId").taskRunId("taskRunId").attemptNumber(Integer.valueOf(1)).triggerId("triggerId").timestamp(Instant.parse("2011-12-03T10:15:30.123456789Z")).level(Level.INFO).thread("thread").message("message").build());
        softly.then(logRecord.getResource()).isEqualTo("Kestra");
        softly.then(logRecord.getTimestampEpochNanos()).isEqualTo(1322907330123456789L);
        softly.then(logRecord.getSeverity()).isEqualTo("INFO");
        softly.then(logRecord.getAttributes().get("tenantId")).isEqualTo((Object)"tenantId");
        softly.then(logRecord.getAttributes().get("namespace")).isEqualTo((Object)"namespace");
        softly.then(logRecord.getAttributes().get("flowId")).isEqualTo((Object)"flowId");
        softly.then(logRecord.getAttributes().get("taskId")).isEqualTo((Object)"taskId");
        softly.then(logRecord.getAttributes().get("executionId")).isEqualTo((Object)"executionId");
        softly.then(logRecord.getAttributes().get("taskRunId")).isEqualTo((Object)"taskRunId");
        softly.then(logRecord.getAttributes().get("attemptNumber")).isEqualTo((Object)1);
        softly.then(logRecord.getAttributes().get("triggerId")).isEqualTo((Object)"triggerId");
        softly.then(logRecord.getAttributes().get("thread")).isEqualTo((Object)"thread");
        softly.then(logRecord.getAttributes().get("message")).isEqualTo((Object)"message");
        softly.then(logRecord.getBodyValue()).isEqualTo("2011-12-03T10:15:30.123456789Z INFO message");
    }

    @Test
    public void should_map_with_truncate() {
        LogEntry logEntry = LogEntry.builder().tenantId("tenantId").namespace("namespace").flowId("flowId").taskId("taskId").executionId("executionId").taskRunId("taskRunId").attemptNumber(Integer.valueOf(1)).triggerId("triggerId").timestamp(Instant.parse("2011-12-03T10:15:30.123456789Z")).level(Level.INFO).thread("thread").message("message").build();
        LogRecord logRecord = LogRecordMapper.mapToLogRecord((LogEntry)logEntry, (Integer)1);
        Assertions.assertThat((String)logRecord.getBodyValue()).isEqualTo("2011-12-03T10:15:30.123456789Z INFO m");
        logRecord = LogRecordMapper.mapToLogRecord((LogEntry)logEntry, (Integer)0);
        Assertions.assertThat((String)logRecord.getBodyValue()).isEqualTo("2011-12-03T10:15:30.123456789Z INFO message");
    }

    @Test
    public void should_convert_instant_in_nanos() {
        Instant instant = Instant.parse("2011-12-03T10:15:30.123456789Z");
        Assertions.assertThat((long)LogRecordMapper.instantInNanos((Instant)instant)).isEqualTo(1322907330123456789L);
    }
}

